/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;

public class SunJaxWsBean {
    public static final String XML_ENDPOINT = "endpoint";
    public static final String XML_ALIAS = "name";
    public static final String XML_SERVICE = "service";
    public static final String XML_PORT = "port";
    public static final String XML_WSDL = "wsdl";
    public static final String XML_IMPLEMENTATION = "implementation";
    public static final String XML_URL_PATTERN = "url-pattern";
    public static final String XML_HANDLER_CHAINS = "handler-chains";
    public static final String XML_HANDLER_CHAIN = "handler-chain";
    public static final String XML_HANDLER = "handler";
    public static final String XML_HANDLER_CLASS = "handler-class";
    public static final String NS_ENDPOINT = "http://java.sun.com/xml/ns/jax-ws/ri/runtime";
    public static final String NS_HANDLER_CHAINS = "http://java.sun.com/xml/ns/javaee";
    public static final String XML_HANDLER_FILTER_PROTOCOL = "protocol-bindings";
    public static final String XML_HANDLER_FILTER_SERVICE = "service-name-pattern";
    public static final String XML_HANDLER_FILTER_PORT = "port-name-pattern";
    private ScoutXmlDocument.ScoutXmlElement m_xml;

    public SunJaxWsBean(ScoutXmlDocument.ScoutXmlElement xml) {
        this.m_xml = xml;
    }

    public ScoutXmlDocument.ScoutXmlElement getXml() {
        return this.m_xml;
    }

    public void setXml(ScoutXmlDocument.ScoutXmlElement xml) {
        this.m_xml = xml;
    }

    public String getAlias() {
        return this.m_xml.getAttribute(XML_ALIAS, null);
    }

    public void setAlias(String alias) {
        this.m_xml.removeAttribute(XML_ALIAS);
        this.m_xml.setAttribute(XML_ALIAS, alias);
    }

    public String getImplementation() {
        return this.m_xml.getAttribute(XML_IMPLEMENTATION, null);
    }

    public void setImplementation(String implementation) {
        this.m_xml.removeAttribute(XML_IMPLEMENTATION);
        this.m_xml.setAttribute(XML_IMPLEMENTATION, implementation);
    }

    public String getService() {
        return this.m_xml.getAttribute(XML_SERVICE, null);
    }

    public QName getServiceQNameSafe() {
        try {
            return QName.valueOf(this.getService());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setService(String service) {
        this.m_xml.removeAttribute(XML_SERVICE);
        this.m_xml.setAttribute(XML_SERVICE, service);
    }

    public String getPort() {
        return this.m_xml.getAttribute(XML_PORT, null);
    }

    public QName getPortQNameSafe() {
        try {
            return QName.valueOf(this.getPort());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setPort(String port) {
        this.m_xml.removeAttribute(XML_PORT);
        this.m_xml.setAttribute(XML_PORT, port);
    }

    public String getWsdl() {
        return this.m_xml.getAttribute(XML_WSDL, null);
    }

    public void setWsdl(String wsdl) {
        this.m_xml.removeAttribute(XML_WSDL);
        this.m_xml.setAttribute(XML_WSDL, wsdl);
    }

    public String getUrlPattern() {
        return this.m_xml.getAttribute(XML_URL_PATTERN, null);
    }

    public void setUrlPattern(String urlPattern) {
        this.m_xml.removeAttribute(XML_URL_PATTERN);
        this.m_xml.setAttribute(XML_URL_PATTERN, urlPattern);
    }

    public List<ScoutXmlDocument.ScoutXmlElement> getHandlerChains() {
        ScoutXmlDocument.ScoutXmlElement xmlChains = this.m_xml.getChild(this.toQualifiedName(XML_HANDLER_CHAINS));
        if (xmlChains == null) {
            return new ArrayList<ScoutXmlDocument.ScoutXmlElement>(0);
        }
        List children = xmlChains.getChildren(this.toQualifiedName(XML_HANDLER_CHAIN));
        if (children == null) {
            return new ArrayList<ScoutXmlDocument.ScoutXmlElement>(0);
        }
        ArrayList<ScoutXmlDocument.ScoutXmlElement> chains = new ArrayList<ScoutXmlDocument.ScoutXmlElement>();
        for (ScoutXmlDocument.ScoutXmlElement child : children) {
            chains.add(child);
        }
        return chains;
    }

    public void setHandlerChains(List<ScoutXmlDocument.ScoutXmlElement> xmlHandlerChains) {
        if (this.m_xml.hasChild(this.toQualifiedName(XML_HANDLER_CHAINS))) {
            this.m_xml.removeChildren(this.toQualifiedName(XML_HANDLER_CHAINS));
        }
        for (ScoutXmlDocument.ScoutXmlElement chain : xmlHandlerChains) {
            this.m_xml.addChild(chain);
        }
    }

    public String toQualifiedName(String elementName) {
        return StringUtility.join((String)":", (Object[])new Object[]{this.m_xml.getRoot().getNamePrefix(), elementName});
    }

    public void visitHandlers(IHandlerVisitor visitor) {
        String handlerXmlElementName = this.toQualifiedName(XML_HANDLER);
        String handlerClazzXmlElementName = this.toQualifiedName(XML_HANDLER_CLASS);
        for (ScoutXmlDocument.ScoutXmlElement xmlHandlerChain : this.getHandlerChains()) {
            List children = xmlHandlerChain.getChildren(handlerXmlElementName);
            if (children == null || children.size() == 0) continue;
            LinkedList<ScoutXmlDocument.ScoutXmlElement> handlers = new LinkedList<ScoutXmlDocument.ScoutXmlElement>();
            for (ScoutXmlDocument.ScoutXmlElement child : children) {
                handlers.add(child);
            }
            int i = 0;
            while (i < handlers.size()) {
                ScoutXmlDocument.ScoutXmlElement xmlHandler = (ScoutXmlDocument.ScoutXmlElement)handlers.get(i);
                ScoutXmlDocument.ScoutXmlElement xmlHandlerClazzElement = xmlHandler.getChild(handlerClazzXmlElementName);
                String fqn = null;
                if (xmlHandlerClazzElement != null) {
                    fqn = xmlHandlerClazzElement.getText();
                }
                if (!visitor.visit(xmlHandler, fqn, i, handlers.size())) {
                    return;
                }
                ++i;
            }
        }
    }

    public void visitHandlers(ScoutXmlDocument.ScoutXmlElement xmlHandlerChain, IHandlerVisitor visitor) {
        String handlerXmlElementName = this.toQualifiedName(XML_HANDLER);
        String handlerClazzXmlElementName = this.toQualifiedName(XML_HANDLER_CLASS);
        List children = xmlHandlerChain.getChildren(handlerXmlElementName);
        if (children == null || children.size() == 0) {
            return;
        }
        LinkedList<ScoutXmlDocument.ScoutXmlElement> handlers = new LinkedList<ScoutXmlDocument.ScoutXmlElement>();
        for (ScoutXmlDocument.ScoutXmlElement child : children) {
            handlers.add(child);
        }
        int i = 0;
        while (i < handlers.size()) {
            ScoutXmlDocument.ScoutXmlElement xmlHandler = (ScoutXmlDocument.ScoutXmlElement)handlers.get(i);
            ScoutXmlDocument.ScoutXmlElement xmlHandlerClazzElement = xmlHandler.getChild(handlerClazzXmlElementName);
            String fqn = null;
            if (xmlHandlerClazzElement != null) {
                fqn = xmlHandlerClazzElement.getText();
            }
            if (!visitor.visit(xmlHandler, fqn, i, handlers.size())) {
                return;
            }
            ++i;
        }
    }

    public boolean swapHandler(ScoutXmlDocument.ScoutXmlElement xmlHandlerChain, int oldIndex, int newIndex) {
        String handlerXmlElementName = this.toQualifiedName(XML_HANDLER);
        List handlerChildren = xmlHandlerChain.getChildren(handlerXmlElementName);
        try {
            Collections.swap(handlerChildren, oldIndex, newIndex);
            xmlHandlerChain.removeChildren((Collection)handlerChildren);
            xmlHandlerChain.addChildren(handlerChildren);
            return true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    public boolean reload(IScoutBundle bundle) {
        ScoutXmlDocument newDocument = ResourceFactory.getSunJaxWsResource(bundle).loadXml();
        if (newDocument == null || newDocument.getRoot() == null) {
            return false;
        }
        ScoutXmlDocument.ScoutXmlElement rootXml = newDocument.getRoot();
        if (rootXml == null || !rootXml.hasChild(this.toQualifiedName(XML_ENDPOINT))) {
            return false;
        }
        ScoutXmlDocument.ScoutXmlElement xml = rootXml.getChild(this.toQualifiedName(XML_ENDPOINT), XML_ALIAS, this.getAlias());
        if (xml == null) {
            return false;
        }
        this.setXml(xml);
        return true;
    }

    public static SunJaxWsBean load(IScoutBundle bundle, String alias) {
        if (!StringUtility.hasText((String)alias)) {
            return null;
        }
        ScoutXmlDocument document = ResourceFactory.getSunJaxWsResource(bundle).loadXml();
        if (document == null || document.getRoot() == null) {
            return null;
        }
        ScoutXmlDocument.ScoutXmlElement rootXml = document.getRoot();
        if (rootXml == null || !rootXml.hasChild(XML_ENDPOINT)) {
            return null;
        }
        ScoutXmlDocument.ScoutXmlElement xml = rootXml.getChild(StringUtility.join((String)":", (Object[])new Object[]{rootXml.getRoot().getNamePrefix(), XML_ENDPOINT}), XML_ALIAS, alias);
        if (xml == null) {
            return null;
        }
        return new SunJaxWsBean(xml);
    }

    public static interface IHandlerVisitor {
        public boolean visit(ScoutXmlDocument.ScoutXmlElement var1, String var2, int var3, int var4);
    }
}

