/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.pages;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.resource.IResourceListener;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.ConsumerNewWizardAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.IJaxWsPageConstants;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceConsumerNodePage;

public class WebServiceConsumerTablePage
extends AbstractPage {
    private IScoutBundle m_bundle;
    private IPrimaryTypeTypeHierarchy m_hierarchy;
    private ITypeHierarchyChangedListener m_hierarchyChangedListener;
    private IResourceListener m_resourceListener;

    public WebServiceConsumerTablePage(IPage parent) {
        this.setParent(parent);
        this.setName(Texts.get("Services"));
        this.setImageDescriptor(JaxWsSdk.getImageDescriptor("webservice_folder.png"));
        this.m_bundle = this.getScoutResource();
        this.m_hierarchyChangedListener = new P_TypeHierarchyChangedListener();
        this.m_hierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)TypeUtility.getType((String)"org.eclipse.scout.jaxws.service.AbstractWebServiceClient"));
        this.m_hierarchy.addHierarchyListener(this.m_hierarchyChangedListener);
        this.m_resourceListener = new P_BuildJaxWsResourceListener();
        this.getBuildJaxWsResource().addResourceListener(4, this.m_resourceListener);
        this.getBuildJaxWsResource().addResourceListener("", this.m_resourceListener);
    }

    public String getPageId() {
        return IJaxWsPageConstants.WEBSERVICE_CONSUMER_TABLE_PAGE;
    }

    public void unloadPage() {
        if (this.m_hierarchy != null && this.m_hierarchyChangedListener != null) {
            this.m_hierarchy.removeHierarchyListener(this.m_hierarchyChangedListener);
        }
        this.getBuildJaxWsResource().removeResourceListener(this.m_resourceListener);
        super.unloadPage();
    }

    public boolean isFolder() {
        return true;
    }

    public void refresh(boolean clearCache) {
        if (clearCache) {
            this.m_hierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof ConsumerNewWizardAction) {
            ((ConsumerNewWizardAction)menu).init(this.getScoutResource());
        }
    }

    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{ConsumerNewWizardAction.class};
    }

    protected void loadChildrenImpl() {
        IType[] wsConsumerTypes;
        IType[] iTypeArray = wsConsumerTypes = this.m_hierarchy.getAllSubtypes(TypeUtility.getType((String)"org.eclipse.scout.jaxws.service.AbstractWebServiceClient"), TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()), TypeComparators.getTypeNameComparator());
        int n = wsConsumerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType consumerType = iTypeArray[n2];
            new WebServiceConsumerNodePage((IPage)this, consumerType);
            ++n2;
        }
    }

    public XmlResource getBuildJaxWsResource() {
        return ResourceFactory.getBuildJaxWsResource(this.m_bundle);
    }

    private class P_BuildJaxWsResourceListener
    implements IResourceListener {
        private P_BuildJaxWsResourceListener() {
        }

        @Override
        public void changed(String element, int event) {
            WebServiceConsumerTablePage.this.markStructureDirty();
        }
    }

    private class P_TypeHierarchyChangedListener
    implements ITypeHierarchyChangedListener {
        private P_TypeHierarchyChangedListener() {
        }

        public void handleEvent(int eventType, IType type) {
            switch (eventType) {
                case 4: 
                case 6: {
                    IScoutBundle bundle = ScoutSdkCore.getScoutWorkspace().getScoutBundle(type.getJavaProject().getProject());
                    if (bundle.getScoutProject() != WebServiceConsumerTablePage.this.getScoutResource().getScoutProject()) break;
                    WebServiceConsumerTablePage.this.markStructureDirty();
                }
            }
        }
    }
}

