/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.part;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.PageFilterPresenter;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.AbstractSinglePageSectionBasedViewPart;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.ConsumerNewWizardAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.FileOpenAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceConsumerTablePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.ActionPresenter;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.layout.GridData;

public class WebServiceConsumerTablePagePropertyViewPart
extends AbstractSinglePageSectionBasedViewPart {
    public static final String SECTION_ID_FILTER = "section.jaxws.filter";
    public static final String SECTION_ID_LINKS = "section.jaxws.links";
    public static final String SECTION_ID_CONSUMER = "section.jaxws.wsconsumer";
    private IScoutBundle m_bundle;

    protected void init() {
        this.m_bundle = this.getPage().getScoutResource();
    }

    protected void createSections() {
        this.getForm().setRedraw(false);
        try {
            ActionPresenter actionPresenter;
            this.createSection(SECTION_ID_FILTER, Texts.get("Filter"));
            this.getSection(SECTION_ID_FILTER).setExpanded(false);
            this.createSection(SECTION_ID_LINKS, Texts.get("ConsiderLinks"));
            this.createSection(SECTION_ID_CONSUMER, Texts.get("WebserviceConsumer"));
            boolean sectionLinksVisible = false;
            PageFilterPresenter filterPresenter = new PageFilterPresenter(this.getFormToolkit(), this.getSection(SECTION_ID_FILTER).getSectionClient(), (IPage)this.getPage());
            this.applyLayoutData((AbstractPresenter)filterPresenter);
            IFile buildJaxWsFile = ResourceFactory.getBuildJaxWsResource(this.m_bundle).getFile();
            if (JaxWsSdkUtility.exists((IResource)buildJaxWsFile)) {
                FileOpenAction b = new FileOpenAction();
                b.init(buildJaxWsFile, buildJaxWsFile.getName(), JaxWsSdk.getImageDescriptor("build-jaxws.png"), FileOpenAction.FileExtensionType.Xml);
                b.setToolTip(Texts.get("JaxWsBuildDescriptor"));
                actionPresenter = new ActionPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), b, this.getFormToolkit());
                this.applyLayoutData(actionPresenter);
                sectionLinksVisible = true;
            }
            ConsumerNewWizardAction action = new ConsumerNewWizardAction();
            action.init(this.m_bundle);
            actionPresenter = new ActionPresenter(this.getSection(SECTION_ID_CONSUMER).getSectionClient(), action, this.getFormToolkit());
            this.applyLayoutData(actionPresenter);
            this.getSection(SECTION_ID_LINKS).setVisible(sectionLinksVisible);
        }
        finally {
            this.getForm().setRedraw(true);
        }
    }

    public WebServiceConsumerTablePage getPage() {
        return (WebServiceConsumerTablePage)super.getPage();
    }

    private void applyLayoutData(AbstractPresenter presenter) {
        GridData layoutData = new GridData(768);
        presenter.getContainer().setLayoutData((Object)layoutData);
    }
}

