/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsProviderCodeFirstDeleteOperation;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.ElementBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.ResourceSelectionWizardPage;

public class WsProviderCodeFirstDeleteWizard
extends AbstractWorkspaceWizard {
    private ResourceSelectionWizardPage m_wizardPage;
    private IScoutBundle m_bundle;
    private SunJaxWsBean m_sunJaxWsBean;
    private WsProviderCodeFirstDeleteOperation m_operation;

    public WsProviderCodeFirstDeleteWizard() {
        this.setWindowTitle(Texts.get("DeleteWebServiceProvider"));
    }

    public void addPages() {
        this.m_wizardPage = new ResourceSelectionWizardPage(Texts.get("DeleteWebServiceProvider"), Texts.get("QuestionDeletion"));
        this.m_wizardPage.setElements(this.getElementsToBeDeleted());
        this.addPage((IWizardPage)this.m_wizardPage);
    }

    private List<ElementBean> getElementsToBeDeleted() {
        LinkedList<ElementBean> elements = new LinkedList<ElementBean>();
        elements.add(new ElementBean(1, "Registration entry in sun-jaxws.xml and build-jaxws.xml", JaxWsSdk.getImageDescriptor("sunJaxWs.png"), true));
        String fqn = this.m_sunJaxWsBean.getImplementation();
        if (TypeUtility.existsType((String)fqn)) {
            IType portType = TypeUtility.getType((String)fqn);
            elements.add(new ElementBean(4, "Port type '" + portType.getFullyQualifiedName() + "'", ScoutSdkUi.getImageDescriptor((String)"class_obj.gif"), (IJavaElement)portType, false));
        }
        return elements;
    }

    protected boolean beforeFinish() throws CoreException {
        this.m_operation = new WsProviderCodeFirstDeleteOperation();
        this.m_operation.setBundle(this.m_bundle);
        this.m_operation.setSunJaxWsBean(this.m_sunJaxWsBean);
        LinkedList<ElementBean> elements = new LinkedList<ElementBean>();
        for (ElementBean element : this.m_wizardPage.getElements()) {
            if (!element.isChecked() && !element.isMandatory()) continue;
            elements.add(element);
        }
        this.m_operation.setElements(elements);
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        OperationJob job = new OperationJob(new IOperation[]{this.m_operation});
        job.schedule();
        return true;
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public SunJaxWsBean getSunJaxWsBean() {
        return this.m_sunJaxWsBean;
    }

    public void setSunJaxWsBean(SunJaxWsBean sunJaxWsBean) {
        this.m_sunJaxWsBean = sunJaxWsBean;
    }
}

