/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page;

import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class HandlerChainFilterWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_FILTER_TYPE = "filterType";
    public static final String PROP_NAMESPACE_PREFIX = "namespacePrefix";
    public static final String PROP_NAMESPACE = "namespace";
    public static final String PROP_PATTERN = "pattern";
    private BasicPropertySupport m_propertySupport;
    private IScoutBundle m_bundle;
    private Button m_filterTypeNoneButton;
    private Button m_filterTypeProtocolButton;
    private Button m_filterTypeServiceButton;
    private Button m_filterTypePortButton;
    private Composite m_filterTypeProtocolComposite;
    private Composite m_filterTypeServiceComposite;
    private Composite m_filterTypePortComposite;
    private Map<Button, Composite> m_radioButtonMap;
    private StyledTextField m_protocolBindings;
    private StyledTextField m_serviceNamespacePrefix;
    private StyledTextField m_serviceNamespace;
    private StyledTextField m_servicePattern;
    private StyledTextField m_portNamespacePrefix;
    private StyledTextField m_portNamespace;
    private StyledTextField m_portPattern;

    public HandlerChainFilterWizardPage(IScoutBundle bundle) {
        super(HandlerChainFilterWizardPage.class.getName());
        this.setTitle(Texts.get("HandlerChainFilter"));
        this.setDescription(Texts.get("DescriptionHandlerChainFilter"));
        this.m_radioButtonMap = new HashMap<Button, Composite>();
        this.m_bundle = bundle;
        this.m_propertySupport = new BasicPropertySupport((Object)this);
    }

    protected void createContent(Composite parent) {
        this.m_filterTypeNoneButton = this.createRadioButton(parent, FilterTypeEnum.NoFilter);
        this.m_radioButtonMap.put(this.m_filterTypeNoneButton, null);
        this.m_filterTypeProtocolButton = this.createRadioButton(parent, FilterTypeEnum.ProtocolFilter);
        this.m_filterTypeProtocolComposite = new Composite(parent, 0);
        this.m_radioButtonMap.put(this.m_filterTypeProtocolButton, this.m_filterTypeProtocolComposite);
        this.m_protocolBindings = new StyledTextField(this.m_filterTypeProtocolComposite, Texts.get("ProtocolBindings"));
        this.m_protocolBindings.setToolTipText(Texts.get("TooltipProtocolBindings"));
        this.m_protocolBindings.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HandlerChainFilterWizardPage.this.setPatternInternal(HandlerChainFilterWizardPage.this.m_protocolBindings.getText());
                HandlerChainFilterWizardPage.this.pingStateChanging();
            }
        });
        if (this.getFilterType() == FilterTypeEnum.ProtocolFilter) {
            this.m_protocolBindings.setText(this.getPattern());
        }
        this.m_filterTypeServiceButton = this.createRadioButton(parent, FilterTypeEnum.ServiceFilter);
        this.m_filterTypeServiceComposite = new Composite(parent, 0);
        this.m_radioButtonMap.put(this.m_filterTypeServiceButton, this.m_filterTypeServiceComposite);
        this.m_serviceNamespacePrefix = new StyledTextField(this.m_filterTypeServiceComposite, Texts.get("NamespacePrefix"));
        this.m_serviceNamespacePrefix.setToolTipText(Texts.get("TooltipNamespacePrefix"));
        this.m_serviceNamespacePrefix.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HandlerChainFilterWizardPage.this.setNamespacePrefixInternal(HandlerChainFilterWizardPage.this.m_serviceNamespacePrefix.getText());
                HandlerChainFilterWizardPage.this.pingStateChanging();
            }
        });
        this.m_serviceNamespace = new StyledTextField(this.m_filterTypeServiceComposite, Texts.get("Namespace"));
        this.m_serviceNamespace.setToolTipText(Texts.get("TooltipNamespace"));
        this.m_serviceNamespace.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HandlerChainFilterWizardPage.this.setNamespaceInternal(HandlerChainFilterWizardPage.this.m_serviceNamespace.getText());
                HandlerChainFilterWizardPage.this.pingStateChanging();
            }
        });
        this.m_servicePattern = new StyledTextField(this.m_filterTypeServiceComposite, Texts.get("RestrictionPattern"));
        this.m_servicePattern.setToolTipText(Texts.get("TooltipRestriction", Texts.get("services")));
        this.m_servicePattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HandlerChainFilterWizardPage.this.setPatternInternal(HandlerChainFilterWizardPage.this.m_servicePattern.getText());
                HandlerChainFilterWizardPage.this.pingStateChanging();
            }
        });
        if (this.getFilterType() == FilterTypeEnum.ServiceFilter) {
            this.m_serviceNamespacePrefix.setText(this.getNamespacePrefix());
            this.m_serviceNamespace.setText(this.getNamespace());
            this.m_servicePattern.setText(this.getPattern());
        }
        this.m_filterTypePortButton = this.createRadioButton(parent, FilterTypeEnum.PortFilter);
        this.m_filterTypePortComposite = new Composite(parent, 0);
        this.m_radioButtonMap.put(this.m_filterTypePortButton, this.m_filterTypePortComposite);
        this.m_portNamespacePrefix = new StyledTextField(this.m_filterTypePortComposite, Texts.get("NamespacePrefix"));
        this.m_portNamespacePrefix.setToolTipText(Texts.get("TooltipNamespacePrefix"));
        this.m_portNamespacePrefix.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HandlerChainFilterWizardPage.this.setNamespacePrefixInternal(HandlerChainFilterWizardPage.this.m_portNamespacePrefix.getText());
                HandlerChainFilterWizardPage.this.pingStateChanging();
            }
        });
        this.m_portNamespace = new StyledTextField(this.m_filterTypePortComposite, Texts.get("Namespace"));
        this.m_portNamespace.setToolTipText(Texts.get("TooltipNamespace"));
        this.m_portNamespace.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HandlerChainFilterWizardPage.this.setNamespaceInternal(HandlerChainFilterWizardPage.this.m_portNamespace.getText());
                HandlerChainFilterWizardPage.this.pingStateChanging();
            }
        });
        this.m_portPattern = new StyledTextField(this.m_filterTypePortComposite, Texts.get("RestrictionPattern"));
        this.m_portPattern.setToolTipText(Texts.get("TooltipRestriction", Texts.get("ports")));
        this.m_portPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HandlerChainFilterWizardPage.this.setPatternInternal(HandlerChainFilterWizardPage.this.m_portPattern.getText());
                HandlerChainFilterWizardPage.this.pingStateChanging();
            }
        });
        if (this.getFilterType() == FilterTypeEnum.PortFilter) {
            this.m_portNamespacePrefix.setText(this.getNamespacePrefix());
            this.m_portNamespace.setText(this.getNamespace());
            this.m_portPattern.setText(this.getPattern());
        }
        parent.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(40, 5);
        formData.right = new FormAttachment(100, 0);
        this.m_filterTypeNoneButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_filterTypeNoneButton, 10, 1024);
        formData.left = new FormAttachment(40, 5);
        formData.right = new FormAttachment(100, 0);
        this.m_filterTypeProtocolButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_filterTypeProtocolButton, 5, 1024);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_filterTypeProtocolComposite.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_filterTypeProtocolComposite, 10, 1024);
        formData.left = new FormAttachment(40, 5);
        formData.right = new FormAttachment(100, 0);
        this.m_filterTypeServiceButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_filterTypeServiceButton, 5, 1024);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_filterTypeServiceComposite.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_filterTypeServiceComposite, 10, 1024);
        formData.left = new FormAttachment(40, 5);
        formData.right = new FormAttachment(100, 0);
        this.m_filterTypePortButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_filterTypePortButton, 5, 1024);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_filterTypePortComposite.setLayoutData((Object)formData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        this.m_filterTypeProtocolComposite.setLayout((Layout)gridLayout);
        this.m_protocolBindings.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout(1, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        this.m_filterTypeServiceComposite.setLayout((Layout)gridLayout);
        this.m_serviceNamespacePrefix.setLayoutData((Object)new GridData(768));
        this.m_serviceNamespace.setLayoutData((Object)new GridData(768));
        this.m_servicePattern.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout(1, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        this.m_filterTypePortComposite.setLayout((Layout)gridLayout);
        this.m_portNamespacePrefix.setLayoutData((Object)new GridData(768));
        this.m_portNamespace.setLayoutData((Object)new GridData(768));
        this.m_portPattern.setLayoutData((Object)new GridData(768));
    }

    private Button createRadioButton(Composite parent, final FilterTypeEnum filterType) {
        Button button = new Button(parent, 16);
        button.setData((Object)filterType);
        button.setText(filterType.getLabel());
        button.setSelection(this.getFilterType() == filterType);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HandlerChainFilterWizardPage.this.setFilterType(filterType);
            }
        });
        return button;
    }

    protected void validatePage(MultiStatus multiStatus) {
        switch (this.getFilterType()) {
            case ServiceFilter: 
            case PortFilter: {
                if (!StringUtility.hasText((String)this.getNamespacePrefix())) {
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", Texts.get("NamespacePrefix"))));
                    break;
                }
                if (!StringUtility.hasText((String)this.getNamespace())) {
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", Texts.get("Namespace"))));
                    break;
                }
                if (StringUtility.hasText((String)this.getPattern()) && !this.getPattern().equals(String.valueOf(this.getNamespacePrefix()) + ":")) break;
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", Texts.get("RestrictionPattern"))));
                break;
            }
            case ProtocolFilter: {
                if (StringUtility.hasText((String)this.getPattern())) break;
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", Texts.get("ProtocolBindings"))));
            }
        }
    }

    public void setPattern(String pattern) {
        try {
            this.setStateChanging(true);
            this.setPatternInternal(pattern);
            if (this.isControlCreated()) {
                this.m_protocolBindings.setText("");
                this.m_servicePattern.setText("");
                this.m_portPattern.setText("");
                switch (this.getFilterType()) {
                    case ProtocolFilter: {
                        this.m_protocolBindings.setText(pattern);
                        break;
                    }
                    case ServiceFilter: {
                        this.m_servicePattern.setText(pattern);
                        break;
                    }
                    case PortFilter: {
                        this.m_portPattern.setText(pattern);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setPatternInternal(String pattern) {
        this.m_propertySupport.setPropertyString(PROP_PATTERN, pattern);
    }

    public String getPattern() {
        return this.m_propertySupport.getPropertyString(PROP_PATTERN);
    }

    public void setNamespacePrefix(String namespacePrefix) {
        try {
            this.setStateChanging(true);
            this.setNamespacePrefixInternal(namespacePrefix);
            if (this.isControlCreated()) {
                switch (this.getFilterType()) {
                    case ServiceFilter: {
                        this.m_serviceNamespacePrefix.setText(namespacePrefix);
                        break;
                    }
                    case PortFilter: {
                        this.m_portNamespacePrefix.setText(namespacePrefix);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void prefixNamespace() {
        if (!this.isControlCreated()) {
            return;
        }
        String prefix = this.getNamespacePrefix();
        if (!StringUtility.hasText((String)prefix)) {
            this.m_servicePattern.setReadOnlyPrefix(null);
            this.m_portPattern.setReadOnlyPrefix(null);
        } else {
            prefix = String.valueOf(prefix) + ":";
            switch (this.getFilterType()) {
                case ServiceFilter: {
                    this.m_portPattern.setReadOnlyPrefix(null);
                    this.m_servicePattern.setReadOnlyPrefix(prefix);
                    break;
                }
                case PortFilter: {
                    this.m_servicePattern.setReadOnlyPrefix(null);
                    this.m_portPattern.setReadOnlyPrefix(prefix);
                }
            }
        }
    }

    private void setNamespacePrefixInternal(String namespacePrefix) {
        this.m_propertySupport.setPropertyString(PROP_NAMESPACE_PREFIX, namespacePrefix);
        this.prefixNamespace();
    }

    public String getNamespacePrefix() {
        return this.m_propertySupport.getPropertyString(PROP_NAMESPACE_PREFIX);
    }

    public void setNamespace(String namespace) {
        try {
            this.setStateChanging(true);
            this.setNamespaceInternal(namespace);
            if (this.isControlCreated()) {
                switch (this.getFilterType()) {
                    case ServiceFilter: {
                        this.m_serviceNamespace.setText(namespace);
                        break;
                    }
                    case PortFilter: {
                        this.m_portNamespace.setText(namespace);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setNamespaceInternal(String namespace) {
        this.m_propertySupport.setPropertyString(PROP_NAMESPACE, namespace);
    }

    public String getNamespace() {
        return this.m_propertySupport.getPropertyString(PROP_NAMESPACE);
    }

    public void setFilterType(FilterTypeEnum filterType) {
        try {
            this.setStateChanging(true);
            this.setFilterTypeInternal(filterType);
            if (this.isControlCreated()) {
                for (Map.Entry<Button, Composite> entry : this.m_radioButtonMap.entrySet()) {
                    Button button = entry.getKey();
                    Composite composite = entry.getValue();
                    FilterTypeEnum id = (FilterTypeEnum)((Object)button.getData());
                    button.setSelection(id == filterType);
                    if (composite != null) {
                        JaxWsSdkUtility.setView(composite, id == filterType);
                    }
                    switch (filterType) {
                        case NoFilter: {
                            this.m_protocolBindings.setText("");
                            this.m_portNamespacePrefix.setText("");
                            this.m_portNamespace.setText("");
                            this.m_portPattern.setText("");
                            this.m_serviceNamespacePrefix.setText("");
                            this.m_serviceNamespace.setText("");
                            this.m_servicePattern.setText("");
                            this.setNamespace(null);
                            this.setNamespacePrefix(null);
                            break;
                        }
                        case ServiceFilter: {
                            this.m_protocolBindings.setText("");
                            this.m_portNamespacePrefix.setText("");
                            this.m_portNamespace.setText("");
                            this.m_portPattern.setText("");
                            this.setNamespace("urn:namespace");
                            this.setNamespacePrefix("ns1");
                            break;
                        }
                        case PortFilter: {
                            this.m_protocolBindings.setText("");
                            this.m_serviceNamespacePrefix.setText("");
                            this.m_serviceNamespace.setText("");
                            this.m_servicePattern.setText("");
                            this.setNamespace("urn:namespace");
                            this.setNamespacePrefix("ns1");
                            break;
                        }
                        case ProtocolFilter: {
                            this.m_serviceNamespacePrefix.setText("");
                            this.m_serviceNamespace.setText("");
                            this.m_servicePattern.setText("");
                            this.m_portNamespacePrefix.setText("");
                            this.m_portNamespace.setText("");
                            this.m_portPattern.setText("");
                            this.setNamespace(null);
                            this.setNamespacePrefix(null);
                            this.setPattern("##SOAP11_HTTP");
                        }
                    }
                }
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setFilterTypeInternal(FilterTypeEnum filterType) {
        this.m_propertySupport.setProperty(PROP_FILTER_TYPE, (Object)filterType);
    }

    public FilterTypeEnum getFilterType() {
        return (FilterTypeEnum)((Object)this.m_propertySupport.getProperty(PROP_FILTER_TYPE));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
        super.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
        super.removePropertyChangeListener(listener);
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public static enum FilterTypeEnum {
        NoFilter(Texts.get("NoFilter")),
        ProtocolFilter(Texts.get("ProtocolFilter")),
        ServiceFilter(Texts.get("ServiceFilter")),
        PortFilter(Texts.get("PortFilter"));

        private String m_label;

        private FilterTypeEnum(String label) {
            this.m_label = label;
        }

        public String getLabel() {
            return this.m_label;
        }
    }
}

