/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class WsdlFolderViewerFilter
extends ViewerFilter {
    private IScoutBundle m_bundle;
    private IFolder m_rootFolder;

    public WsdlFolderViewerFilter(IScoutBundle bundle, IFolder rootFolder) {
        this.m_bundle = bundle;
        this.m_rootFolder = rootFolder;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!(element instanceof IFolder)) {
            return false;
        }
        IFolder candidateFolder = (IFolder)element;
        if (candidateFolder.getName().startsWith(".")) {
            return false;
        }
        if (this.m_rootFolder == null || !this.m_rootFolder.exists()) {
            return false;
        }
        IPath wsdlRootPath = this.m_rootFolder.getProjectRelativePath();
        IPath candidatePath = candidateFolder.getProjectRelativePath();
        if ((candidatePath = candidatePath.makeRelativeTo(wsdlRootPath)).toPortableString().startsWith("..")) {
            return false;
        }
        return this.m_rootFolder.exists(candidatePath);
    }
}

