/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.util;

import java.util.ArrayList;
import java.util.Arrays;
import javax.wsdl.extensions.schema.Schema;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.SelectionDialog;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaUtility;
import org.eclipse.swt.widgets.Shell;

public class GlobalBindingRegistrationHelper {
    public static SchemaCandidate popupForSchema(IScoutBundle bundle, IFile wsdlFile) throws CoreException {
        SchemaCandidate[] schemaCandidates = GlobalBindingRegistrationHelper.getSchemaCandidates(wsdlFile);
        if (schemaCandidates.length == 0) {
            JaxWsSdk.logWarning("No XML schema found to apply customized binding");
            return null;
        }
        if (schemaCandidates.length == 1) {
            return schemaCandidates[0];
        }
        P_SelectionDialog dialog = new P_SelectionDialog(ScoutSdkUi.getShell(), bundle);
        dialog.setElements(Arrays.asList(schemaCandidates));
        if (dialog.open() == 0) {
            return (SchemaCandidate)dialog.getElement();
        }
        throw new CoreException(Status.CANCEL_STATUS);
    }

    public static SchemaCandidate[] getSchemaCandidates(IFile wsdlFile) {
        SchemaUtility.Artefact[] artefacts = SchemaUtility.getArtefacts(wsdlFile, true);
        ArrayList<SchemaCandidate> candidates = new ArrayList<SchemaCandidate>();
        SchemaUtility.Artefact[] artefactArray = artefacts;
        int n = artefacts.length;
        int n2 = 0;
        while (n2 < n) {
            SchemaUtility.Artefact artefact = artefactArray[n2];
            if (artefact instanceof SchemaUtility.WsdlArtefact) {
                Schema[] schemaArray = ((SchemaUtility.WsdlArtefact)artefact).getInlineSchemas();
                int n3 = schemaArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Schema inlineSchema = schemaArray[n4];
                    candidates.add(new SchemaCandidate(inlineSchema, (SchemaUtility.WsdlArtefact)artefact));
                    ++n4;
                }
            }
            ++n2;
        }
        return candidates.toArray(new SchemaCandidate[candidates.size()]);
    }

    private static class P_SelectionDialog
    extends SelectionDialog<SchemaCandidate> {
        private IScoutBundle m_bundle;

        public P_SelectionDialog(Shell shell, IScoutBundle bundle) {
            super(shell, "XML schema selection", "Which XML schema should be customized?");
            this.m_bundle = bundle;
        }

        @Override
        protected String getConfiguredNameColumnText() {
            return "TargetNamespace";
        }

        @Override
        protected String getConfiguredDescriptionColumnText() {
            return "Schema defining WSDL file";
        }

        @Override
        protected boolean getConfiguredIsDescriptionColumnVisible() {
            return true;
        }

        @Override
        protected void execDecorateElement(SchemaCandidate candidate, ViewerCell cell) {
            if (cell.getColumnIndex() == 0) {
                cell.setText(StringUtility.nvl((Object)SchemaUtility.getSchemaTargetNamespace(candidate.getSchema()), (String)"?"));
                cell.setImage(JaxWsSdk.getImage("wsdl_file_obj.gif"));
            } else {
                IFile wsdlLocationFile = JaxWsSdkUtility.toFile(this.m_bundle, candidate.getWsdlArtefact().getFile());
                String text = wsdlLocationFile != null ? wsdlLocationFile.getName() : "?";
                if (candidate.getWsdlArtefact().getTypeEnum() == SchemaUtility.WsdlArtefact.TypeEnum.RootWsdl) {
                    text = String.valueOf(text) + " (Root WSDL file)";
                }
                cell.setText(text);
            }
        }
    }

    public static class SchemaCandidate {
        private Schema m_schema;
        private SchemaUtility.WsdlArtefact m_wsdlArtefact;

        public SchemaCandidate(Schema schema, SchemaUtility.WsdlArtefact wsdlArtefact) {
            this.m_schema = schema;
            this.m_wsdlArtefact = wsdlArtefact;
        }

        public Schema getSchema() {
            return this.m_schema;
        }

        public void setSchema(Schema schema) {
            this.m_schema = schema;
        }

        public SchemaUtility.WsdlArtefact getWsdlArtefact() {
            return this.m_wsdlArtefact;
        }

        public void setWsdlArtefact(SchemaUtility.WsdlArtefact wsdlArtefact) {
            this.m_wsdlArtefact = wsdlArtefact;
        }
    }
}

