/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.annotation.AnnotationCreateOperation;
import org.eclipse.scout.sdk.operation.util.JavaElementFormatOperation;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class AnnotationUpdateOperation
implements IOperation {
    private IType m_declaringType;
    private IType m_annotationType;
    private Map<String, IType> m_typePropertyMap = new HashMap<String, IType>();
    private Map<String, String> m_stringPropertyMap = new HashMap<String, String>();
    private Set<String> m_propertyRemoveMap = new HashSet<String>();

    public void addTypeProperty(String propertyName, IType type) {
        this.m_typePropertyMap.put(propertyName, type);
    }

    public void addStringProperty(String propertyName, String value) {
        this.m_stringPropertyMap.put(propertyName, value);
    }

    public void removeProperty(String propertyName) {
        this.m_propertyRemoveMap.add(propertyName);
    }

    public void validate() throws IllegalArgumentException {
        if (this.m_declaringType == null) {
            throw new IllegalArgumentException("No declaring type set.");
        }
        if (this.m_annotationType == null) {
            throw new IllegalArgumentException("no Annotation Type set.");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        AnnotationCreateOperation op = new AnnotationCreateOperation((IMember)this.m_declaringType, Signature.createTypeSignature((String)this.m_annotationType.getFullyQualifiedName(), (boolean)true));
        IAnnotation annotation = JaxWsSdkUtility.getAnnotation(this.m_declaringType, this.m_annotationType.getFullyQualifiedName(), false);
        HashMap<String, String> resolvedTypePropertyMap = new HashMap<String, String>();
        if (TypeUtility.exists((IJavaElement)annotation)) {
            IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
            int n = iMemberValuePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                String propertyName = pair.getMemberName();
                Object propertyValue = pair.getValue();
                if (pair.getValueKind() == 11) {
                    resolvedTypePropertyMap.put(propertyName, (String)propertyValue);
                } else if (pair.getValueKind() == 9 && !this.m_stringPropertyMap.containsKey(propertyName)) {
                    this.m_stringPropertyMap.put(propertyName, (String)propertyValue);
                }
                ++n2;
            }
        }
        for (String propertyName : this.m_typePropertyMap.keySet()) {
            IType type = this.m_typePropertyMap.get(propertyName);
            String resolvedTypeName = JaxWsSdkUtility.resolveTypeName(this.m_declaringType, type);
            resolvedTypePropertyMap.put(propertyName, resolvedTypeName);
        }
        for (String propertyName : resolvedTypePropertyMap.keySet()) {
            if (this.m_propertyRemoveMap.contains(propertyName)) continue;
            String resolvedTypeName = (String)resolvedTypePropertyMap.get(propertyName);
            op.addParameter(String.valueOf(propertyName) + " = " + resolvedTypeName + ".class");
        }
        for (String propertyName : this.m_stringPropertyMap.keySet()) {
            if (this.m_propertyRemoveMap.contains(propertyName)) continue;
            op.addParameter(String.valueOf(propertyName) + " = \"" + this.m_stringPropertyMap.get(propertyName) + "\"");
        }
        op.validate();
        op.run(monitor, workingCopyManager);
        JaxWsSdkUtility.createImportDirective(this.m_declaringType, this.m_annotationType);
        for (IType type : this.m_typePropertyMap.values()) {
            JaxWsSdkUtility.createImportDirective(this.m_declaringType, type);
        }
        JaxWsSdkUtility.organizeImports(this.m_declaringType);
        JavaElementFormatOperation wellFormOp = new JavaElementFormatOperation((IMember)this.m_declaringType, true);
        wellFormOp.validate();
        try {
            wellFormOp.run(monitor, workingCopyManager);
        }
        catch (Exception exception) {}
    }

    public String getOperationName() {
        return AnnotationUpdateOperation.class.getName();
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    public void setDeclaringType(IType declaringType) {
        this.m_declaringType = declaringType;
    }

    public IType getAnnotationType() {
        return this.m_annotationType;
    }

    public void setAnnotationType(IType annotationType) {
        this.m_annotationType = annotationType;
    }
}

