/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.action;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.AbstractLinkAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.ScoutWizardDialogEx;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.PhantomJarFilesDeleteWizard;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class CleanupPhantomJarFileAction
extends AbstractLinkAction {
    private IScoutBundle m_bundle;

    public CleanupPhantomJarFileAction() {
        super(Texts.get("CleanupUnreferencedJarFiles"), JaxWsSdk.getImageDescriptor("jar_obj.gif"));
        this.setLeadingText(Texts.get("CleanupUnreferencedJarFilesByClicking"));
        this.setLinkText(Texts.get("here"));
        this.setToolTip(Texts.get("TooltipCleanupUnreferencedJarFiles"));
    }

    public void init(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        IFile[] phantomJarFiles = this.getPhantomJarFiles();
        if (phantomJarFiles.length == 0) {
            MessageBox messageBox = new MessageBox(ScoutSdkUi.getShell(), 34);
            messageBox.setText(Texts.get("Information"));
            messageBox.setMessage(Texts.get("NoPhantomJarFilesFound"));
            messageBox.open();
            return null;
        }
        PhantomJarFilesDeleteWizard wizard = new PhantomJarFilesDeleteWizard(this.m_bundle, phantomJarFiles);
        ScoutWizardDialogEx wizardDialog = new ScoutWizardDialogEx((IWizard)wizard);
        wizardDialog.setHelpAvailable(false);
        wizardDialog.open();
        return null;
    }

    private IFile[] getPhantomJarFiles() {
        IFolder folder = JaxWsSdkUtility.getFolder(this.m_bundle, "ws-stub", false);
        if (folder == null || !folder.exists()) {
            return new IFile[0];
        }
        HashSet<IFile> usedJarFiles = new HashSet<IFile>();
        usedJarFiles.addAll(Arrays.asList(this.getProviderJarFiles()));
        usedJarFiles.addAll(Arrays.asList(this.getConsumerJarFiles()));
        HashSet<IFile> candidates = new HashSet<IFile>();
        try {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                IResource resource = iResourceArray[n2];
                if (resource.exists() && resource.getType() == 1 && (file = (IFile)resource).getFileExtension() != null && file.getFileExtension().equalsIgnoreCase("jar")) {
                    candidates.add(file);
                }
                ++n2;
            }
            HashSet<IFile> phantomJarFiles = new HashSet<IFile>();
            for (IFile candiate : candidates) {
                if (usedJarFiles.contains(candiate)) continue;
                phantomJarFiles.add(candiate);
            }
            return phantomJarFiles.toArray(new IFile[phantomJarFiles.size()]);
        }
        catch (CoreException e) {
            JaxWsSdk.logError(e);
            return new IFile[0];
        }
    }

    private IFile[] getProviderJarFiles() {
        HashSet<IFile> jarFiles = new HashSet<IFile>();
        XmlResource sunJaxWsResource = ResourceFactory.getSunJaxWsResource(this.m_bundle);
        ScoutXmlDocument sunJaxWsXmlDocument = sunJaxWsResource.loadXml();
        if (sunJaxWsXmlDocument == null || sunJaxWsXmlDocument.getRoot() == null) {
            return new IFile[0];
        }
        for (ScoutXmlDocument.ScoutXmlElement sunJaxWsXml : sunJaxWsXmlDocument.getRoot().getChildren(StringUtility.join((String)":", (Object[])new Object[]{sunJaxWsXmlDocument.getRoot().getNamePrefix(), "endpoint"}))) {
            IFile jarFile;
            SunJaxWsBean sunJaxWsBean = new SunJaxWsBean(sunJaxWsXml);
            BuildJaxWsBean buildJaxWsBean = BuildJaxWsBean.load(this.m_bundle, sunJaxWsBean.getAlias(), WebserviceEnum.Provider);
            if (buildJaxWsBean == null || (jarFile = JaxWsSdkUtility.getStubJarFile(this.m_bundle, buildJaxWsBean, sunJaxWsBean.getWsdl())) == null || !jarFile.exists()) continue;
            jarFiles.add(jarFile);
        }
        return jarFiles.toArray(new IFile[jarFiles.size()]);
    }

    private IFile[] getConsumerJarFiles() {
        IType[] wsConsumerTypes;
        HashSet<IFile> jarFiles = new HashSet<IFile>();
        IPrimaryTypeTypeHierarchy hierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)TypeUtility.getType((String)"org.eclipse.scout.jaxws.service.AbstractWebServiceClient"));
        IType[] iTypeArray = wsConsumerTypes = hierarchy.getAllSubtypes(TypeUtility.getType((String)"org.eclipse.scout.jaxws.service.AbstractWebServiceClient"), TypeFilters.getClassesInProject((IJavaProject)this.m_bundle.getJavaProject()));
        int n = wsConsumerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IFile jarFile;
            BuildJaxWsBean buildJaxWsBean;
            IType consumerType = iTypeArray[n2];
            if (TypeUtility.exists((IJavaElement)consumerType) && (buildJaxWsBean = BuildJaxWsBean.load(this.m_bundle, consumerType.getElementName(), WebserviceEnum.Consumer)) != null && (jarFile = JaxWsSdkUtility.getStubJarFile(this.m_bundle, buildJaxWsBean, buildJaxWsBean.getWsdl())) != null && jarFile.exists()) {
                jarFiles.add(jarFile);
            }
            ++n2;
        }
        return jarFiles.toArray(new IFile[jarFiles.size()]);
    }
}

