/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.pages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import javax.wsdl.Definition;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.ScoutSeverityManager;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsConstants;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.marker.IMarkerRebuildListener;
import org.eclipse.scout.sdk.ws.jaxws.marker.MarkerRebuildUtility;
import org.eclipse.scout.sdk.ws.jaxws.marker.MarkerUtility;
import org.eclipse.scout.sdk.ws.jaxws.resource.IResourceListener;
import org.eclipse.scout.sdk.ws.jaxws.resource.ManagedResource;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.WsdlResource;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.RefreshAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.StubRebuildAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.WsConsumerDeleteAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.IJaxWsPageConstants;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceConsumerTablePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.AbstractTypeChangedListener;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPageLoadedListener;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPageReloadNotification;

public class WebServiceConsumerNodePage
extends AbstractScoutTypePage
implements IMarkerRebuildListener,
IPageReloadNotification {
    public static final int DATA_BUILD_JAXWS_ENTRY = 1;
    public static final int DATA_WSDL_FILE = 2;
    public static final int DATA_BINDING_FILE = 4;
    public static final int DATA_STUB_FILES = 8;
    public static final int DATA_JDT_TYPE = 16;
    private Object m_pageLoadedListenerLock;
    private boolean m_pageUnloaded = false;
    private String m_markerGroupUUID;
    private IScoutBundle m_bundle;
    private BuildJaxWsBean m_buildJaxWsBean;
    private IResourceListener m_buildJaxWsResourceListener;
    private IResourceListener m_wsdlResourceListener;
    private IResourceListener m_bindingFileResourceListener;
    private Set<IPageLoadedListener> m_pageLoadedListeners;
    private IResourceListener m_manifestResourceListener;
    private IResourceListener m_stubJarResourceListener;
    private P_TypeChangeListener m_typeChangedListener;
    private WsdlResource m_wsdlResource;
    private Definition m_wsdlDefinition;
    private XmlResource[] m_bindingFileResources;
    private ManagedResource m_manifestResource;
    private ManagedResource m_stubJarResource;

    public WebServiceConsumerNodePage(IPage parent, IType type) {
        this.setParent(parent);
        this.setType(type);
        this.setImageDescriptor(JaxWsSdk.getImageDescriptor("service_obj.gif"));
        this.m_bundle = this.getScoutResource();
        this.m_markerGroupUUID = UUID.randomUUID().toString();
        this.m_wsdlResource = new WsdlResource(this.m_bundle);
        this.m_wsdlResourceListener = new P_WsdlResourceListener();
        this.m_manifestResource = new ManagedResource(this.m_bundle.getProject());
        this.m_manifestResource.setFile(new PluginModelHelper((IProject)this.m_bundle.getProject()).Manifest.getFile());
        this.m_manifestResourceListener = new P_ManifestResourceListener();
        this.m_stubJarResource = new ManagedResource(this.m_bundle.getProject());
        this.m_stubJarResourceListener = new P_StubJarResourceListener();
        this.m_buildJaxWsResourceListener = new P_BuildJaxWsListener();
        this.m_bindingFileResources = new XmlResource[0];
        this.m_bindingFileResourceListener = new P_BindingFileResourceListener();
        this.m_pageLoadedListeners = new HashSet<IPageLoadedListener>();
        this.m_pageLoadedListenerLock = new Object();
        this.getBuildJaxWsResource().addResourceListener(this.getType().getElementName(), this.m_buildJaxWsResourceListener);
        this.getWsdlResource().addResourceListener(7, this.m_wsdlResourceListener);
        this.m_manifestResource.addResourceListener(3, this.m_manifestResourceListener);
        this.m_stubJarResource.addResourceListener(this.m_stubJarResourceListener);
        JaxWsSdk.getDefault().registerPage(WebServiceConsumerNodePage.class, this);
        this.m_typeChangedListener = new P_TypeChangeListener();
        this.m_typeChangedListener.setType(this.getType());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.m_typeChangedListener);
        this.reloadPage(15);
    }

    public String getPageId() {
        return IJaxWsPageConstants.CONSUMER_NODE_PAGE;
    }

    public boolean isFolder() {
        return false;
    }

    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        ArrayList<Class<WsConsumerDeleteAction>> list = new ArrayList<Class<WsConsumerDeleteAction>>();
        Class[] classArray = super.getSupportedMenuActions();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            list.add(c);
            ++n2;
        }
        if (this.getBuildJaxWsBean() != null && !MarkerUtility.containsMarker(this.m_bundle, JaxWsConstants.MarkerType.StubFolder, this.getMarkerGroupUUID(), 2) && !MarkerUtility.containsMarker(this.m_bundle, JaxWsConstants.MarkerType.Wsdl, this.getMarkerGroupUUID(), 2)) {
            list.add(StubRebuildAction.class);
        }
        list.add(RefreshAction.class);
        list.add(WsConsumerDeleteAction.class);
        return list.toArray(new Class[list.size()]);
    }

    public void prepareMenuAction(IScoutHandler menu) {
        super.prepareMenuAction(menu);
        if (menu instanceof WsConsumerDeleteAction) {
            ((WsConsumerDeleteAction)menu).init(this.m_bundle, this.getType(), this.getBuildJaxWsBean());
        } else if (menu instanceof StubRebuildAction) {
            ((StubRebuildAction)menu).init(this.m_bundle, this.getBuildJaxWsBean(), this.getWsdlResource(), this.m_markerGroupUUID, WebserviceEnum.Consumer);
        }
    }

    @Override
    public void reloadPage(int dataMask) {
        try {
            if ((dataMask & 1) > 0) {
                if (this.getBuildJaxWsBean() == null) {
                    this.m_buildJaxWsBean = BuildJaxWsBean.load(this.m_bundle, this.getType().getElementName(), WebserviceEnum.Consumer);
                } else {
                    this.m_buildJaxWsBean.reload(this.m_bundle);
                }
                if (this.m_buildJaxWsBean != null) {
                    this.m_stubJarResource.setFile(JaxWsSdkUtility.getStubJarFile(this.m_bundle, this.m_buildJaxWsBean, this.m_buildJaxWsBean.getWsdl()));
                }
            }
            if ((dataMask & 2) > 0) {
                this.m_wsdlDefinition = this.loadWsdlDefinition();
            }
            if ((dataMask & 4) > 0) {
                this.m_bindingFileResources = this.loadBindingFiles();
            }
            if ((dataMask & 8) > 0) {
                this.m_stubJarResource.setFile(JaxWsSdkUtility.getStubJarFile(this.m_bundle, this.m_buildJaxWsBean, this.m_buildJaxWsBean.getWsdl()));
            }
        }
        catch (Exception e) {
            JaxWsSdk.logError(e);
        }
        this.notifyPageLoadedListeners();
        JaxWsSdk.getDefault().getMarkerQueueManager().queueRequest(this);
    }

    public void refresh(boolean clearCache) {
        if (clearCache) {
            this.reloadPage(7);
        } else {
            JaxWsSdk.getDefault().getMarkerQueueManager().queueRequest(this);
        }
        super.refresh(clearCache);
    }

    public void unloadPage() {
        this.m_pageUnloaded = true;
        MarkerUtility.clearMarkers(this.m_bundle, this.m_markerGroupUUID);
        this.getBuildJaxWsResource().removeResourceListener(this.m_buildJaxWsResourceListener);
        this.getWsdlResource().removeResourceListener(this.m_wsdlResourceListener);
        this.m_manifestResource.removeResourceListener(this.m_manifestResourceListener);
        this.m_stubJarResource.removeResourceListener(this.m_stubJarResourceListener);
        XmlResource[] xmlResourceArray = this.m_bindingFileResources;
        int n = this.m_bindingFileResources.length;
        int n2 = 0;
        while (n2 < n) {
            XmlResource resource = xmlResourceArray[n2];
            resource.removeResourceListener(this.m_bindingFileResourceListener);
            ++n2;
        }
        JaxWsSdk.getDefault().unregisterPage(WebServiceConsumerNodePage.class, this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.m_typeChangedListener);
        super.unloadPage();
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    public int getQuality() {
        int quality = MarkerUtility.getQuality((IPage)this, this.m_bundle, this.m_markerGroupUUID);
        if (quality == 2) {
            return quality;
        }
        if (TypeUtility.exists((IJavaElement)this.getType())) {
            quality = Math.max(quality, ScoutSeverityManager.getInstance().getSeverityOf((Object)this.getType()));
        }
        return quality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void rebuildMarkers() {
        block27: {
            var1_1 = this.m_markerGroupUUID;
            synchronized (var1_1) {
                block26: {
                    block25: {
                        MarkerUtility.clearMarkers(this.m_bundle, this.m_markerGroupUUID);
                        if (!this.isPageUnloaded() && TypeUtility.exists((IJavaElement)this.getType())) break block25;
                        while (true) {
                            resources = new HashSet<IFile>();
                            if (JaxWsSdkUtility.exists((IResource)this.getBuildJaxWsResource().getFile())) {
                                resources.add(this.getBuildJaxWsResource().getFile());
                            }
                            if (JaxWsSdkUtility.exists((IResource)this.getWsdlResource().getFile())) {
                                resources.add(this.getWsdlResource().getFile());
                            }
                            var9_6 = this.m_bindingFileResources;
                            var8_10 = this.m_bindingFileResources.length;
                            var7_14 = 0;
                            while (var7_14 < var8_10) {
                                resource = var9_6[var7_14];
                                if (JaxWsSdkUtility.exists((IResource)resource.getFile())) {
                                    resources.add(resource.getFile());
                                }
                                ++var7_14;
                            }
                            ScoutSeverityManager.getInstance().fireSeverityChanged(resources);
                            return;
                        }
                    }
                    try {
                        try {
                            if (!MarkerRebuildUtility.rebuildBuildJaxWsMarkers(this.getBuildJaxWsResource().getFile(), this.m_buildJaxWsBean, this.getType().getElementName(), this.m_wsdlResource, this.m_markerGroupUUID, this.m_bundle, WebserviceEnum.Consumer) || !MarkerRebuildUtility.rebuildBindingFileMarkers(this.getBuildJaxWsResource().getFile(), this.m_bindingFileResources, this.m_wsdlResource, this.m_markerGroupUUID, this.m_bundle) || !MarkerRebuildUtility.rebuildWebserviceClientType(this.getType(), this.m_buildJaxWsBean, this.m_wsdlResource, this.m_markerGroupUUID, this.m_bundle) || !MarkerRebuildUtility.rebuildWsdlMarkers(this.m_wsdlResource, this.m_buildJaxWsBean, null, this.m_markerGroupUUID, this.m_bundle)) ** continue;
                            portTypeQName = JaxWsSdkUtility.extractPortTypeQNameFromWsClient(this.getType());
                            serviceQName = JaxWsSdkUtility.extractServiceQNameFromWsClient(this.getType());
                            MarkerRebuildUtility.rebuildStubJarFileMarkers(this.m_buildJaxWsBean, this.m_wsdlResource, portTypeQName, serviceQName, this.m_bundle, this.m_markerGroupUUID);
                            break block26;
                        }
                        catch (Exception e) {
                            JaxWsSdk.logWarning("failed to update markers", e);
                            resources = new HashSet<IFile>();
                            if (JaxWsSdkUtility.exists((IResource)this.getBuildJaxWsResource().getFile())) {
                                resources.add(this.getBuildJaxWsResource().getFile());
                            }
                            if (JaxWsSdkUtility.exists((IResource)this.getWsdlResource().getFile())) {
                                resources.add(this.getWsdlResource().getFile());
                            }
                            var9_7 = this.m_bindingFileResources;
                            var8_11 = this.m_bindingFileResources.length;
                            var7_15 = 0;
                            ** while (var7_15 < var8_11)
                        }
                    }
                    catch (Throwable var4_25) {
                        resources = new HashSet<IFile>();
                        if (JaxWsSdkUtility.exists((IResource)this.getBuildJaxWsResource().getFile())) {
                            resources.add(this.getBuildJaxWsResource().getFile());
                        }
                        if (JaxWsSdkUtility.exists((IResource)this.getWsdlResource().getFile())) {
                            resources.add(this.getWsdlResource().getFile());
                        }
                        var9_8 = this.m_bindingFileResources;
                        var8_12 = this.m_bindingFileResources.length;
                        var7_16 = 0;
                        ** while (var7_16 < var8_12)
                    }
lbl-1000:
                    // 1 sources

                    {
                        resource = var9_7[var7_15];
                        if (JaxWsSdkUtility.exists((IResource)resource.getFile())) {
                            resources.add(resource.getFile());
                        }
                        ++var7_15;
                        continue;
                    }
lbl55:
                    // 1 sources

                    ScoutSeverityManager.getInstance().fireSeverityChanged(resources);
                    break block27;
lbl-1000:
                    // 1 sources

                    {
                        resource = var9_8[var7_16];
                        if (JaxWsSdkUtility.exists((IResource)resource.getFile())) {
                            resources.add(resource.getFile());
                        }
                        ++var7_16;
                        continue;
                    }
lbl75:
                    // 1 sources

                    ScoutSeverityManager.getInstance().fireSeverityChanged(resources);
                    throw var4_25;
                }
                resources = new HashSet<IFile>();
                if (JaxWsSdkUtility.exists((IResource)this.getBuildJaxWsResource().getFile())) {
                    resources.add(this.getBuildJaxWsResource().getFile());
                }
                if (JaxWsSdkUtility.exists((IResource)this.getWsdlResource().getFile())) {
                    resources.add(this.getWsdlResource().getFile());
                }
                var9_9 = this.m_bindingFileResources;
                var8_13 = this.m_bindingFileResources.length;
                var7_17 = 0;
                while (var7_17 < var8_13) {
                    resource = var9_9[var7_17];
                    if (JaxWsSdkUtility.exists((IResource)resource.getFile())) {
                        resources.add(resource.getFile());
                    }
                    ++var7_17;
                }
                ScoutSeverityManager.getInstance().fireSeverityChanged(resources);
            }
        }
    }

    private Definition loadWsdlDefinition() {
        if (this.m_buildJaxWsBean == null) {
            return null;
        }
        IFile file = JaxWsSdkUtility.getFile(this.m_bundle, this.m_buildJaxWsBean.getWsdl(), false);
        if (!this.getWsdlResource().isSameFile(file)) {
            this.getWsdlResource().setFile(file);
        }
        return this.getWsdlResource().loadWsdlDefinition();
    }

    private XmlResource[] loadBindingFiles() {
        XmlResource[] xmlResourceArray = this.m_bindingFileResources;
        int n = this.m_bindingFileResources.length;
        int n2 = 0;
        while (n2 < n) {
            XmlResource resource = xmlResourceArray[n2];
            resource.removeResourceListener(this.m_bindingFileResourceListener);
            ++n2;
        }
        LinkedList<XmlResource> bindingFileResources = new LinkedList<XmlResource>();
        if (this.m_buildJaxWsBean != null) {
            IFile[] bindingFiles;
            IFile[] iFileArray = bindingFiles = JaxWsSdkUtility.getBindingFiles(this.m_bundle, this.m_buildJaxWsBean.getPropertiers());
            int n3 = bindingFiles.length;
            int n4 = 0;
            while (n4 < n3) {
                IFile bindingFile = iFileArray[n4];
                XmlResource xmlResource = new XmlResource(this.m_bundle);
                xmlResource.setFile(bindingFile);
                xmlResource.addResourceListener(this.m_bindingFileResourceListener);
                bindingFileResources.add(xmlResource);
                ++n4;
            }
        }
        return bindingFileResources.toArray(new XmlResource[bindingFileResources.size()]);
    }

    public WebServiceConsumerTablePage getParent() {
        return (WebServiceConsumerTablePage)super.getParent();
    }

    @Override
    public String getMarkerGroupUUID() {
        return this.m_markerGroupUUID;
    }

    public BuildJaxWsBean getBuildJaxWsBean() {
        return this.m_buildJaxWsBean;
    }

    public Definition getWsdlDefinition() {
        if (this.m_wsdlDefinition == null) {
            this.m_wsdlDefinition = this.loadWsdlDefinition();
        }
        return this.m_wsdlDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPageLoadedListener(IPageLoadedListener listener) {
        Object object = this.m_pageLoadedListenerLock;
        synchronized (object) {
            this.m_pageLoadedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePageLoadedListener(IPageLoadedListener listener) {
        Object object = this.m_pageLoadedListenerLock;
        synchronized (object) {
            this.m_pageLoadedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPageLoadedListeners() {
        IPageLoadedListener[] listeners;
        Object object = this.m_pageLoadedListenerLock;
        synchronized (object) {
            listeners = this.m_pageLoadedListeners.toArray(new IPageLoadedListener[this.m_pageLoadedListeners.size()]);
        }
        IPageLoadedListener[] iPageLoadedListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPageLoadedListener listener = iPageLoadedListenerArray[n2];
            try {
                listener.pageLoaded();
            }
            catch (Exception e) {
                JaxWsSdk.logError("error while notifying pageLoaded listener", e);
            }
            ++n2;
        }
    }

    public XmlResource getBuildJaxWsResource() {
        return ResourceFactory.getBuildJaxWsResource(this.m_bundle);
    }

    public WsdlResource getWsdlResource() {
        return this.m_wsdlResource;
    }

    public XmlResource[] getBindingFileResources() {
        return this.m_bindingFileResources;
    }

    public boolean isPageUnloaded() {
        return this.m_pageUnloaded;
    }

    private class P_BindingFileResourceListener
    implements IResourceListener {
        private P_BindingFileResourceListener() {
        }

        @Override
        public void changed(String element, int event) {
            WebServiceConsumerNodePage.this.reloadPage(4);
        }
    }

    private class P_BuildJaxWsListener
    implements IResourceListener {
        private P_BuildJaxWsListener() {
        }

        @Override
        public void changed(String element, int event) {
            if (event == 8 || event == 16) {
                WebServiceConsumerNodePage.this.reloadPage(3);
            } else {
                JaxWsSdk.getDefault().getMarkerQueueManager().queueRequest(WebServiceConsumerNodePage.this);
            }
        }
    }

    private class P_ManifestResourceListener
    implements IResourceListener {
        private P_ManifestResourceListener() {
        }

        @Override
        public void changed(String element, int event) {
            WebServiceConsumerNodePage.this.reloadPage(8);
        }
    }

    private class P_StubJarResourceListener
    implements IResourceListener {
        private P_StubJarResourceListener() {
        }

        @Override
        public void changed(String element, int event) {
            WebServiceConsumerNodePage.this.reloadPage(8);
        }
    }

    private class P_TypeChangeListener
    extends AbstractTypeChangedListener {
        private P_TypeChangeListener() {
        }

        @Override
        protected boolean shouldAnalayseForChange(IResourceChangeEvent event) {
            return !WebServiceConsumerNodePage.this.isPageUnloaded();
        }

        @Override
        protected void typeChanged() {
            WebServiceConsumerNodePage.this.reloadPage(16);
        }
    }

    private class P_WsdlResourceListener
    implements IResourceListener {
        private P_WsdlResourceListener() {
        }

        @Override
        public void changed(String element, int event) {
            WebServiceConsumerNodePage.this.reloadPage(2);
        }
    }
}

