/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.pages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.ScoutSeverityManager;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.marker.IMarkerRebuildListener;
import org.eclipse.scout.sdk.ws.jaxws.marker.MarkerRebuildUtility;
import org.eclipse.scout.sdk.ws.jaxws.marker.MarkerUtility;
import org.eclipse.scout.sdk.ws.jaxws.resource.IResourceListener;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.WsProviderCodeFirstDeleteAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.IJaxWsPageConstants;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderHandlerNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderTablePage;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.AbstractTypeChangedListener;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPageLoadedListener;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPageReloadNotification;

public class WebServiceProviderCodeFirstNodePage
extends AbstractPage
implements IMarkerRebuildListener,
IPageReloadNotification {
    public static final int DATA_JDT_TYPE = 1;
    public static final int DATA_SUN_JAXWS_ENTRY = 2;
    private boolean m_pageUnloaded = false;
    private String m_markerGroupUUID;
    private IScoutBundle m_bundle;
    private String m_alias;
    private Object m_pageLoadedListenerLock;
    private IType m_portType;
    private SunJaxWsBean m_sunJaxWsBean;
    private IResourceListener m_sunJaxWsResourceListener;
    private P_PortTypeChangeListener m_portTypeChangedListener;
    private Set<IPageLoadedListener> m_pageLoadedListeners;

    public WebServiceProviderCodeFirstNodePage(IPage parent, SunJaxWsBean sunJaxWsBean) {
        this.setParent(parent);
        this.setName(StringUtility.nvl((Object)sunJaxWsBean.getAlias(), (String)"?"));
        this.setImageDescriptor(JaxWsSdk.getImageDescriptor("webservice_code_first.png"));
        this.m_sunJaxWsBean = sunJaxWsBean;
        this.m_alias = sunJaxWsBean.getAlias();
        this.m_bundle = this.getScoutResource();
        this.m_markerGroupUUID = UUID.randomUUID().toString();
        this.m_sunJaxWsResourceListener = new P_SunJaxWsResourceListener();
        this.m_pageLoadedListeners = new HashSet<IPageLoadedListener>();
        this.m_pageLoadedListenerLock = new Object();
        this.getSunJaxWsResource().addResourceListener(sunJaxWsBean.getAlias(), this.m_sunJaxWsResourceListener);
        this.m_portTypeChangedListener = new P_PortTypeChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.m_portTypeChangedListener);
        JaxWsSdk.getDefault().registerPage(WebServiceProviderNodePage.class, this);
        this.reloadPage(1);
    }

    public String getPageId() {
        return IJaxWsPageConstants.PROVIDER_CODE_FIRST_NODE_PAGE;
    }

    public boolean isFolder() {
        return false;
    }

    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof WsProviderCodeFirstDeleteAction) {
            ((WsProviderCodeFirstDeleteAction)menu).init(this.m_bundle, this.getSunJaxWsBean());
        }
    }

    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        ArrayList<Class<WsProviderCodeFirstDeleteAction>> actions = new ArrayList<Class<WsProviderCodeFirstDeleteAction>>();
        actions.add(WsProviderCodeFirstDeleteAction.class);
        return actions.toArray(new Class[actions.size()]);
    }

    @Override
    public void reloadPage(int dataMask) {
        if (this.isPageUnloaded()) {
            return;
        }
        if ((dataMask & 2) > 0) {
            SunJaxWsBean sunJaxWsBean = this.getSunJaxWsBean();
            if (sunJaxWsBean == null) {
                this.m_sunJaxWsBean = SunJaxWsBean.load(this.m_bundle, this.m_alias);
            } else if (!sunJaxWsBean.reload(this.m_bundle)) {
                this.m_sunJaxWsBean = null;
            }
        }
        if ((dataMask & 1) > 0) {
            this.m_portType = null;
            if (this.m_sunJaxWsBean != null && this.m_sunJaxWsBean.getImplementation() != null && TypeUtility.existsType((String)this.m_sunJaxWsBean.getImplementation())) {
                this.m_portType = TypeUtility.getType((String)this.m_sunJaxWsBean.getImplementation());
            }
            this.m_portTypeChangedListener.setType(this.m_portType);
        }
        this.notifyPageLoadedListeners();
        JaxWsSdk.getDefault().getMarkerQueueManager().queueRequest(this);
    }

    public void refresh(boolean clearCache) {
        if (clearCache) {
            super.refresh(clearCache);
        } else {
            JaxWsSdk.getDefault().getMarkerQueueManager().queueRequest(this);
        }
    }

    public void unloadPage() {
        this.m_pageUnloaded = true;
        MarkerUtility.clearMarkers(this.m_bundle, this.m_markerGroupUUID);
        this.getSunJaxWsResource().removeResourceListener(this.m_sunJaxWsResourceListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.m_portTypeChangedListener);
        JaxWsSdk.getDefault().unregisterPage(WebServiceProviderNodePage.class, this);
        super.unloadPage();
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    public int getQuality() {
        int quality = MarkerUtility.getQuality((IPage)this, this.m_bundle, this.m_markerGroupUUID);
        if (quality == 2) {
            return quality;
        }
        IType portType = this.getPortType();
        if (portType != null) {
            quality = Math.max(quality, ScoutSeverityManager.getInstance().getSeverityOf((Object)portType));
        }
        return quality;
    }

    public boolean handleDoubleClickedDelegate() {
        if (this.getPortType() != null) {
            try {
                JavaUI.openInEditor((IJavaElement)this.getPortType());
            }
            catch (Exception e) {
                JaxWsSdk.logWarning("could not open type in editor", e);
            }
            return true;
        }
        return false;
    }

    protected void loadChildrenImpl() {
        new WebServiceProviderHandlerNodePage((IPage)this, this.getSunJaxWsBean());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuildMarkers() {
        String string = this.m_markerGroupUUID;
        synchronized (string) {
            block16: {
                MarkerUtility.clearMarkers(this.m_bundle, this.m_markerGroupUUID);
                if (!this.isPageUnloaded()) break block16;
                HashSet<Object> resources = new HashSet<Object>();
                if (JaxWsSdkUtility.exists((IResource)this.getSunJaxWsResource().getFile())) {
                    resources.add(this.getSunJaxWsResource().getFile());
                }
                if (TypeUtility.exists((IJavaElement)this.getPortType())) {
                    resources.add(this.getPortType().getResource());
                }
                ScoutSeverityManager.getInstance().fireSeverityChanged(resources);
                return;
            }
            try {
                try {
                    MarkerRebuildUtility.rebuildCodeFirstPortTypeMarkers(this.m_bundle, this.getPortType(), this.getSunJaxWsBean(), this.getMarkerGroupUUID());
                }
                catch (Exception e) {
                    JaxWsSdk.logWarning("failed to update markers", e);
                    HashSet<Object> resources = new HashSet<Object>();
                    if (JaxWsSdkUtility.exists((IResource)this.getSunJaxWsResource().getFile())) {
                        resources.add(this.getSunJaxWsResource().getFile());
                    }
                    if (TypeUtility.exists((IJavaElement)this.getPortType())) {
                        resources.add(this.getPortType().getResource());
                    }
                    ScoutSeverityManager.getInstance().fireSeverityChanged(resources);
                }
            }
            catch (Throwable throwable) {
                HashSet<Object> resources = new HashSet<Object>();
                if (JaxWsSdkUtility.exists((IResource)this.getSunJaxWsResource().getFile())) {
                    resources.add(this.getSunJaxWsResource().getFile());
                }
                if (TypeUtility.exists((IJavaElement)this.getPortType())) {
                    resources.add(this.getPortType().getResource());
                }
                ScoutSeverityManager.getInstance().fireSeverityChanged(resources);
                throw throwable;
            }
            HashSet<Object> resources = new HashSet<Object>();
            if (JaxWsSdkUtility.exists((IResource)this.getSunJaxWsResource().getFile())) {
                resources.add(this.getSunJaxWsResource().getFile());
            }
            if (TypeUtility.exists((IJavaElement)this.getPortType())) {
                resources.add(this.getPortType().getResource());
            }
            ScoutSeverityManager.getInstance().fireSeverityChanged(resources);
        }
    }

    public WebServiceProviderTablePage getParent() {
        return (WebServiceProviderTablePage)super.getParent();
    }

    @Override
    public String getMarkerGroupUUID() {
        return this.m_markerGroupUUID;
    }

    public IType getPortType() {
        return this.m_portType;
    }

    public SunJaxWsBean getSunJaxWsBean() {
        return this.m_sunJaxWsBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPageLoadedListener(IPageLoadedListener listener) {
        Object object = this.m_pageLoadedListenerLock;
        synchronized (object) {
            this.m_pageLoadedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePageLoadedListener(IPageLoadedListener listener) {
        Object object = this.m_pageLoadedListenerLock;
        synchronized (object) {
            this.m_pageLoadedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPageLoadedListeners() {
        IPageLoadedListener[] listeners;
        Object object = this.m_pageLoadedListenerLock;
        synchronized (object) {
            listeners = this.m_pageLoadedListeners.toArray(new IPageLoadedListener[this.m_pageLoadedListeners.size()]);
        }
        IPageLoadedListener[] iPageLoadedListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPageLoadedListener listener = iPageLoadedListenerArray[n2];
            try {
                listener.pageLoaded();
            }
            catch (Exception e) {
                JaxWsSdk.logError("error while notifying pageLoaded listener", e);
            }
            ++n2;
        }
    }

    public XmlResource getSunJaxWsResource() {
        return ResourceFactory.getSunJaxWsResource(this.m_bundle);
    }

    public boolean isPageUnloaded() {
        return this.m_pageUnloaded;
    }

    private class P_PortTypeChangeListener
    extends AbstractTypeChangedListener {
        private P_PortTypeChangeListener() {
        }

        @Override
        protected boolean shouldAnalayseForChange(IResourceChangeEvent event) {
            return !WebServiceProviderCodeFirstNodePage.this.isPageUnloaded();
        }

        @Override
        protected void typeChanged() {
            WebServiceProviderCodeFirstNodePage.this.reloadPage(1);
        }
    }

    private class P_SunJaxWsResourceListener
    implements IResourceListener {
        private P_SunJaxWsResourceListener() {
        }

        @Override
        public void changed(String element, int event) {
            if (event == 16 || event == 512 || event == 32) {
                WebServiceProviderCodeFirstNodePage.this.reloadPage(2);
            } else {
                JaxWsSdk.getDefault().getMarkerQueueManager().queueRequest(WebServiceProviderCodeFirstNodePage.this);
            }
        }
    }
}

