/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.pages;

import java.util.UUID;
import org.eclipse.core.resources.IResource;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.ScoutSeverityManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.marker.IMarkerRebuildListener;
import org.eclipse.scout.sdk.ws.jaxws.marker.MarkerUtility;
import org.eclipse.scout.sdk.ws.jaxws.resource.IResourceListener;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.ProviderNewWizardAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.IJaxWsPageConstants;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderCodeFirstNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class WebServiceProviderTablePage
extends AbstractPage
implements IMarkerRebuildListener {
    public static final int DATA_SUN_JAXWS_FILE = 1;
    private String m_markerGroupUUID;
    private IScoutBundle m_bundle;
    private ScoutXmlDocument m_sunJaxWsXml;
    private IResourceListener m_resourceListener;
    private boolean m_pageUnloaded = false;

    public WebServiceProviderTablePage(IPage parent) {
        this.setParent(parent);
        this.setName(Texts.get("Services"));
        this.setImageDescriptor(JaxWsSdk.getImageDescriptor("webservice_folder.png"));
        this.m_bundle = this.getScoutResource();
        this.m_markerGroupUUID = UUID.randomUUID().toString();
        this.m_resourceListener = new P_SunJaxWsResourceListener();
        int event = 15;
        this.getSunJaxWsResource().addResourceListener(event, this.m_resourceListener);
        this.getSunJaxWsResource().addResourceListener("", this.m_resourceListener);
        this.reloadData(1);
    }

    public XmlResource getSunJaxWsResource() {
        return ResourceFactory.getSunJaxWsResource(this.m_bundle);
    }

    public String getPageId() {
        return IJaxWsPageConstants.WEBSERVICE_PROVIDER_TABLE_PAGE;
    }

    public boolean isFolder() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof ProviderNewWizardAction) {
            ((ProviderNewWizardAction)menu).init(this.getScoutResource());
        }
    }

    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{ProviderNewWizardAction.class};
    }

    public void unloadPage() {
        this.m_pageUnloaded = true;
        MarkerUtility.clearMarkers(this.m_bundle, this.m_markerGroupUUID);
        this.getSunJaxWsResource().removeResourceListener(this.m_resourceListener);
        super.unloadPage();
    }

    public int getQuality() {
        return MarkerUtility.getQuality((IPage)this, this.m_bundle, this.m_markerGroupUUID);
    }

    public void reloadData(int data) {
        if ((data & 1) > 0) {
            this.m_sunJaxWsXml = this.getSunJaxWsResource().loadXml();
        }
        JaxWsSdk.getDefault().getMarkerQueueManager().queueRequest(this);
    }

    public void refresh(boolean clearCache) {
        if (clearCache) {
            super.refresh(clearCache);
        } else {
            JaxWsSdk.getDefault().getMarkerQueueManager().queueRequest(this);
        }
    }

    protected void loadChildrenImpl() {
        try {
            if (this.m_sunJaxWsXml == null || this.m_sunJaxWsXml.getRoot() == null) {
                return;
            }
            for (ScoutXmlDocument.ScoutXmlElement sunJaxWsXml : this.m_sunJaxWsXml.getRoot().getChildren(StringUtility.join((String)":", (Object[])new Object[]{this.m_sunJaxWsXml.getRoot().getNamePrefix(), "endpoint"}))) {
                SunJaxWsBean sunJaxWsBean = new SunJaxWsBean(sunJaxWsXml);
                BuildJaxWsBean buildJaxWsBean = BuildJaxWsBean.load(this.m_bundle, sunJaxWsBean.getAlias(), WebserviceEnum.Provider);
                if (buildJaxWsBean != null) {
                    new WebServiceProviderNodePage((IPage)this, sunJaxWsBean, buildJaxWsBean);
                    continue;
                }
                new WebServiceProviderCodeFirstNodePage((IPage)this, sunJaxWsBean);
            }
        }
        finally {
            JaxWsSdk.getDefault().getMarkerQueueManager().queueRequest(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rebuildMarkers() {
        String string = this.m_markerGroupUUID;
        synchronized (string) {
            block5: {
                try {
                    MarkerUtility.clearMarkers(this.m_bundle, this.m_markerGroupUUID);
                    if (!this.isPageUnloaded()) break block5;
                }
                catch (Throwable throwable) {
                    ScoutSeverityManager.getInstance().fireSeverityChanged(JaxWsSdkUtility.createResourceSet(new IResource[]{this.getSunJaxWsResource().getFile()}));
                    throw throwable;
                }
                ScoutSeverityManager.getInstance().fireSeverityChanged(JaxWsSdkUtility.createResourceSet(new IResource[]{this.getSunJaxWsResource().getFile()}));
                return;
            }
            ScoutSeverityManager.getInstance().fireSeverityChanged(JaxWsSdkUtility.createResourceSet(new IResource[]{this.getSunJaxWsResource().getFile()}));
            return;
        }
    }

    public String getMarkerGroupUUID() {
        return this.m_markerGroupUUID;
    }

    public boolean isPageUnloaded() {
        return this.m_pageUnloaded;
    }

    private class P_SunJaxWsResourceListener
    implements IResourceListener {
        private P_SunJaxWsResourceListener() {
        }

        @Override
        public void changed(String element, int event) {
            WebServiceProviderTablePage.this.reloadData(1);
            WebServiceProviderTablePage.this.markStructureDirty();
        }
    }
}

