/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsConstants;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.FileDeleteOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.FilePresenter;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;

public class BindingFilePresenter
extends FilePresenter {
    private BuildJaxWsBean m_buildJaxWsBean;

    public BindingFilePresenter(Composite parent, PropertyViewFormToolkit toolkit) {
        super(parent, toolkit);
        this.setResetLinkVisible(true);
        this.setFileDirectory("/WEB-INF/build");
        this.setFileExtension("xml");
        this.setLabel(Texts.get("BindingFile"));
        this.setMarkerType(JaxWsConstants.MarkerType.BindingFile);
        this.setResetTooltip(Texts.get("TooltipRemoveBindingFile"));
    }

    @Override
    protected IFile execBrowseAction() {
        IFile oldFile = (IFile)this.getValue();
        IFile newFile = super.execBrowseAction();
        if (newFile == null || CompareUtility.equals((Object)oldFile, (Object)newFile)) {
            return null;
        }
        Map<String, List<String>> propertiers = this.m_buildJaxWsBean.getPropertiers();
        String path = null;
        if (oldFile != null) {
            path = oldFile.getProjectRelativePath().toPortableString();
        }
        if (!this.removeBindingFileEntry(propertiers, path)) {
            return null;
        }
        JaxWsSdkUtility.addBuildProperty(propertiers, "b", newFile.getProjectRelativePath().toPortableString());
        this.m_buildJaxWsBean.setProperties(propertiers);
        ResourceFactory.getBuildJaxWsResource(this.m_bundle).storeXmlAsync(this.m_buildJaxWsBean.getXml().getDocument(), 8, this.m_buildJaxWsBean.getAlias());
        return newFile;
    }

    @Override
    protected void execResetAction() throws CoreException {
        Map<String, List<String>> propertiers;
        IFile file = (IFile)this.getValue();
        String bindingFileRaw = null;
        if (file != null) {
            bindingFileRaw = file.getProjectRelativePath().toPortableString();
        }
        if (!this.removeBindingFileEntry(propertiers = this.m_buildJaxWsBean.getPropertiers(), bindingFileRaw)) {
            return;
        }
        this.m_buildJaxWsBean.setProperties(propertiers);
        ResourceFactory.getBuildJaxWsResource(this.m_bundle).storeXmlAsync(this.m_buildJaxWsBean.getXml().getDocument(), 8, this.m_buildJaxWsBean.getAlias());
    }

    private boolean removeBindingFileEntry(Map<String, List<String>> properties, String bindingFileRaw) {
        List<String> bindingFiles;
        IFile bindingFile = JaxWsSdkUtility.getFile(this.m_bundle, bindingFileRaw, false);
        if (bindingFile != null && bindingFile.exists()) {
            MessageBox messageBox = new MessageBox(ScoutSdkUi.getShell(), 452);
            messageBox.setMessage(Texts.get("QuestionShouldFileXAlsoBeDeletedFromDisk", bindingFileRaw));
            int status = messageBox.open();
            if (status == 64) {
                FileDeleteOperation op = new FileDeleteOperation();
                op.setFile(bindingFile);
                new OperationJob(new IOperation[]{op}).schedule();
            } else if (status == 256) {
                return false;
            }
        }
        if ((bindingFiles = properties.get("b")) != null && bindingFiles.size() > 0) {
            while (bindingFiles.remove(bindingFileRaw)) {
            }
            if (bindingFiles.size() == 0) {
                properties.remove("b");
            }
        }
        return true;
    }

    public BuildJaxWsBean getBuildJaxWsBean() {
        return this.m_buildJaxWsBean;
    }

    public void setBuildJaxWsBean(BuildJaxWsBean buildJaxWsBean) {
        this.m_buildJaxWsBean = buildJaxWsBean;
    }
}

