/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsConsumerDeleteOperation;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.ElementBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.ResourceSelectionWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaUtility;

public class WsConsumerDeleteWizard
extends AbstractWorkspaceWizard {
    private ResourceSelectionWizardPage m_wizardPage;
    private IScoutBundle m_bundle;
    private IType m_type;
    private BuildJaxWsBean m_buildJaxWsBean;
    private WsConsumerDeleteOperation m_operation;

    public WsConsumerDeleteWizard() {
        this.setWindowTitle(Texts.get("DeleteWebserviceConsumer"));
    }

    public void addPages() {
        this.m_wizardPage = new ResourceSelectionWizardPage(Texts.get("DeleteWebserviceConsumer"), Texts.get("QuestionDeletion"));
        this.m_wizardPage.setElements(this.getElementsToBeDeleted());
        this.addPage((IWizardPage)this.m_wizardPage);
    }

    private List<ElementBean> getElementsToBeDeleted() {
        int n;
        int n2;
        SchemaUtility.Artefact[] artefactArray;
        IFile stubJarFile;
        LinkedList<ElementBean> elements = new LinkedList<ElementBean>();
        elements.add(new ElementBean(1, "Registration entry in build-jaxws.xml", JaxWsSdk.getImageDescriptor("build-jaxws.png"), true));
        elements.add(new ElementBean(2, "Service registration in plugin.xml of webservice client '" + this.m_type.getFullyQualifiedName() + "'", ScoutSdkUi.getImageDescriptor((String)"serviceLocator.png"), (IJavaElement)this.m_type, true));
        elements.add(new ElementBean(8, "Webservice client type '" + this.m_type.getFullyQualifiedName() + "'", ScoutSdkUi.getImageDescriptor((String)"class_obj.gif"), (IJavaElement)this.m_type, true));
        String wsdlFileName = null;
        if (this.m_buildJaxWsBean != null) {
            wsdlFileName = this.m_buildJaxWsBean.getWsdl();
        }
        if ((stubJarFile = JaxWsSdkUtility.getStubJarFile(this.m_bundle, this.m_buildJaxWsBean, wsdlFileName)) != null && stubJarFile.exists()) {
            elements.add(new ElementBean(4, "Stub JAR file '" + stubJarFile.getFullPath().toPortableString() + "'", JaxWsSdk.getImageDescriptor("jar_obj.gif"), (IResource)stubJarFile, false));
        }
        IFile wsdlFile = null;
        if (this.m_buildJaxWsBean != null && StringUtility.hasText((String)this.m_buildJaxWsBean.getWsdl())) {
            wsdlFile = JaxWsSdkUtility.getFile(this.m_bundle, this.m_buildJaxWsBean.getWsdl(), false);
        }
        if (wsdlFile != null && wsdlFile.exists()) {
            elements.add(new ElementBean(32, "WSDL file '" + wsdlFile.getProjectRelativePath().toPortableString() + "'", JaxWsSdk.getImageDescriptor("wsdl_file_obj.gif"), (IResource)wsdlFile, false));
        }
        if (wsdlFile != null) {
            SchemaUtility.Artefact[] artefacts;
            artefactArray = artefacts = SchemaUtility.getArtefacts(wsdlFile, false);
            n2 = artefacts.length;
            n = 0;
            while (n < n2) {
                IFile includedSchemaFile;
                SchemaUtility.SchemaArtefact schemaArtefact;
                IFile importedSchemaFile;
                IFile referencedWsdlFile;
                SchemaUtility.WsdlArtefact wsdlArtefact;
                SchemaUtility.Artefact artefact = artefactArray[n];
                if (artefact instanceof SchemaUtility.WsdlArtefact && (wsdlArtefact = (SchemaUtility.WsdlArtefact)artefact).getTypeEnum() == SchemaUtility.WsdlArtefact.TypeEnum.ReferencedWsdl && (referencedWsdlFile = JaxWsSdkUtility.toFile(this.m_bundle, wsdlArtefact.getFile())) != null && referencedWsdlFile.exists()) {
                    elements.add(new ElementBean(64, "Referenced WSDL file '" + referencedWsdlFile.getProjectRelativePath().toPortableString() + "'", JaxWsSdk.getImageDescriptor("wsdl_file_obj.gif"), (IResource)referencedWsdlFile, false));
                }
                if (artefact instanceof SchemaUtility.SchemaImportArtefact && (importedSchemaFile = JaxWsSdkUtility.toFile(this.m_bundle, (schemaArtefact = (SchemaUtility.SchemaImportArtefact)artefact).getFile())) != null && importedSchemaFile.exists()) {
                    elements.add(new ElementBean(128, "Imported XSD schema '" + importedSchemaFile.getProjectRelativePath().toPortableString() + "'", JaxWsSdk.getImageDescriptor("xsdFile.gif"), (IResource)importedSchemaFile, false));
                }
                if (artefact instanceof SchemaUtility.SchemaIncludeArtefact && (includedSchemaFile = JaxWsSdkUtility.toFile(this.m_bundle, (schemaArtefact = (SchemaUtility.SchemaIncludeArtefact)artefact).getFile())) != null && includedSchemaFile.exists()) {
                    elements.add(new ElementBean(128, "Included XSD schema '" + includedSchemaFile.getProjectRelativePath().toPortableString() + "'", JaxWsSdk.getImageDescriptor("xsdFile.gif"), (IResource)includedSchemaFile, false));
                }
                ++n;
            }
        }
        if (this.m_buildJaxWsBean != null) {
            IFile[] bindingFiles = JaxWsSdkUtility.getBindingFiles(this.m_bundle, this.m_buildJaxWsBean.getPropertiers());
            artefactArray = bindingFiles;
            n2 = bindingFiles.length;
            n = 0;
            while (n < n2) {
                SchemaUtility.Artefact bindingFile = artefactArray[n];
                if (bindingFile != null && bindingFile.exists()) {
                    elements.add(new ElementBean(16, "Binding file '" + bindingFile.getProjectRelativePath().toPortableString() + "'", JaxWsSdk.getImageDescriptor("XSDTypeDefinition.gif"), (IResource)bindingFile, false));
                }
                ++n;
            }
        }
        return elements;
    }

    protected boolean beforeFinish() throws CoreException {
        this.m_operation = new WsConsumerDeleteOperation();
        this.m_operation.setBundle(this.m_bundle);
        this.m_operation.setBuildJaxWsBean(this.m_buildJaxWsBean);
        LinkedList<ElementBean> elements = new LinkedList<ElementBean>();
        for (ElementBean element : this.m_wizardPage.getElements()) {
            if (!element.isChecked() && !element.isMandatory()) continue;
            elements.add(element);
        }
        this.m_operation.setElements(elements);
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        OperationJob job = new OperationJob(new IOperation[]{this.m_operation});
        job.schedule();
        return true;
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public IType getType() {
        return this.m_type;
    }

    public void setType(IType type) {
        this.m_type = type;
    }

    public BuildJaxWsBean getBuildJaxWsBean() {
        return this.m_buildJaxWsBean;
    }

    public void setBuildJaxWsBean(BuildJaxWsBean buildJaxWsBean) {
        this.m_buildJaxWsBean = buildJaxWsBean;
    }
}

