/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.util;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutBundleFilter;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;

public final class ServletRegistrationUtility {
    public static final String XML_SERVLET_BUNDLE = "servlet-bundle";
    public static final String XML_NAME = "name";

    private ServletRegistrationUtility() {
    }

    public static String getBuildJaxServletRegistrationBundleName(IScoutBundle bundle) {
        if (bundle == null) {
            return null;
        }
        if (bundle.getType() != 5) {
            return null;
        }
        ScoutXmlDocument document = ResourceFactory.getBuildJaxWsResource(bundle).loadXml();
        if (document == null || document.getRoot() == null) {
            return null;
        }
        ScoutXmlDocument.ScoutXmlElement xml = document.getRoot().getChild(XML_SERVLET_BUNDLE);
        if (xml == null) {
            return null;
        }
        if (!xml.hasAttribute(XML_NAME)) {
            return null;
        }
        String bundleName = xml.getAttribute(XML_NAME);
        if (!StringUtility.hasText((String)bundleName)) {
            return null;
        }
        return bundleName;
    }

    public static Registration getServletRegistration(IScoutBundle bundle) {
        Registration[] registrations;
        String bundleName = ServletRegistrationUtility.getBuildJaxServletRegistrationBundleName(bundle);
        Registration[] registrationArray = registrations = ServletRegistrationUtility.getJaxWsServletRegistrationsOnClasspath(bundle);
        int n = registrations.length;
        int n2 = 0;
        while (n2 < n) {
            Registration registration = registrationArray[n2];
            if (registration.getBundle().getBundleName().equals(bundleName)) {
                return registration;
            }
            ++n2;
        }
        return null;
    }

    public static IScoutBundle[] getJaxWsBundlesOnClasspath(IScoutBundle bundle) {
        if (bundle == null) {
            return new IScoutBundle[0];
        }
        return bundle.getRequiredBundles(new IScoutBundleFilter(){

            public boolean accept(IScoutBundle candidate) {
                if (candidate.getType() != 5) {
                    return false;
                }
                return TypeUtility.exists((IJavaElement)TypeUtility.getType((String)"org.eclipse.scout.jaxws.Activator")) && TypeUtility.isOnClasspath((IMember)TypeUtility.getType((String)"org.eclipse.scout.jaxws.Activator"), (IJavaProject)candidate.getJavaProject());
            }
        }, true);
    }

    public static Registration[] getJaxWsServletRegistrationsOnClasspath(IScoutBundle bundle) {
        HashSet<Registration> bundles = new HashSet<Registration>();
        IScoutBundle[] iScoutBundleArray = ServletRegistrationUtility.getJaxWsBundlesOnClasspath(bundle);
        int n = iScoutBundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginAttribute a;
            IScoutBundle candidate = iScoutBundleArray[n2];
            String extensionPoint = "org.eclipse.equinox.http.registry.servlets";
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("class", TypeUtility.getType((String)"org.eclipse.scout.jaxws.JaxWsServlet").getFullyQualifiedName());
            PluginModelHelper h = new PluginModelHelper(candidate.getProject());
            IPluginElement ex = h.PluginXml.getSimpleExtension(extensionPoint, "servlet", attributes);
            if (ex != null && (a = ex.getAttribute("alias")) != null) {
                bundles.add(new Registration(candidate, a.getValue()));
            }
            ++n2;
        }
        return bundles.toArray(new Registration[bundles.size()]);
    }

    public static String getAlias(IScoutBundle bundle) {
        Registration registration = ServletRegistrationUtility.getServletRegistration(bundle);
        if (registration == null) {
            return null;
        }
        return registration.getAlias();
    }

    public static class Registration {
        private IScoutBundle m_bundle;
        private String m_alias;

        private Registration(IScoutBundle bundle, String alias) {
            this.m_bundle = bundle;
            this.m_alias = alias;
        }

        public IScoutBundle getBundle() {
            return this.m_bundle;
        }

        public void setBundle(IScoutBundle bundle) {
            this.m_bundle = bundle;
        }

        public String getAlias() {
            return this.m_alias;
        }

        public void setAlias(String alias) {
            this.m_alias = alias;
        }
    }
}

