/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.service;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.service.INullService;
import org.eclipse.scout.service.internal.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class SERVICES {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SERVICES.class);

    private SERVICES() {
    }

    public static <T> T getService(Class<T> serviceInterfaceClass) {
        return SERVICES.getService(serviceInterfaceClass, null);
    }

    public static <T> T getService(Class<T> serviceInterfaceClass, String filter) {
        T service;
        Activator a = Activator.getDefault();
        if (a == null || serviceInterfaceClass == null) {
            return null;
        }
        a.getServicesExtensionManager().start();
        BundleContext context = a.getBundle().getBundleContext();
        if (context == null) {
            return null;
        }
        ServiceReference serviceReference = null;
        if (filter == null && (serviceReference = context.getServiceReference(serviceInterfaceClass.getName())) != null && (service = SERVICES.resolveService(serviceInterfaceClass, context, serviceReference)) != null) {
            return service;
        }
        ServiceReference[] refs = null;
        try {
            refs = context.getAllServiceReferences(serviceInterfaceClass.getName(), filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (refs != null) {
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                T service2 = SERVICES.resolveService(serviceInterfaceClass, context, ref);
                if (service2 != null) {
                    return service2;
                }
                ++n2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T resolveService(Class<T> serviceInterfaceClass, BundleContext context, ServiceReference ref) {
        if (ref == null) {
            return null;
        }
        ServiceReference serviceReference = ref;
        synchronized (serviceReference) {
            Object s = SERVICES.safeGetService(context, ref);
            if (s == null) return null;
            if (!serviceInterfaceClass.isAssignableFrom(s.getClass())) return null;
            Object object = s;
            return (T)object;
            finally {
                context.ungetService(ref);
            }
        }
    }

    public static <T> T[] getServices(Class<T> serviceInterfaceClass) {
        return SERVICES.getServices(serviceInterfaceClass, null);
    }

    public static <T> T[] getServices(Class<T> serviceInterfaceClass, String filter) {
        Activator a = Activator.getDefault();
        if (a == null || serviceInterfaceClass == null) {
            return (Object[])Array.newInstance(serviceInterfaceClass, 0);
        }
        a.getServicesExtensionManager().start();
        BundleContext context = a.getBundle().getBundleContext();
        if (context == null) {
            return (Object[])Array.newInstance(serviceInterfaceClass, 0);
        }
        ServiceReference[] refs = null;
        try {
            refs = context.getAllServiceReferences(serviceInterfaceClass.getName(), filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (refs != null) {
            ArrayList<T> list = new ArrayList<T>(refs.length);
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                T s = SERVICES.resolveService(serviceInterfaceClass, context, ref);
                if (s != null) {
                    list.add(s);
                }
                ++n2;
            }
            return list.toArray((Object[])Array.newInstance(serviceInterfaceClass, list.size()));
        }
        return (Object[])Array.newInstance(serviceInterfaceClass, 0);
    }

    private static Object safeGetService(BundleContext context, ServiceReference ref) {
        Object o = context.getService(ref);
        if (o instanceof INullService) {
            o = null;
        }
        return o;
    }
}

