/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.svg.ui.swing.svgfield;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.net.URI;
import java.net.URL;
import javax.swing.JComponent;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFieldComposite;
import org.eclipse.scout.svg.client.JSVGCanvasEx;
import org.eclipse.scout.svg.client.SilentSVGUserAgentAdapter;
import org.eclipse.scout.svg.client.svgfield.ISvgField;
import org.eclipse.scout.svg.ui.swing.svgfield.ISwingScoutSvgField;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGPoint;

public class SwingScoutSvgField
extends SwingScoutFieldComposite<ISvgField>
implements ISwingScoutSvgField {
    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        if (((ISvgField)this.getScoutObject()).isLabelVisible()) {
            JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
            container.add((Component)label);
            this.setSwingLabel(label);
        }
        P_SVGUserAgent ua = new P_SVGUserAgent();
        JSVGCanvasEx canvas = new JSVGCanvasEx((SVGUserAgent)ua, true, false);
        canvas.setDocumentState(3);
        canvas.addMouseListener((MouseListener)new P_SwingMouseListener());
        SwingUtility.installDefaultFocusHandling((Container)canvas);
        container.add((Component)canvas);
        this.setSwingField((JComponent)canvas);
        this.setSwingContainer((JComponent)container);
        this.getSwingContainer().setLayout((LayoutManager)new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    @Override
    public JSVGCanvas getSwingField() {
        return (JSVGCanvas)super.getSwingField();
    }

    protected void attachScout() {
        super.attachScout();
        this.updateSvgDocumentFromScout();
        this.setHorizontalAlignmentFromScout(((ISvgField)this.getScoutObject()).getGridData().horizontalAlignment);
        this.setVerticalAlignmentFromScout(((ISvgField)this.getScoutObject()).getGridData().verticalAlignment);
    }

    protected void detachScout() {
        super.detachScout();
        this.getSwingField().stopProcessing();
        this.getSwingField().dispose();
    }

    protected void updateSvgDocumentFromScout() {
        SVGDocument doc = ((ISvgField)this.getScoutObject()).getSvgDocument();
        JSVGCanvas canvas = this.getSwingField();
        canvas.setSVGDocument(doc);
    }

    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
        float swingAlignX = SwingUtility.createAlignmentX((int)scoutAlign);
        this.getSwingField().setAlignmentX(swingAlignX);
    }

    protected void setVerticalAlignmentFromScout(int scoutAlign) {
        float swingAlignY = SwingUtility.createAlignmentY((int)scoutAlign);
        this.getSwingField().setAlignmentY(swingAlignY);
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("svgDocument")) {
            this.updateSvgDocumentFromScout();
        }
    }

    protected void handleSwingClick(MouseEvent e) {
        try {
            JSVGCanvas canvas = this.getSwingField();
            AffineTransform vbTransform = canvas.getViewBoxTransform().createInverse();
            Point2D p = new Point2D.Double(e.getX(), e.getY());
            p = vbTransform.transform(p, null);
            final SVGOMPoint svgPoint = new SVGOMPoint((float)p.getX(), (float)p.getY());
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ISvgField)SwingScoutSvgField.this.getScoutObject()).getUIFacade().fireClickFromUI((SVGPoint)svgPoint);
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 5678L);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {}
    }

    private class P_SVGUserAgent
    extends SilentSVGUserAgentAdapter {
        private P_SVGUserAgent() {
        }

        public void openLink(String uri, boolean newc) {
            try {
                final URL url = new URI(uri).toURL();
                new ClientSyncJob("Hyperlink", SwingScoutSvgField.this.getSwingEnvironment().getScoutSession()){

                    protected void runVoid(IProgressMonitor monitor) throws Throwable {
                        ((ISvgField)SwingScoutSvgField.this.getScoutObject()).getUIFacade().fireHyperlinkFromUI(url);
                    }
                }.schedule();
            }
            catch (Throwable throwable) {}
        }
    }

    private class P_SwingMouseListener
    extends MouseAdapter {
        private P_SwingMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 1) {
                SwingScoutSvgField.this.handleSwingClick(e);
            }
        }
    }
}

