/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.diagram;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.soa.sca.core.common.ScaCoreCommonPlugin;
import org.eclipse.soa.sca.core.common.diagram.NodeToolEntry;
import org.eclipse.soa.sca.core.common.diagram.dnd.IDragDropHandler;
import org.eclipse.soa.sca.core.common.diagram.extension.edit.part.ScaElementInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaDiagramExtensionManager {
    private static final String EP_ID = "org.eclipse.soa.sca.common.diagrams";
    private static final String DND_ELT = "DragAndDrop";
    private static final String DND_IMPL_ELT = "DndImplementation";
    private static final String DND_ITF_ELT = "DndInterface";
    private static final String DND_ANY_ELT = "DndAnyExtension";
    private static final String EXT_ELT = "ExtensionElement";
    private static final String EXT_ITF_ELT = "InterfaceElement";
    private static final String EXT_IMPL_ELT = "ImplementationElement";
    private static final String EXT_BIND_ELT = "BindingElement";
    private static final String DND_CLASS_ATTR = "class";
    private static final String DND_SPEC_ID_ATTR = "specification-id";
    private static final String EXT_TYPE_ATTR = "type";
    private static final String EXT_LABEL_ATTR = "label";
    private static final String EXT_DESC_ATTR = "description";
    private static final String EXT_ICON_ATTR = "icon-path";
    private static final String EXT_LITERAL_FIELD_ATTR = "literal-field";
    private static final String EXT_LITERAL_CLASS_ATTR = "literal-class";
    public static ScaDiagramExtensionManager INSTANCE = new ScaDiagramExtensionManager();

    private ScaDiagramExtensionManager() {
    }

    public Collection<IDragDropHandler> getDndAnyExtensionHandlers(String specifciationId) {
        return this.getDndHandlers(specifciationId, DND_ANY_ELT);
    }

    public Collection<IDragDropHandler> getDndImplementationHandlers(String specifciationId) {
        return this.getDndHandlers(specifciationId, DND_IMPL_ELT);
    }

    public Collection<IDragDropHandler> getDndInterfaceHandlers(String specifciationId) {
        return this.getDndHandlers(specifciationId, DND_ITF_ELT);
    }

    public List<ToolEntry> getPaletteInterfaceEntries(String specifciationId) {
        return this.getPaletteEntries(specifciationId, EXT_ITF_ELT);
    }

    public List<ToolEntry> getPaletteImplementationEntries(String specifciationId) {
        return this.getPaletteEntries(specifciationId, EXT_IMPL_ELT);
    }

    public List<ToolEntry> getPaletteBindingEntries(String specifciationId) {
        return this.getPaletteEntries(specifciationId, EXT_BIND_ELT);
    }

    private Collection<IDragDropHandler> getDndHandlers(String specificationId, String dndElement) {
        ArrayList<IDragDropHandler> result = new ArrayList<IDragDropHandler>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EP_ID);
        if (extensionPoint != null) {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    if (DND_ELT.equals(configElement.getName()) && specificationId != null && specificationId.equals(configElement.getAttribute(DND_SPEC_ID_ATTR))) {
                        IConfigurationElement[] iConfigurationElementArray2 = configElement.getChildren(dndElement);
                        int n5 = iConfigurationElementArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IConfigurationElement child = iConfigurationElementArray2[n6];
                            try {
                                Object o = child.createExecutableExtension(DND_CLASS_ATTR);
                                result.add((IDragDropHandler)o);
                            }
                            catch (CoreException e) {
                                ScaCoreCommonPlugin.log((Exception)((Object)e), 4);
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return result;
    }

    private List<ToolEntry> getPaletteEntries(String specificationId, String scaElement) {
        ArrayList<ToolEntry> result = new ArrayList<ToolEntry>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EP_ID);
        if (extensionPoint != null) {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    if (EXT_ELT.equals(configElement.getName()) && specificationId != null && specificationId.equals(configElement.getAttribute(DND_SPEC_ID_ATTR))) {
                        String contributorName = configElement.getDeclaringExtension().getContributor().getName();
                        IConfigurationElement[] iConfigurationElementArray2 = configElement.getChildren(scaElement);
                        int n5 = iConfigurationElementArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IConfigurationElement child = iConfigurationElementArray2[n6];
                            ArrayList<IElementType> types = new ArrayList<IElementType>();
                            types.add(ElementTypeRegistry.getInstance().getType(child.getAttribute(EXT_TYPE_ATTR)));
                            NodeToolEntry entry = new NodeToolEntry(child.getAttribute(EXT_LABEL_ATTR), child.getAttribute(EXT_DESC_ATTR), types);
                            String iconPath = child.getAttribute(EXT_ICON_ATTR);
                            if (!iconPath.startsWith("/")) {
                                iconPath = "/" + contributorName + "/" + iconPath;
                            }
                            entry.setSmallIcon(ScaCoreCommonPlugin.findImageDescriptor(iconPath));
                            entry.setLargeIcon(entry.getSmallIcon());
                            result.add(entry);
                            ++n6;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return result;
    }

    public List<ScaElementInformation> getBindingExtensions(String specifciationId) {
        return this.getModelExtensions(specifciationId, EXT_BIND_ELT);
    }

    public List<ScaElementInformation> getImplementationExtensions(String specifciationId) {
        return this.getModelExtensions(specifciationId, EXT_IMPL_ELT);
    }

    public List<ScaElementInformation> getInterfaceExtensions(String specifciationId) {
        return this.getModelExtensions(specifciationId, EXT_ITF_ELT);
    }

    public List<ScaElementInformation> getAllExtensions(String specifciationId) {
        ArrayList<ScaElementInformation> result = new ArrayList<ScaElementInformation>();
        result.addAll(this.getModelExtensions(specifciationId, EXT_ITF_ELT));
        result.addAll(this.getModelExtensions(specifciationId, EXT_IMPL_ELT));
        result.addAll(this.getModelExtensions(specifciationId, EXT_BIND_ELT));
        return result;
    }

    private List<ScaElementInformation> getModelExtensions(String specificationId, String scaElement) {
        ArrayList<ScaElementInformation> result = new ArrayList<ScaElementInformation>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EP_ID);
        if (extensionPoint != null) {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    if (EXT_ELT.equals(configElement.getName()) && specificationId != null && specificationId.equals(configElement.getAttribute(DND_SPEC_ID_ATTR))) {
                        String contributorName = configElement.getDeclaringExtension().getContributor().getName();
                        IConfigurationElement[] iConfigurationElementArray2 = configElement.getChildren(scaElement);
                        int n5 = iConfigurationElementArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IConfigurationElement child = iConfigurationElementArray2[n6];
                            try {
                                String literalField = child.getAttribute(EXT_LITERAL_FIELD_ATTR);
                                String literalClass = child.getAttribute(EXT_LITERAL_CLASS_ATTR);
                                String iconPath = child.getAttribute(EXT_ICON_ATTR);
                                if (!iconPath.startsWith("/")) {
                                    iconPath = "/" + contributorName + "/" + iconPath;
                                }
                                Class javaClass = Platform.getBundle((String)contributorName).loadClass(literalClass);
                                Field field = javaClass.getField(literalField);
                                EStructuralFeature elementLiteral = (EStructuralFeature)field.get(null);
                                String type = child.getAttribute(EXT_TYPE_ATTR);
                                IElementType elementType = ElementTypeRegistry.getInstance().getType(type);
                                if (elementType == null) {
                                    ScaCoreCommonPlugin.log("Invalid element type for " + child.getAttribute(EXT_LABEL_ATTR), 4);
                                } else {
                                    ScaElementInformation info = new ScaElementInformation();
                                    info.setElementLiteral(elementLiteral);
                                    info.setIconPath(iconPath);
                                    info.setElementType(elementType);
                                    result.add(info);
                                }
                            }
                            catch (InvalidRegistryObjectException e) {
                                ScaCoreCommonPlugin.log((Exception)((Object)e), 2);
                            }
                            catch (SecurityException e) {
                                ScaCoreCommonPlugin.log(e, 2);
                            }
                            catch (IllegalArgumentException e) {
                                ScaCoreCommonPlugin.log(e, 2);
                            }
                            catch (ClassNotFoundException e) {
                                ScaCoreCommonPlugin.log(e, 2);
                            }
                            catch (NoSuchFieldException e) {
                                ScaCoreCommonPlugin.log(e, 2);
                            }
                            catch (IllegalAccessException e) {
                                ScaCoreCommonPlugin.log(e, 2);
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return result;
    }
}

