/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.diagram.router.lib;

import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.soa.sca.core.common.diagram.router.lib.ConnectionUtils;

public class SCAPolylineConnectionEx
extends PolylineConnectionEx {
    private boolean isDefault;
    private PointList smoothPoints;
    private boolean routerIsRectilinear = false;

    public PointList getSmoothPoints() {
        if (!this.routerIsRectilinear) {
            this.smoothPoints = super.getSmoothPoints();
        } else {
            super.setSmoothness(0);
            this.smoothPoints = ConnectionUtils.getRoundedRectilinearSmoothPoints(true, this.getPoints(), super.getSmoothness());
        }
        return this.smoothPoints;
    }

    protected void outlineShape(Graphics g) {
        super.outlineShape(g);
        if (this.isDefault) {
            Point res = new Point();
            PointList points = this.smoothPoints;
            int DISTANCE = MapModeUtil.getMapMode((IFigure)this).LPtoDP(40);
            long length = PointListUtilities.getPointsLength((PointList)points);
            long distance = length < (long)(DISTANCE * 2) ? length / 2L : (long)DISTANCE;
            res = PointListUtilities.pointOn((PointList)points, (long)distance, (LineSeg.KeyPoint)LineSeg.KeyPoint.ORIGIN, (Point)res);
            LineSeg segment = PointListUtilities.getNearestSegment((List)PointListUtilities.getLineSegments((PointList)points), (int)res.x, (int)res.y);
            double[] equation = segment.getEquation();
            double a = equation[0];
            double b = equation[1];
            double k = -a / b;
            double angleRad = Math.atan(k);
            double angleDeg = Math.toDegrees(angleRad);
            double angle1 = Math.toRadians(110.0 - angleDeg);
            double angle2 = angle1 + Math.PI;
            double x1 = (double)res.x + 7.0 * Math.cos(angle1);
            double y1 = (double)res.y - 7.0 * Math.sin(angle1);
            double x2 = (double)res.x + 7.0 * Math.cos(angle2);
            double y2 = (double)res.y - 7.0 * Math.sin(angle2);
            PrecisionPoint p1 = new PrecisionPoint(x1, y1);
            PrecisionPoint p2 = new PrecisionPoint(x2, y2);
            g.drawLine((Point)p1, (Point)p2);
        }
    }

    public void setRouterIsRectilinear(boolean routerIsRectilinear) {
        this.routerIsRectilinear = routerIsRectilinear;
    }
}

