/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.soa.sca.core.common.Messages;
import org.eclipse.soa.sca.core.common.ScaCoreCommonPlugin;
import org.eclipse.soa.sca.core.common.internal.ScaExtensionManager;
import org.eclipse.soa.sca.core.common.internal.builder.ScaMarkerHelper;
import org.eclipse.soa.sca.core.common.internal.provisional.extensions.IScaSpecificationExtension;
import org.eclipse.soa.sca.core.common.internal.provisional.utils.ScaValidationEntryBean;
import org.eclipse.soa.sca.core.common.utils.ResourceUtils;
import org.eclipse.soa.sca.core.common.utils.ScaCompositeNsFinder;
import org.eclipse.soa.sca.core.common.utils.ScaResourcesFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaIncrementalBuilder
extends IncrementalProjectBuilder {
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        Object bean;
        ArrayList<IFile> filesToValidate = new ArrayList<IFile>();
        if (kind == 6) {
            this.fullBuild(monitor, filesToValidate);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor, filesToValidate);
            } else {
                this.incrementalBuild(delta, monitor, filesToValidate);
            }
        }
        ArrayList<ScaValidationEntryBean> markerBeans = new ArrayList<ScaValidationEntryBean>();
        HashMap<String, ArrayList<IFile>> nsToSpecFiles = new HashMap<String, ArrayList<IFile>>();
        for (IFile compositeFile : filesToValidate) {
            String ns = ScaCompositeNsFinder.INSTANCE.getNamespaceUri(compositeFile);
            if (ns == null) {
                String msg = Messages.ScaIncrementalBuilder_0;
                bean = new ScaValidationEntryBean(compositeFile, msg, 4);
                markerBeans.add((ScaValidationEntryBean)bean);
                continue;
            }
            ArrayList<IFile> specFiles = (ArrayList<IFile>)nsToSpecFiles.get(ns);
            if (specFiles == null) {
                specFiles = new ArrayList<IFile>();
            }
            specFiles.add(compositeFile);
            nsToSpecFiles.put(ns, specFiles);
        }
        Set<IContainer> binaryContainers = ScaResourcesFilter.getBinaryContainers(this.getProject());
        bean = this.getProject().getReferencedProjects();
        int n = ((IProject[])bean).length;
        int ns = 0;
        while (ns < n) {
            IProject project = bean[ns];
            binaryContainers.addAll(ScaResourcesFilter.getBinaryContainers(project));
            ++ns;
        }
        IContainer[] containers = new IContainer[binaryContainers.size()];
        containers = binaryContainers.toArray(containers);
        for (Map.Entry entry : nsToSpecFiles.entrySet()) {
            IScaSpecificationExtension ext = ScaExtensionManager.INSTANCE.getScaExtensionByNamespace((String)entry.getKey());
            if (ext == null) {
                ScaCoreCommonPlugin.log(String.valueOf(Messages.ScaIncrementalBuilder_1) + (String)entry.getKey(), 4);
                continue;
            }
            Collection<ScaValidationEntryBean> validationEntries = ext.validate((Collection)entry.getValue(), containers);
            markerBeans.addAll(validationEntries);
        }
        ScaMarkerHelper.refreshMarkers(filesToValidate, markerBeans);
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor, List<IFile> filesToValidate) throws CoreException {
        try {
            Set<IContainer> sourceContainers = ScaResourcesFilter.getSourceContainers(this.getProject());
            List<IFile> compositeFiles = ResourceUtils.getFiles("composite", sourceContainers);
            filesToValidate.addAll(compositeFiles);
        }
        catch (Exception e) {
            ScaCoreCommonPlugin.log(e, 4);
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor, List<IFile> filesToValidate) throws CoreException {
        ValidatingScaDeltaVisitor visitor = new ValidatingScaDeltaVisitor(monitor, filesToValidate);
        delta.accept((IResourceDeltaVisitor)visitor);
        if (visitor.javaResourcesChanged) {
            filesToValidate.clear();
            this.fullBuild(monitor, filesToValidate);
        }
        Set<IContainer> binaryContainers = ScaResourcesFilter.getBinaryContainers(this.getProject());
        ArrayList<IFile> filesToRemove = new ArrayList<IFile>();
        block0: for (IFile f : filesToValidate) {
            for (IContainer container : binaryContainers) {
                if (!container.getFullPath().isPrefixOf(f.getFullPath())) continue;
                filesToRemove.add(f);
                continue block0;
            }
        }
        filesToValidate.removeAll(filesToRemove);
    }

    protected void checkCancel(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            this.forgetLastBuiltState();
            throw new OperationCanceledException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValidatingScaDeltaVisitor
    implements IResourceDeltaVisitor {
        private final IProgressMonitor monitor;
        private final List<IFile> filesToValidate;
        private boolean javaResourcesChanged = false;

        public ValidatingScaDeltaVisitor(IProgressMonitor monitor, List<IFile> filesToValidate) {
            this.monitor = monitor;
            this.filesToValidate = filesToValidate;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            ScaIncrementalBuilder.this.checkCancel(this.monitor);
            IResource resource = delta.getResource();
            boolean result = true;
            if (resource instanceof IProject && !((IProject)resource).isOpen()) {
                result = false;
            } else if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (file.getFileExtension().equals("class") || file.getName().equals(".classpath")) {
                    this.javaResourcesChanged = true;
                    result = false;
                } else if (file.getFileExtension().equals("composite") && file.exists()) {
                    this.filesToValidate.add(file);
                }
            }
            return result;
        }
    }
}

