/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.builder;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.osgi.util.NLS;
import org.eclipse.soa.sca.core.common.ScaCoreCommonPlugin;
import org.eclipse.soa.sca.core.common.internal.Messages;
import org.eclipse.soa.sca.core.common.internal.provisional.utils.ScaValidationEntryBean;
import org.eclipse.soa.sca.core.common.utils.LineResolverUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaMarkerHelper {
    public static void refreshMarkers(Collection<IFile> validatedFiles, Collection<ScaValidationEntryBean> markerBeans) {
        for (IFile f : validatedFiles) {
            ScaMarkerHelper.clearScaMarkers((IResource)f, 0);
        }
        HashSet<IFile> filesToMark = new HashSet<IFile>();
        for (ScaValidationEntryBean bean : markerBeans) {
            ScaMarkerHelper.createCompositeMarkers(bean);
            ScaMarkerHelper.createFakeDiagramMarker(bean.getFile());
            filesToMark.add(bean.getFile());
        }
        for (IFile f : filesToMark) {
            LineResolverUtils.resolveLineNumbers(f, "org.eclipse.stp.sca.common.composite", "xpath-signature");
        }
    }

    public static void createCompositeMarkers(ScaValidationEntryBean markerBean) {
        int severity = -1;
        switch (markerBean.getSeverity()) {
            case 1: {
                severity = 0;
                break;
            }
            case 2: {
                severity = 1;
                break;
            }
            case 4: {
                severity = 2;
            }
        }
        if (severity != -1) {
            try {
                IMarker marker = markerBean.getFile().createMarker("org.eclipse.stp.sca.common.composite");
                marker.setAttribute("lineNumber", 1);
                marker.setAttribute("priority", 1);
                marker.setAttribute("severity", severity);
                marker.setAttribute("message", (Object)markerBean.getMessage());
                if (markerBean.getScaSignature() != null) {
                    marker.setAttribute("signature", (Object)markerBean.getScaSignature().toString());
                }
                if (markerBean.getEobject() != null) {
                    String xpathSignature = ScaMarkerHelper.getXpathExpression(markerBean.getEobject());
                    marker.setAttribute("xpath-signature", (Object)xpathSignature);
                }
            }
            catch (CoreException e) {
                ScaCoreCommonPlugin.log((Exception)((Object)e), 4);
            }
        }
    }

    private static void createFakeDiagramMarker(IFile compositeFile) {
        IFile diagFile = ScaMarkerHelper.getCompositeDiagramFile(compositeFile);
        if (diagFile != null && diagFile.exists()) {
            int severity = 4;
            try {
                severity = compositeFile.findMaxProblemSeverity("org.eclipse.stp.sca.common.fDiagram", true, 0);
            }
            catch (CoreException e1) {
                ScaCoreCommonPlugin.log((Exception)((Object)e1), 2);
            }
            try {
                diagFile.deleteMarkers("org.eclipse.stp.sca.common.fDiagram", true, 0);
                if (severity != 0) {
                    IMarker marker = diagFile.createMarker("org.eclipse.stp.sca.common.fDiagram");
                    marker.setAttribute("priority", 1);
                    marker.setAttribute("severity", severity);
                    String msg = NLS.bind((String)Messages.MarkerHelper_0, (Object)compositeFile.getName());
                    marker.setAttribute("message", (Object)msg);
                }
            }
            catch (CoreException e) {
                ScaCoreCommonPlugin.log((Exception)((Object)e), 2);
            }
        }
    }

    public static IFile getCompositeDiagramFile(IFile compositeFile) {
        IFile result = null;
        if (compositeFile != null && compositeFile.getName().endsWith(".composite")) {
            try {
                IPath compPath = compositeFile.getProjectRelativePath().removeFileExtension().addFileExtension("composite_diagram");
                IFile compositeDiagramFile = compositeFile.getProject().getFile(compPath);
                if (compositeDiagramFile.exists()) {
                    result = compositeDiagramFile;
                }
            }
            catch (Exception e) {
                ScaCoreCommonPlugin.log(e, 4);
            }
        }
        return result;
    }

    public static void clearScaMarkers(IResource resource, int depth) {
        try {
            resource.deleteMarkers("org.eclipse.stp.sca.common.composite", true, depth);
            resource.deleteMarkers("org.eclipse.stp.sca.common.fDiagram", true, depth);
        }
        catch (CoreException e) {
            ScaCoreCommonPlugin.log((Exception)((Object)e), 2);
        }
    }

    private static String getXpathExpression(EObject object) {
        StringBuilder sb = new StringBuilder();
        while (object != null) {
            if (object.eContainmentFeature() != null) {
                String index = "";
                if (object.eContainingFeature().isMany()) {
                    int pos;
                    Object o = object.eContainer().eGet(object.eContainingFeature());
                    if (o instanceof FeatureMap) {
                        pos = -1;
                        for (Object unknownObject : (FeatureMap)o) {
                            ++pos;
                            if (unknownObject instanceof FeatureMap.Entry && object.equals(unknownObject = ((FeatureMap.Entry)unknownObject).getValue())) break;
                        }
                        index = "[" + (pos + 1) + "]";
                    } else if (o instanceof EList) {
                        pos = ((EList)o).indexOf((Object)object) + 1;
                        index = "[" + pos + "]";
                    }
                }
                String name = ExtendedMetaData.INSTANCE.getName((EStructuralFeature)object.eContainmentFeature());
                sb.insert(0, "/*[local-name()='" + name + "']" + index);
            }
            object = object.eContainer();
        }
        return sb.toString();
    }
}

