/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.editors.preferences;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.soa.sca.core.common.ScaCoreCommonPlugin;
import org.eclipse.soa.sca.core.common.internal.editors.preferences.ScaXmlPreferenceUtils;
import org.eclipse.soa.sca.core.common.internal.editors.preferences.beans.ScaXmlAttribute;
import org.eclipse.soa.sca.core.common.internal.editors.preferences.beans.ScaXmlElement;
import org.eclipse.soa.sca.core.common.internal.editors.preferences.beans.ScaXmlNamespace;
import org.eclipse.soa.sca.core.common.internal.editors.preferences.beans.ScaXmlPlatform;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaXmlPreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final String EP_ID = "org.eclipse.soa.sca.common.editors";
    private static final String PREF_ELT = "PreferenceInitializer";
    private static final String PREF_ATT = "resource";

    public void initializeDefaultPreferences() {
        List<ScaXmlPlatform> platforms = ScaXmlPreferenceInitializer.getDefaultPreferences();
        ScaXmlPreferenceUtils.savePlatformsToPS(platforms);
    }

    public static List<ScaXmlPlatform> getDefaultPreferences() {
        HashMap<String, String> resPathToPluginId = new HashMap<String, String>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = reg.getConfigurationElementsFor(EP_ID);
        IConfigurationElement[] iConfigurationElementArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String resPath;
            IConfigurationElement rootElement = iConfigurationElementArray[n2];
            if (PREF_ELT.equals(rootElement.getName()) && (resPath = rootElement.getAttribute(PREF_ATT)) != null && resPath.trim().length() > 0) {
                resPathToPluginId.put(resPath, rootElement.getContributor().getName());
            }
            ++n2;
        }
        String[] scaElements = new String[]{"bindings", "implementations", "interfaces"};
        ArrayList<ScaXmlPlatform> platforms = new ArrayList<ScaXmlPlatform>();
        for (Map.Entry entry : resPathToPluginId.entrySet()) {
            String name;
            Properties properties;
            InputStream in;
            block31: {
                Bundle bundle = Platform.getBundle((String)((String)entry.getValue()));
                if (bundle == null) {
                    ScaCoreCommonPlugin.log("The bundle " + (String)entry.getValue() + " could not be found.", 4);
                    continue;
                }
                URL url = bundle.getEntry((String)entry.getKey());
                in = null;
                try {
                    url = FileLocator.toFileURL((URL)url);
                }
                catch (Exception e) {
                    ScaCoreCommonPlugin.log(e, 4, "Could not find preference extension (" + (String)entry.getKey() + " in " + (String)entry.getValue() + ").");
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        ScaCoreCommonPlugin.log(e2, 2, "An input stream could not be closed.");
                    }
                    continue;
                }
                Path path = new Path(url.getPath());
                in = new FileInputStream(path.toFile());
                properties = new Properties();
                properties.load(in);
                name = properties.getProperty("name", null);
                if (name != null) break block31;
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException e) {
                    ScaCoreCommonPlugin.log(e, 2, "An input stream could not be closed.");
                }
                continue;
            }
            try {
                try {
                    ScaXmlPlatform platform = new ScaXmlPlatform(name);
                    HashMap<String, ScaXmlElement> elementIdToElement = new HashMap<String, ScaXmlElement>();
                    String[] stringArray = scaElements;
                    int n3 = scaElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String elementName = stringArray[n4];
                        String elements = properties.getProperty(elementName, "");
                        String[] stringArray2 = elements.split(",");
                        int n5 = stringArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String elementId = stringArray2[n6];
                            ScaXmlElement elt = ScaXmlPreferenceInitializer.processElement(properties, elementId = elementId.trim(), platform);
                            if (elt != null) {
                                elementIdToElement.put(elementId, elt);
                                platform.registerElement(elt, ScaXmlPlatform.ScaXmlElementType.valueOf(elementName));
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    String namespaces = properties.getProperty("namespaces", "");
                    String[] stringArray3 = namespaces.split(",");
                    int n7 = stringArray3.length;
                    n3 = 0;
                    while (n3 < n7) {
                        String namespaceId = stringArray3[n3];
                        String nsUri = properties.getProperty(String.valueOf(namespaceId = namespaceId.trim()) + ".uri", null);
                        if (nsUri != null) {
                            ScaXmlNamespace ns = new ScaXmlNamespace(nsUri, platform);
                            platform.namespaces.add(ns);
                            String[] stringArray4 = scaElements;
                            int n8 = scaElements.length;
                            int n9 = 0;
                            while (n9 < n8) {
                                String elementName = stringArray4[n9];
                                String mapping = properties.getProperty(String.valueOf(namespaceId) + "." + elementName, "");
                                String[] stringArray5 = mapping.split(",");
                                int n10 = stringArray5.length;
                                int n11 = 0;
                                while (n11 < n10) {
                                    String elementId = stringArray5[n11];
                                    ScaXmlElement elt = (ScaXmlElement)elementIdToElement.get(elementId.trim());
                                    if (elt != null) {
                                        platform.registerMapping(ns, elt, ScaXmlPlatform.ScaXmlElementType.valueOf(elementName));
                                    }
                                    ++n11;
                                }
                                ++n9;
                            }
                        }
                        ++n3;
                    }
                    platforms.add(platform);
                }
                catch (IOException e) {
                    ScaCoreCommonPlugin.log(e, 4);
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException e3) {
                        ScaCoreCommonPlugin.log(e3, 2, "An input stream could not be closed.");
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        ScaCoreCommonPlugin.log(e, 2, "An input stream could not be closed.");
                    }
                }
                throw throwable;
            }
            if (in == null) continue;
            try {
                in.close();
            }
            catch (IOException e) {
                ScaCoreCommonPlugin.log(e, 2, "An input stream could not be closed.");
            }
        }
        return platforms;
    }

    private static ScaXmlElement processElement(Properties properties, String elementId, Object parent) {
        String name = properties.getProperty(String.valueOf(elementId) + ".name", null);
        if (name == null) {
            return null;
        }
        ScaXmlElement elt = parent instanceof ScaXmlElement ? new ScaXmlElement(name, (ScaXmlElement)parent) : new ScaXmlElement(name, (ScaXmlPlatform)parent);
        String attributes = properties.getProperty(String.valueOf(elementId) + ".attributes", "");
        String[] stringArray = attributes.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeName;
            String attribute = stringArray[n2];
            attribute = attribute.trim();
            int index = attribute.lastIndexOf(61);
            String use = "optional";
            if (index > 0) {
                attributeName = attribute.substring(0, index).trim();
                use = attribute.substring(index).replace("=", "").trim().toLowerCase();
            } else {
                attributeName = attribute;
            }
            new ScaXmlAttribute(attributeName, elt, ScaXmlAttribute.ScaXmlAttributeProperty.valueOf(use));
            ++n2;
        }
        String subElements = properties.getProperty(String.valueOf(elementId) + ".elements", "");
        String[] stringArray2 = subElements.split(",");
        int n3 = stringArray2.length;
        n = 0;
        while (n < n3) {
            String subElementId = stringArray2[n];
            subElementId = subElementId.trim();
            ScaXmlPreferenceInitializer.processElement(properties, subElementId, elt);
            ++n;
        }
        return elt;
    }
}

