/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.formeditor.pages;

import org.eclipse.soa.sca.core.common.internal.editors.images.ScaImageRegistry;
import org.eclipse.soa.sca.core.common.internal.formeditor.Messages;
import org.eclipse.soa.sca.core.common.internal.formeditor.explorer.ScaResourceExplorer;
import org.eclipse.soa.sca.core.common.internal.formeditor.pages.AbstractPage;
import org.eclipse.soa.sca.core.common.internal.formeditor.ui.ScaCustomSwt;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OverviewPage
extends AbstractPage {
    private ScrolledForm form;
    private Element compositeElement;
    protected Text nameText;
    protected Text tnsText;
    protected Button localButton;
    protected Button autowireButton;
    protected ScaCustomSwt.TextAndButton constrainingTypeControl;

    public OverviewPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public void updatePage() {
        String autowireValue;
        boolean autowire;
        String localValue;
        boolean local;
        String ctValue;
        String tnsValue;
        if (this.document == null || this.nameText == null || this.nameText.isDisposed()) {
            return;
        }
        NodeList matchingElements = this.document.getElementsByTagNameNS("*", "composite");
        if (matchingElements.getLength() <= 0) {
            this.compositeElement = null;
            return;
        }
        this.compositeElement = (Element)matchingElements.item(0);
        String nameValue = this.compositeElement.getAttribute("name");
        String string = nameValue = nameValue != null ? nameValue : "";
        if (!nameValue.equals(this.nameText.getText())) {
            this.nameText.setText(nameValue);
        }
        String string2 = tnsValue = (tnsValue = this.compositeElement.getAttribute("targetNamespace")) != null ? tnsValue : "";
        if (!tnsValue.equals(this.tnsText.getText())) {
            this.tnsText.setText(tnsValue);
        }
        String string3 = ctValue = (ctValue = this.compositeElement.getAttribute("constrainingType")) != null ? ctValue : "";
        if (!ctValue.equals(this.constrainingTypeControl.getText().getText())) {
            this.constrainingTypeControl.getText().setText(ctValue);
        }
        boolean bl = local = (localValue = this.compositeElement.getAttribute("local")) != null ? Boolean.parseBoolean(localValue) : false;
        if (local != this.localButton.getSelection()) {
            this.localButton.setSelection(local);
        }
        boolean bl2 = autowire = (autowireValue = this.compositeElement.getAttribute("autowire")) != null ? Boolean.parseBoolean(autowireValue) : false;
        if (autowire != this.autowireButton.getSelection()) {
            this.autowireButton.setSelection(autowire);
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.form = managedForm.getForm();
        this.toolkit = managedForm.getToolkit();
        this.mmng = managedForm.getMessageManager();
        this.form.setText(Messages.OverviewPage_10);
        Image img = ScaImageRegistry.getInstance().getCompositeImg();
        this.form.setImage(img);
        this.toolkit.decorateFormHeading(this.form.getForm());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.topMargin = 10;
        this.form.getBody().setLayout((Layout)layout);
        this.addLeftPart(this.form.getBody());
        this.addRightPart(this.form.getBody());
        this.updatePage();
    }

    protected void addLeftPart(Composite parent) {
        Composite container = this.toolkit.createComposite(parent);
        TableWrapLayout layout2 = new TableWrapLayout();
        layout2.leftMargin = 0;
        layout2.rightMargin = 0;
        layout2.topMargin = 0;
        layout2.bottomMargin = 0;
        container.setLayout((Layout)layout2);
        container.setLayoutData((Object)new TableWrapData(256));
        ScaCustomSwt.SectionAndComposite sac = ScaCustomSwt.createSection(container, this.toolkit, true);
        Section section = sac.getSection();
        section.setText(Messages.OverviewPage_11);
        section.setDescription(Messages.OverviewPage_12);
        Composite part = sac.getComposite();
        GridLayout layout = new GridLayout(2, false);
        layout.marginBottom = 20;
        part.setLayout((Layout)layout);
        this.toolkit.paintBordersFor(part);
        Color blueFont = this.form.getDisplay().getSystemColor(10);
        Label nameLabel = this.toolkit.createLabel(part, Messages.OverviewPage_13, 64);
        nameLabel.setForeground(blueFont);
        nameLabel.setToolTipText(Messages.OverviewPage_14);
        this.nameText = this.toolkit.createText(part, "", 4);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (OverviewPage.this.compositeElement != null) {
                    String value = OverviewPage.this.compositeElement.getAttribute("name");
                    if (OverviewPage.this.nameText.getText().equals(value)) {
                        return;
                    }
                }
                if (OverviewPage.this.compositeElement == null) {
                    OverviewPage.this.startTransaction();
                    OverviewPage.this.compositeElement = OverviewPage.this.addElement(OverviewPage.this.document, "composite", "http://www.osoa.org/xmlns/sca/1.0");
                    OverviewPage.this.addOrSetAttribute(OverviewPage.this.compositeElement, "name", OverviewPage.this.nameText.getText());
                    OverviewPage.this.stopTransaction();
                } else {
                    OverviewPage.this.addOrSetAttribute(OverviewPage.this.compositeElement, "name", OverviewPage.this.nameText.getText());
                }
            }
        });
        Label namespaceLabel = this.toolkit.createLabel(part, Messages.OverviewPage_21, 64);
        namespaceLabel.setForeground(blueFont);
        namespaceLabel.setToolTipText(Messages.OverviewPage_22);
        this.tnsText = this.toolkit.createText(part, "", 4);
        this.tnsText.setLayoutData((Object)new GridData(768));
        this.tnsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (OverviewPage.this.compositeElement != null) {
                    String value = OverviewPage.this.compositeElement.getAttribute("targetNamespace");
                    if (OverviewPage.this.tnsText.getText().equals(value)) {
                        return;
                    }
                }
                if (OverviewPage.this.compositeElement == null) {
                    OverviewPage.this.startTransaction();
                    OverviewPage.this.compositeElement = OverviewPage.this.addElement(OverviewPage.this.document, "composite", "http://www.osoa.org/xmlns/sca/1.0");
                    OverviewPage.this.addOrSetAttribute(OverviewPage.this.compositeElement, "targetNamespace", OverviewPage.this.tnsText.getText());
                    OverviewPage.this.stopTransaction();
                } else {
                    OverviewPage.this.addOrSetAttribute(OverviewPage.this.compositeElement, "targetNamespace", OverviewPage.this.tnsText.getText());
                }
            }
        });
        Label constrainingTypeLabel = this.toolkit.createLabel(part, Messages.OverviewPage_29, 64);
        constrainingTypeLabel.setForeground(blueFont);
        constrainingTypeLabel.setToolTipText(Messages.OverviewPage_30);
        this.constrainingTypeControl = ScaCustomSwt.createTextAndButton(part, this.toolkit);
        this.constrainingTypeControl.getComposite().setLayoutData((Object)new GridData(768));
        this.constrainingTypeControl.getButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScaResourceExplorer dlg = new ScaResourceExplorer(OverviewPage.this.getSite().getShell());
                dlg.setFilter(ScaResourceExplorer.SCA_CONSTRAINING_TYPES);
                dlg.open();
            }
        });
        this.autowireButton = this.toolkit.createButton(part, Messages.OverviewPage_1, 32);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.verticalIndent = 10;
        this.autowireButton.setLayoutData((Object)layoutData);
        this.autowireButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String currentValue = Boolean.toString(OverviewPage.this.autowireButton.getSelection());
                if (OverviewPage.this.compositeElement != null) {
                    String value = OverviewPage.this.compositeElement.getAttribute("autowire");
                    if (currentValue == null || currentValue.equals(value)) {
                        return;
                    }
                }
                if (OverviewPage.this.compositeElement == null) {
                    OverviewPage.this.startTransaction();
                    OverviewPage.this.compositeElement = OverviewPage.this.addElement(OverviewPage.this.document, "composite", "http://www.osoa.org/xmlns/sca/1.0");
                    OverviewPage.this.addOrSetAttribute(OverviewPage.this.compositeElement, "autowire", currentValue);
                    OverviewPage.this.stopTransaction();
                } else {
                    OverviewPage.this.addOrSetAttribute(OverviewPage.this.compositeElement, "autowire", currentValue);
                }
            }
        });
        this.localButton = this.toolkit.createButton(part, Messages.OverviewPage_2, 32);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.localButton.setLayoutData((Object)layoutData);
        this.localButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String currentValue = Boolean.toString(OverviewPage.this.localButton.getSelection());
                if (OverviewPage.this.compositeElement != null) {
                    String value = OverviewPage.this.compositeElement.getAttribute("local");
                    if (currentValue == null || currentValue.equals(value)) {
                        return;
                    }
                }
                if (OverviewPage.this.compositeElement == null) {
                    OverviewPage.this.startTransaction();
                    OverviewPage.this.compositeElement = OverviewPage.this.addElement(OverviewPage.this.document, "composite", "http://www.osoa.org/xmlns/sca/1.0");
                    OverviewPage.this.addOrSetAttribute(OverviewPage.this.compositeElement, "local", currentValue);
                    OverviewPage.this.stopTransaction();
                } else {
                    OverviewPage.this.addOrSetAttribute(OverviewPage.this.compositeElement, "local", currentValue);
                }
            }
        });
    }

    protected void addRightPart(Composite composite) {
        Composite rightPart = this.toolkit.createComposite(composite);
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        rightPart.setLayout((Layout)layout);
        TableWrapData td = new TableWrapData(256);
        td.colspan = 1;
        rightPart.setLayoutData((Object)td);
        this.addCompositionSection(rightPart);
        this.addCommunicationSection(rightPart);
        this.addConfigurationSection(rightPart);
        this.addDependencySection(rightPart);
    }

    protected void addCompositionSection(Composite composite) {
        ScaCustomSwt.SectionAndComposite sac = ScaCustomSwt.createSection(composite, this.toolkit, true);
        Section section = sac.getSection();
        section.setText(Messages.OverviewPage_49);
        section.setDescription(Messages.OverviewPage_50);
        Composite part = sac.getComposite();
        Composite container = this.toolkit.createComposite(part);
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.bottomMargin = 0;
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new TableWrapData());
        Label imgLabel = this.toolkit.createLabel(container, "ComponentImage");
        Image img = ScaImageRegistry.getInstance().getComponentImg();
        imgLabel.setImage(img);
        FormText components = this.toolkit.createFormText(container, false);
        components.setText(Messages.OverviewPage_0, true, false);
        components.setLayoutData((Object)new TableWrapData(128));
        components.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OverviewPage.this.getEditor().setActivePage("org.eclipse.stp.sca.formeditor.components");
            }
        });
        imgLabel = this.toolkit.createLabel(container, "WireImage");
        img = ScaImageRegistry.getInstance().getWireImg();
        imgLabel.setImage(img);
        FormText wires = this.toolkit.createFormText(container, false);
        wires.setText(Messages.OverviewPage_54, true, false);
        wires.setLayoutData((Object)new TableWrapData(128));
        wires.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OverviewPage.this.getEditor().setActivePage("org.eclipse.stp.sca.formeditor.wires");
            }
        });
    }

    protected void addCommunicationSection(Composite composite) {
        ScaCustomSwt.SectionAndComposite sac = ScaCustomSwt.createSection(composite, this.toolkit, true);
        Section section = sac.getSection();
        section.setText(Messages.OverviewPage_55);
        section.setDescription(Messages.OverviewPage_56);
        Composite part = sac.getComposite();
        Composite container = this.toolkit.createComposite(part);
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.bottomMargin = 0;
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new TableWrapData());
        Label imgLabel = this.toolkit.createLabel(container, "ServiceImage");
        Image img = ScaImageRegistry.getInstance().getServiceImg();
        imgLabel.setImage(img);
        FormText services = this.toolkit.createFormText(container, false);
        services.setText(Messages.OverviewPage_58, true, false);
        services.setLayoutData((Object)new TableWrapData(128));
        services.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OverviewPage.this.getEditor().setActivePage("org.eclipse.stp.sca.formeditor.services");
            }
        });
        imgLabel = this.toolkit.createLabel(container, "ReferenceImage");
        img = ScaImageRegistry.getInstance().getReferenceImg();
        imgLabel.setImage(img);
        FormText references = this.toolkit.createFormText(container, false);
        references.setText(Messages.OverviewPage_60, true, false);
        references.setLayoutData((Object)new TableWrapData(128));
        references.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OverviewPage.this.getEditor().setActivePage("org.eclipse.stp.sca.formeditor.references");
            }
        });
    }

    protected void addConfigurationSection(Composite composite) {
        ScaCustomSwt.SectionAndComposite sac = ScaCustomSwt.createSection(composite, this.toolkit, true);
        Section section = sac.getSection();
        section.setText(Messages.OverviewPage_61);
        section.setDescription(Messages.OverviewPage_62);
        Composite part = sac.getComposite();
        Composite container = this.toolkit.createComposite(part);
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.bottomMargin = 0;
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new TableWrapData());
        Label imgLabel = this.toolkit.createLabel(container, "PropertyImage");
        Image img = ScaImageRegistry.getInstance().getPropertyImg();
        imgLabel.setImage(img);
        FormText properties = this.toolkit.createFormText(container, false);
        properties.setText(Messages.OverviewPage_64, true, false);
        properties.setLayoutData((Object)new TableWrapData(128));
        properties.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OverviewPage.this.getEditor().setActivePage("org.eclipse.stp.sca.formeditor.properties");
            }
        });
        imgLabel = this.toolkit.createLabel(container, "PolicyAndIntentImage");
        img = ScaImageRegistry.getInstance().getPolicySetImg();
        imgLabel.setImage(img);
        FormText policiesAndIntents = this.toolkit.createFormText(container, false);
        policiesAndIntents.setText(Messages.OverviewPage_90, true, false);
        policiesAndIntents.setLayoutData((Object)new TableWrapData(128));
        policiesAndIntents.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OverviewPage.this.getEditor().setActivePage("org.eclipse.stp.sca.formeditor.policies");
            }
        });
    }

    protected void addDependencySection(Composite composite) {
        ScaCustomSwt.SectionAndComposite sac = ScaCustomSwt.createSection(composite, this.toolkit, true);
        Section section = sac.getSection();
        section.setText(Messages.OverviewPage_67);
        section.setDescription(Messages.OverviewPage_68);
        Composite part = sac.getComposite();
        Composite container = this.toolkit.createComposite(part);
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.bottomMargin = 0;
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new TableWrapData());
        Label imgLabel = this.toolkit.createLabel(container, "IncludeImage");
        Image img = ScaImageRegistry.getInstance().getIncludeImg();
        imgLabel.setImage(img);
        FormText includes = this.toolkit.createFormText(container, false);
        includes.setText(Messages.OverviewPage_70, true, false);
        includes.setLayoutData((Object)new TableWrapData(128));
        includes.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OverviewPage.this.getEditor().setActivePage("org.eclipse.stp.sca.formeditor.includes");
            }
        });
    }
}

