/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.formeditor.pages.components;

import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.soa.sca.core.common.ScaCoreCommonPlugin;
import org.eclipse.soa.sca.core.common.internal.editors.preferences.viewers.ScaXmlPreferencesLabelProvider;
import org.eclipse.soa.sca.core.common.internal.formeditor.Messages;
import org.eclipse.soa.sca.core.common.internal.formeditor.pages.AbstractPage;
import org.eclipse.soa.sca.core.common.internal.formeditor.pages.NodeListContentProvider;
import org.eclipse.soa.sca.core.common.internal.formeditor.pages.components.ComponentPropertiesDetails;
import org.eclipse.soa.sca.core.common.internal.formeditor.pages.components.ComponentReferencesDetails;
import org.eclipse.soa.sca.core.common.internal.formeditor.pages.components.ComponentServicesDetails;
import org.eclipse.soa.sca.core.common.internal.formeditor.pages.components.SingleComponentDetails;
import org.eclipse.soa.sca.core.common.internal.formeditor.ui.ScaCustomSwt;
import org.eclipse.soa.sca.core.common.internal.formeditor.ui.TableViewerControl;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ComponentsMaster
extends MasterDetailsBlock {
    private final AbstractPage page;
    private TableViewerControl componentsControl;
    private ISelection selection = new StructuredSelection();
    private SectionPart sectionPart;
    private static final int SHOW_COMPONENT = 0;
    private static final int SHOW_SERVICES = 1;
    private static final int SHOW_REFERENCES = 2;
    private static final int SHOW_PROPERTIES = 3;
    private static final int SHOW_IMPLEMENTATION = 4;
    private int shownElements = 0;

    public ComponentsMaster(AbstractPage page) {
        this.page = page;
    }

    protected void createMasterPart(final IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = managedForm.getToolkit();
        Composite container = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginTop = 10;
        container.setLayout((Layout)layout);
        ScaCustomSwt.SectionAndComposite sac = ScaCustomSwt.createSection(container, toolkit, true);
        Section section = sac.getSection();
        section.setText(Messages.ComponentsMaster_0);
        section.setDescription(Messages.ComponentsMaster_1);
        section.descriptionVerticalSpacing = 10;
        section.setLayoutData((Object)new GridData(1808));
        section.setLayout((Layout)new GridLayout());
        Composite part = sac.getComposite();
        part.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        part.setLayout((Layout)layout);
        this.componentsControl = new TableViewerControl(part, toolkit, false, true);
        this.componentsControl.setContentProvider((IContentProvider)new NodeListContentProvider());
        this.componentsControl.setLabelProvider(new ScaXmlPreferencesLabelProvider());
        this.sectionPart = new SectionPart(section);
        managedForm.addPart((IFormPart)this.sectionPart);
        this.componentsControl.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ComponentsMaster.this.selection = event.getSelection();
                managedForm.fireSelectionChanged((IFormPart)ComponentsMaster.this.sectionPart, ComponentsMaster.this.selection);
            }
        });
        this.componentsControl.setInput(this.page.getDocument());
        this.componentsControl.getAdd().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentsMaster.this.page.addElement("component", "http://www.osoa.org/xmlns/sca/1.0");
            }
        });
        this.componentsControl.getRemove().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o;
                IStructuredSelection selection = (IStructuredSelection)ComponentsMaster.this.componentsControl.getViewerSelection();
                if (!selection.isEmpty() && (o = selection.getFirstElement()) instanceof Element) {
                    ComponentsMaster.this.page.removeElement((Element)o);
                }
            }
        });
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        Action action = new Action("Show the Component", 8){

            public void run() {
                if (ComponentsMaster.this.shownElements != 0) {
                    ComponentsMaster.this.shownElements = 0;
                    ComponentsMaster.this.sectionPart.getManagedForm().fireSelectionChanged((IFormPart)ComponentsMaster.this.sectionPart, ComponentsMaster.this.selection);
                }
            }
        };
        ImageDescriptor desc = ScaCoreCommonPlugin.getPluginImage("icons/obj16_form/Component.gif");
        action.setImageDescriptor(desc);
        action.setToolTipText(Messages.ComponentsMaster_4);
        action.setChecked(true);
        form.getToolBarManager().add((IAction)action);
        action = new Action("Show Services", 8){

            public void run() {
                if (ComponentsMaster.this.shownElements != 1) {
                    ComponentsMaster.this.shownElements = 1;
                    ComponentsMaster.this.sectionPart.getManagedForm().fireSelectionChanged((IFormPart)ComponentsMaster.this.sectionPart, ComponentsMaster.this.selection);
                }
            }
        };
        desc = ScaCoreCommonPlugin.getPluginImage("icons/obj16_form/Service.gif");
        action.setImageDescriptor(desc);
        action.setToolTipText(Messages.ComponentsMaster_5);
        form.getToolBarManager().add((IAction)action);
        action = new Action("Show References", 8){

            public void run() {
                if (ComponentsMaster.this.shownElements != 2) {
                    ComponentsMaster.this.shownElements = 2;
                    ComponentsMaster.this.sectionPart.getManagedForm().fireSelectionChanged((IFormPart)ComponentsMaster.this.sectionPart, ComponentsMaster.this.selection);
                }
            }
        };
        desc = ScaCoreCommonPlugin.getPluginImage("icons/obj16_form/Reference.gif");
        action.setImageDescriptor(desc);
        action.setToolTipText(Messages.ComponentsMaster_6);
        form.getToolBarManager().add((IAction)action);
        action = new Action("Show Properties", 8){

            public void run() {
                if (ComponentsMaster.this.shownElements != 3) {
                    ComponentsMaster.this.shownElements = 3;
                    ComponentsMaster.this.sectionPart.getManagedForm().fireSelectionChanged((IFormPart)ComponentsMaster.this.sectionPart, ComponentsMaster.this.selection);
                }
            }
        };
        desc = ScaCoreCommonPlugin.getPluginImage("icons/obj16_form/Property.gif");
        action.setImageDescriptor(desc);
        action.setToolTipText(Messages.ComponentsMaster_7);
        form.getToolBarManager().add((IAction)action);
        action = new Action("Show Implementation", 8){

            public void run() {
                if (ComponentsMaster.this.shownElements != 4) {
                    ComponentsMaster.this.shownElements = 4;
                    ComponentsMaster.this.sectionPart.getManagedForm().fireSelectionChanged((IFormPart)ComponentsMaster.this.sectionPart, ComponentsMaster.this.selection);
                }
            }
        };
        desc = ScaCoreCommonPlugin.getPluginImage("icons/obj16_form/ImplementationType.gif");
        action.setImageDescriptor(desc);
        action.setToolTipText(Messages.ComponentsMaster_8);
        form.getToolBarManager().add((IAction)action);
    }

    protected void registerPages(DetailsPart detailsPart) {
        detailsPart.setPageProvider(new IDetailsPageProvider(){

            public IDetailsPage getPage(Object key) {
                if (key != null && key instanceof Integer) {
                    switch ((Integer)key) {
                        case 0: {
                            return new SingleComponentDetails(ComponentsMaster.this.page);
                        }
                        case 1: {
                            return new ComponentServicesDetails(ComponentsMaster.this.page);
                        }
                        case 2: {
                            return new ComponentReferencesDetails(ComponentsMaster.this.page);
                        }
                        case 3: {
                            return new ComponentPropertiesDetails(ComponentsMaster.this.page);
                        }
                    }
                }
                return null;
            }

            public Object getPageKey(Object object) {
                if (object == null || ((Node)object).getNodeType() != 1) {
                    return -1;
                }
                try {
                    String eltName = ((Element)object).getLocalName().toLowerCase();
                    if ("component".equals(eltName)) {
                        return ComponentsMaster.this.shownElements;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return -1;
            }
        });
    }

    public void update() {
        if (!this.componentsControl.isDisposed()) {
            Object result = null;
            try {
                String expr = "/*[local-name()='composite']/*[local-name()='component']";
                result = AbstractPage.getXPath().evaluate(expr, this.page.getDocument(), XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            if (result == null) {
                result = new Object();
            }
            this.componentsControl.setInput(result);
            this.componentsControl.refreshViewer();
        }
    }
}

