/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.formeditor.pages.components;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.soa.sca.core.common.internal.formeditor.Messages;
import org.eclipse.soa.sca.core.common.internal.formeditor.explorer.ScaResourceExplorer;
import org.eclipse.soa.sca.core.common.internal.formeditor.pages.AbstractPage;
import org.eclipse.soa.sca.core.common.internal.formeditor.ui.ScaCustomSwt;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.w3c.dom.Element;

public class SingleComponentDetails
implements IDetailsPage {
    private IManagedForm form;
    private final AbstractPage page;
    private Element selectedElement;
    protected Text nameText;
    protected Button autowireButton;
    protected ScaCustomSwt.TextAndButton constrainingTypeControl;

    public SingleComponentDetails(AbstractPage page) {
        this.page = page;
    }

    public void createContents(Composite parent) {
        FormToolkit toolkit = this.form.getToolkit();
        Color blueFont = parent.getDisplay().getSystemColor(10);
        TableWrapLayout layout2 = new TableWrapLayout();
        layout2.leftMargin = 0;
        layout2.bottomMargin = 0;
        layout2.topMargin = 10;
        parent.setLayout((Layout)layout2);
        ScaCustomSwt.SectionAndComposite sac = ScaCustomSwt.createSection(parent, toolkit, true);
        Section section = sac.getSection();
        section.setText(Messages.SingleComponentDetails_0);
        section.setDescription(Messages.SingleComponentDetails_1);
        Composite part = sac.getComposite();
        GridLayout layout = new GridLayout(2, false);
        layout.marginBottom = 20;
        part.setLayout((Layout)layout);
        toolkit.paintBordersFor(part);
        Label nameLabel = toolkit.createLabel(part, Messages.SingleComponentDetails_2, 64);
        nameLabel.setForeground(blueFont);
        nameLabel.setToolTipText(Messages.SingleComponentDetails_3);
        this.nameText = toolkit.createText(part, "", 4);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SingleComponentDetails.this.selectedElement != null) {
                    String value = SingleComponentDetails.this.selectedElement.getAttribute("name");
                    if (!SingleComponentDetails.this.nameText.getText().equals(value)) {
                        SingleComponentDetails.this.page.addOrSetAttribute(SingleComponentDetails.this.selectedElement, "name", SingleComponentDetails.this.nameText.getText());
                        SingleComponentDetails.this.page.updateWiresAndPromotes(value, SingleComponentDetails.this.nameText.getText(), true);
                    }
                }
            }
        });
        Label constrainingTypeLabel = toolkit.createLabel(part, Messages.SingleComponentDetails_7, 64);
        constrainingTypeLabel.setForeground(blueFont);
        constrainingTypeLabel.setToolTipText(Messages.SingleComponentDetails_8);
        this.constrainingTypeControl = ScaCustomSwt.createTextAndButton(part, toolkit);
        this.constrainingTypeControl.getComposite().setLayoutData((Object)new GridData(768));
        this.constrainingTypeControl.getButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScaResourceExplorer dlg = new ScaResourceExplorer(SingleComponentDetails.this.page.getSite().getShell());
                dlg.setFilter(ScaResourceExplorer.SCA_CONSTRAINING_TYPES);
                dlg.open();
            }
        });
        this.autowireButton = toolkit.createButton(part, Messages.SingleComponentDetails_4, 32);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.autowireButton.setLayoutData((Object)layoutData);
        this.autowireButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (SingleComponentDetails.this.selectedElement != null) {
                    String newValue = Boolean.toString(SingleComponentDetails.this.autowireButton.getSelection());
                    String value = SingleComponentDetails.this.selectedElement.getAttribute("autowire");
                    if (newValue != null && !newValue.equals(value)) {
                        SingleComponentDetails.this.page.addOrSetAttribute(SingleComponentDetails.this.selectedElement, "autowire", newValue);
                    }
                }
            }
        });
    }

    public void commit(boolean onSave) {
    }

    public void dispose() {
    }

    public void initialize(IManagedForm form) {
        this.form = form;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
        this.update();
    }

    public void setFocus() {
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.selectedElement = ssel.size() == 1 ? (Element)ssel.getFirstElement() : null;
        this.update();
    }

    private void update() {
        String autowireValue;
        boolean autowire;
        String ctValue;
        if (this.selectedElement == null || this.nameText == null || this.nameText.isDisposed()) {
            return;
        }
        String nameValue = this.selectedElement.getAttribute("name");
        String string = nameValue = nameValue != null ? nameValue : "";
        if (!nameValue.equals(this.nameText.getText())) {
            this.nameText.setText(nameValue);
        }
        String string2 = ctValue = (ctValue = this.selectedElement.getAttribute("constrainingType")) != null ? ctValue : "";
        if (!ctValue.equals(this.constrainingTypeControl.getText().getText())) {
            this.constrainingTypeControl.getText().setText(ctValue);
        }
        boolean bl = autowire = (autowireValue = this.selectedElement.getAttribute("autowire")) != null ? Boolean.parseBoolean(autowireValue) : false;
        if (autowire != this.autowireButton.getSelection()) {
            this.autowireButton.setSelection(autowire);
        }
    }
}

