/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.soa.sca.core.common.Messages;
import org.eclipse.soa.sca.core.common.ScaCoreCommonPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class ScaComponentTypeWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private CTCreationPage page;
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private IConfigurationElement configElement;
    private IFile createdFile;
    public static final String CT_EXTENSION = "componentType";
    public static final String CT_BASIC_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<sca:componentType\n\txmlns=\"http://www.osoa.org/xmlns/sca/1.0\"\n\txmlns:sca=\"http://www.osoa.org/xmlns/sca/1.0\">\n\n</sca:componentType>";

    public ScaComponentTypeWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new CTCreationPage("MainPage", this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            this.createdFile = this.page.createNewFile();
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)this.createdFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                String editorId = this.workbench.getEditorRegistry().getDefaultEditor(this.createdFile.getFullPath().toString()).getId();
                page.openEditor((IEditorInput)new FileEditorInput(this.createdFile), editorId);
            }
            catch (PartInitException exception) {
                ScaCoreCommonPlugin.log((Exception)((Object)exception), 2);
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)org.eclipse.soa.sca.core.common.internal.Messages.ComponentTypeCreationWizard_8, (String)exception.getMessage());
            }
        }
        catch (Exception e) {
            ScaCoreCommonPlugin.log(e, 4);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.workbench = workbench;
        this.setWindowTitle(org.eclipse.soa.sca.core.common.internal.Messages.ComponentTypeCreationWizard_9);
        ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.soa.sca.core.common", (String)"icons/wizban/ComponentTypeBanner.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }

    private static class CTCreationPage
    extends WizardNewFileCreationPage {
        private String selectionName = "";

        public CTCreationPage(String pageName, IStructuredSelection selection) {
            super(pageName, selection);
            int index;
            String fileName;
            this.setFileExtension(ScaComponentTypeWizard.CT_EXTENSION);
            this.setTitle(Messages.ScaComponentTypeWizard_0);
            this.setDescription(Messages.ScaComponentTypeWizard_1);
            if (selection != null && selection.getFirstElement() != null && selection.getFirstElement() instanceof IFile && !(fileName = ((IFile)selection.getFirstElement()).getName()).endsWith(".componentType") && (index = fileName.lastIndexOf(46)) > 0) {
                this.selectionName = fileName.substring(0, index);
            }
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            String initialName = this.selectionName.trim();
            initialName = initialName.length() > 0 ? String.valueOf(initialName) + "." + ScaComponentTypeWizard.CT_EXTENSION : "default.componentType";
            this.setFileName(initialName);
            boolean pageEnabled = this.validatePage();
            this.setErrorMessage(null);
            this.setPageComplete(pageEnabled);
        }

        protected boolean validatePage() {
            boolean valid = super.validatePage();
            String name = this.getFileName();
            int dotPosition = name.lastIndexOf(46);
            String string = name = dotPosition >= 0 ? name.substring(0, dotPosition) : name;
            if (valid && name.length() == 0) {
                this.setErrorMessage(org.eclipse.soa.sca.core.common.internal.Messages.ComponentTypeCreationWizard_12);
                valid = false;
            }
            this.setPageComplete(valid);
            return valid;
        }

        protected InputStream getInitialContents() {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(ScaComponentTypeWizard.CT_BASIC_TEMPLATE.getBytes());
            return inputStream;
        }
    }
}

