/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.utils;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.soa.sca.core.common.ScaCoreCommonPlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

public class LineResolverUtils {
    public static void resolveLineNumbers(IFile file, String markerId, String markerAttribute) {
        block17: {
            IStructuredModel model = null;
            try {
                IMarker[] markers;
                int line = 0;
                model = StructuredModelManager.getModelManager().getExistingModelForRead(file);
                if (model == null || !file.exists() || markerAttribute == null || markerAttribute.trim().length() == 0) break block17;
                try {
                    markers = file.findMarkers(markerId, true, 0);
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                    markers = new IMarker[]{};
                }
                if (markers == null) {
                    markers = new IMarker[]{};
                }
                XPath xPath = XPathFactory.newInstance().newXPath();
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    String xpathLocation = marker.getAttribute(markerAttribute, null);
                    if (xpathLocation != null) {
                        Node node = null;
                        try {
                            node = (Node)xPath.evaluate(xpathLocation, ((IDOMModel)model).getDocument(), XPathConstants.NODE);
                        }
                        catch (XPathExpressionException e) {
                            String msg = "Failed to find the element " + xpathLocation + ".";
                            ScaCoreCommonPlugin.log(e, 2, msg);
                        }
                        if (node != null) {
                            int offset = -1;
                            if (node instanceof IDOMElement) {
                                offset = ((IDOMElement)node).getStartOffset();
                            } else if (node instanceof IDOMAttr) {
                                offset = ((IDOMAttr)node).getStartOffset();
                            }
                            line = model.getStructuredDocument().getLineOfOffset(offset) + 1;
                        }
                        try {
                            marker.setAttribute("lineNumber", line);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
    }
}

