/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.common.composite2java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.soa.sca.core.common.utils.JDTUtils;
import org.eclipse.soa.sca.core.common.utils.StringUtils;
import org.eclipse.soa.sca.sca1_0.common.composite2java.JInterface;
import org.eclipse.soa.sca.sca1_0.common.composite2java.JProperty;
import org.eclipse.soa.sca.sca1_0.common.composite2java.JReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JImplementation
extends JInterface {
    private final Map<String, JProperty> properties = new HashMap<String, JProperty>();
    private final Map<String, JReference> references = new HashMap<String, JReference>();

    public JImplementation() {
        this.isRemotable = false;
    }

    public Map<String, JProperty> getProperties() {
        return this.properties;
    }

    public Map<String, JReference> getReferences() {
        return this.references;
    }

    public boolean containsKeyProperty(Object key) {
        return this.properties.containsKey(key);
    }

    public Set<Map.Entry<String, JProperty>> propertyEntrySet() {
        return this.properties.entrySet();
    }

    public JProperty getProperty(Object key) {
        return this.properties.get(key);
    }

    public JProperty putProperty(String key, JProperty value) {
        return this.properties.put(key, value);
    }

    public JProperty removeProperty(Object key) {
        return this.properties.remove(key);
    }

    public boolean containsKeyReference(Object key) {
        return this.references.containsKey(key);
    }

    public Set<Map.Entry<String, JReference>> referenceEntrySet() {
        return this.references.entrySet();
    }

    public JReference getReference(Object key) {
        return this.references.get(key);
    }

    public JReference putReference(String key, JReference value) {
        return this.references.put(key, value);
    }

    public JReference removeReference(Object key) {
        return this.references.remove(key);
    }

    @Override
    protected TreeSet<String> getImports(String[] qnElements) {
        TreeSet<String> imports = super.getImports(qnElements);
        if (this.references.size() > 0) {
            imports.add("org.osoa.sca.annotations.Reference");
        }
        if (this.properties.size() > 0) {
            imports.add("org.osoa.sca.annotations.Property");
        }
        if (this.interfaces.size() > 0) {
            imports.add("org.osoa.sca.annotations.Service");
        }
        for (JReference ref : this.references.values()) {
            String type = ref.getType().getName();
            if (JDTUtils.getQualifiedNameElements((String)type)[0].equals(qnElements[0])) continue;
            imports.add(type);
        }
        return imports;
    }

    @Override
    protected String getDeclaration(String[] qnElements) {
        Iterator it;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> classes = new ArrayList<String>();
        for (String in : this.interfaces.keySet()) {
            classes.add(JDTUtils.getQualifiedNameElements((String)in)[1]);
        }
        if (classes.size() == 1) {
            sb.append("@Service(" + (String)classes.get(0) + ".class)\n");
        } else if (classes.size() > 1) {
            sb.append("@Service( interfaces={");
            it = classes.iterator();
            while (it.hasNext()) {
                sb.append(String.valueOf((String)it.next()) + ".class");
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("})\n");
        }
        sb.append("public class " + qnElements[1]);
        if (classes.size() > 0) {
            sb.append(" implements ");
        }
        it = classes.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    protected String getBody() {
        StringBuilder sb = new StringBuilder();
        sb.append(" {");
        if (this.properties.size() > 0) {
            sb.append("\n\n\t//\n\t// Properties");
            for (JProperty property : this.properties.values()) {
                sb.append("\n\t@Property\n\tpublic Object " + property.getName() + ";\t// TODO: replace \"Object\" by the right type.\n");
            }
        }
        if (this.references.size() > 0) {
            String type;
            sb.append("\n\n\t//\n\t// References");
            for (JReference ref : this.references.values()) {
                type = JDTUtils.getQualifiedNameElements((String)ref.getType().getName())[1];
                sb.append("\n\tprivate " + type + " " + ref.getName() + ";");
            }
            for (JReference ref : this.references.values()) {
                type = JDTUtils.getQualifiedNameElements((String)ref.getType().getName())[1];
                sb.append("\n\n\t@Reference(name=\"");
                sb.append(ref.getName());
                sb.append("\")\n\tpublic void set" + StringUtils.capitalize((String)ref.getName()) + "( ");
                sb.append(String.valueOf(type) + " " + ref.getName() + " ) {\n\t\t");
                sb.append("this." + ref.getName() + " = " + ref.getName() + ";\n\t}");
            }
        }
        sb.append("\n\n\t// TODO: define the service implementation.\n}");
        return sb.toString();
    }
}

