/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.common.compositeshell;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.soa.sca.sca1_0.common.compositeshell.CompositeShellWizard;
import org.eclipse.soa.sca.sca1_0.common.compositeshell.Messages;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class URIModelComposite
implements Listener {
    private Text uriText;
    private Button browseFileSystemButton;
    private Button browseWorkspaceButton;
    private final CompositeShellWizard selectModelWizardPage;
    private final String fileExtension;
    private final String label;
    private String uriInitialValue;

    public URIModelComposite(CompositeShellWizard selectModelWizardPage, String fileExtension, String label) {
        this.selectModelWizardPage = selectModelWizardPage;
        this.fileExtension = fileExtension;
        this.label = label;
        this.uriInitialValue = "";
    }

    public void dispose() {
        if (this.uriText != null) {
            this.uriText.removeListener(24, (Listener)this);
            this.uriText = null;
        }
        if (this.browseFileSystemButton != null) {
            this.browseFileSystemButton.removeListener(13, (Listener)this);
            this.browseFileSystemButton = null;
        }
        if (this.browseWorkspaceButton != null) {
            this.browseWorkspaceButton.removeListener(13, (Listener)this);
            this.browseWorkspaceButton = null;
        }
    }

    public void doHandleEvent(Event event) {
        if (event.type == 24 && event.widget == this.uriText) {
            this.uriTextModified(this.uriText.getText().trim());
        } else if (event.type == 13 && event.widget == this.browseFileSystemButton) {
            this.browseFileSystem();
        } else if (event.type == 13 && event.widget == this.browseWorkspaceButton) {
            this.browseWorkspace();
        }
    }

    protected void uriTextModified(String text) {
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        FormLayout layout = new FormLayout();
        layout.marginTop = 10;
        layout.spacing = 10;
        composite.setLayout((Layout)layout);
        Label uriLabel = new Label(composite, 16384);
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        uriLabel.setLayoutData((Object)data);
        uriLabel.setText(this.label);
        Composite uriComposite = new Composite(composite, 0);
        FormData data2 = new FormData();
        data2.top = new FormAttachment((Control)uriLabel, 5);
        data2.left = new FormAttachment(0);
        data2.right = new FormAttachment(100);
        uriComposite.setLayoutData((Object)data2);
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginTop = -5;
        layout2.marginLeft = -5;
        layout2.marginRight = -5;
        uriComposite.setLayout((Layout)layout2);
        Composite buttonComposite = new Composite(composite, 0);
        FormData data3 = new FormData();
        data3.top = new FormAttachment((Control)uriLabel, 0, 0x1000000);
        data3.left = new FormAttachment((Control)uriLabel, 0);
        data3.right = new FormAttachment(100);
        buttonComposite.setLayoutData((Object)data3);
        FormLayout layout3 = new FormLayout();
        layout3.marginTop = 0;
        layout3.marginBottom = 0;
        layout3.marginLeft = 0;
        layout3.marginRight = 0;
        layout3.spacing = 5;
        buttonComposite.setLayout((Layout)layout3);
        this.browseFileSystemButton = new Button(buttonComposite, 8);
        this.browseFileSystemButton.setText(Messages.URIModelComposite_0);
        this.browseFileSystemButton.addListener(13, (Listener)this);
        this.browseWorkspaceButton = new Button(buttonComposite, 8);
        this.browseWorkspaceButton.setText(Messages.URIModelComposite_1);
        this.browseWorkspaceButton.addListener(13, (Listener)this);
        data3 = new FormData();
        data3.right = new FormAttachment((Control)this.browseWorkspaceButton);
        this.browseFileSystemButton.setLayoutData((Object)data3);
        data3 = new FormData();
        data3.right = new FormAttachment(100);
        this.browseWorkspaceButton.setLayoutData((Object)data3);
        this.uriText = new Text(uriComposite, 2052);
        this.uriText.setText(this.uriInitialValue);
        if (this.uriText.getText().length() > 0) {
            this.uriText.selectAll();
        }
        this.uriText.addListener(24, (Listener)this);
        GridData gridData = new GridData(768);
        if (uriComposite.getChildren().length == 1) {
            gridData.horizontalSpan = 2;
        }
        this.uriText.setLayoutData((Object)gridData);
    }

    protected boolean browseFileSystem() {
        FileDialog fileDialog = new FileDialog(this.selectModelWizardPage.getShell(), 4100);
        fileDialog.setFilterExtensions(new String[]{"*." + this.fileExtension});
        if (fileDialog.open() != null && fileDialog.getFileNames().length > 0) {
            String[] fileNames = fileDialog.getFileNames();
            StringBuffer text = new StringBuffer();
            int i = 0;
            while (i < fileNames.length) {
                String filePath = String.valueOf(fileDialog.getFilterPath()) + File.separator + fileNames[i];
                text.append(URI.createFileURI((String)filePath).toString());
                text.append(" ");
                ++i;
            }
            this.uriText.setText(text.toString());
            return true;
        }
        return false;
    }

    protected boolean browseWorkspace() {
        IFile[] files;
        ViewerFilter extensionFilter = null;
        final ArrayList<String> fileExtensions = new ArrayList<String>();
        fileExtensions.add(this.fileExtension);
        if (!fileExtensions.isEmpty()) {
            extensionFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !(element instanceof IFile) || fileExtensions.contains(((IFile)element).getFileExtension());
                }
            };
        }
        if ((files = WorkspaceResourceDialog.openFileSelection((Shell)this.selectModelWizardPage.getShell(), null, null, (boolean)false, null, extensionFilter == null ? null : Collections.singletonList(extensionFilter))).length > 0) {
            StringBuffer text = new StringBuffer();
            int i = 0;
            while (i < files.length) {
                text.append(URI.createPlatformResourceURI((String)files[i].getFullPath().toString(), (boolean)true));
                ++i;
            }
            this.uriText.setText(text.toString());
            return true;
        }
        return false;
    }

    public void handleEvent(Event event) {
        this.doHandleEvent(event);
    }

    protected String getURI() {
        return this.uriText.getText();
    }

    protected void setURIInitialValue(String initialValue) {
        this.uriInitialValue = initialValue;
    }
}

