/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.common.handlers;

import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.soa.sca.core.common.classloader.ScaJdtClassLoader;
import org.eclipse.soa.sca.sca1_0.common.Sca1_0CommonPlugin;
import org.eclipse.soa.sca.sca1_0.common.introspection.ComponentTypeResolver;
import org.eclipse.soa.sca.sca1_0.common.introspection.JavaInterfaceResolver;
import org.eclipse.soa.sca.sca1_0.common.introspection.PromoteResolver;
import org.eclipse.soa.sca.sca1_0.common.introspection.ReferenceResolver;
import org.eclipse.soa.sca.sca1_0.common.utils.ScaModelUtils;
import org.eclipse.soa.sca.sca1_0.model.sca.Composite;
import org.eclipse.soa.sca.sca1_0.model.sca.DocumentRoot;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class IntrospectImplementationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IFile f;
        Object o;
        ISelection s = null;
        try {
            s = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        }
        catch (Exception exception) {}
        if (s instanceof IStructuredSelection && (o = ((IStructuredSelection)s).getFirstElement()) instanceof IFile && (f = (IFile)o).getName().endsWith(".composite")) {
            this.processComposite(f, new Shell());
        }
        return null;
    }

    private void processComposite(IFile compositeFile, Shell shell) {
        IJavaProject javaProject = null;
        try {
            if (compositeFile.getProject().hasNature("org.eclipse.jdt.core.javanature")) {
                javaProject = JavaCore.create((IProject)compositeFile.getProject());
            }
        }
        catch (CoreException e1) {
            Sca1_0CommonPlugin.log((Exception)((Object)e1), 2);
        }
        if (javaProject == null) {
            return;
        }
        ScaJdtClassLoader scaJdtClassLoader = new ScaJdtClassLoader(javaProject, ((Object)((Object)this)).getClass().getClassLoader());
        Resource resource = null;
        try {
            resource = new ScaModelUtils().getCompositeFile(compositeFile).eResource();
        }
        catch (ScaModelUtils.InvalidScaModelException e1) {
            Sca1_0CommonPlugin.log(e1, 4);
        }
        if (resource == null) {
            return;
        }
        Composite composite = ((DocumentRoot)resource.getContents().get(0)).getComposite();
        JavaInterfaceResolver javaInterfaceResolver = new JavaInterfaceResolver((ClassLoader)scaJdtClassLoader);
        composite = javaInterfaceResolver.resolve(composite);
        ComponentTypeResolver componentTypeResolver = new ComponentTypeResolver(compositeFile.getProject());
        composite = componentTypeResolver.resolve(composite);
        ReferenceResolver referenceResolver = new ReferenceResolver((ClassLoader)scaJdtClassLoader);
        composite = referenceResolver.resolve(composite);
        PromoteResolver promoteResolver = new PromoteResolver();
        composite = promoteResolver.resolve(composite);
        try {
            resource.save(null);
            compositeFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            Sca1_0CommonPlugin.log(e, 4);
        }
        catch (CoreException e) {
            Sca1_0CommonPlugin.log((Exception)((Object)e), 2);
        }
    }
}

