/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.common.introspection;

import java.util.Iterator;
import org.eclipse.soa.sca.sca1_0.common.introspection.Resolver;
import org.eclipse.soa.sca.sca1_0.model.sca.Component;
import org.eclipse.soa.sca.sca1_0.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_0.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_0.model.sca.Composite;
import org.eclipse.soa.sca.sca1_0.model.sca.Reference;
import org.eclipse.soa.sca.sca1_0.model.sca.ScaFactory;
import org.eclipse.soa.sca.sca1_0.model.sca.Service;
import org.eclipse.soa.sca.sca1_0.model.sca.Wire;

public class PromoteResolver
implements Resolver {
    public Composite resolve(Composite composite) {
        this.promoteServices(composite);
        this.promoteReferences(composite);
        return composite;
    }

    private void promoteReferences(Composite composite) {
        for (Component component : composite.getComponent()) {
            for (ComponentReference cr : component.getReference()) {
                if (this.isComponentReferenceUsed(composite, cr)) continue;
                Reference reference = ScaFactory.eINSTANCE.createReference();
                reference.setName(cr.getName());
                reference.getPromote().add((Object)cr);
                composite.getReference().add((Object)reference);
            }
        }
    }

    private boolean isComponentReferenceUsed(Composite composite, ComponentReference cr) {
        boolean used = false;
        boolean bl = used = cr.getTarget() != null;
        if (!used) {
            for (Wire wire : composite.getWire()) {
                if (!wire.getSource2().equals(cr)) continue;
                used = true;
                break;
            }
        }
        if (!used) {
            Iterator it = composite.getReference().iterator();
            while (!used && it.hasNext()) {
                Reference reference = (Reference)it.next();
                used = reference.getPromote().contains((Object)cr);
            }
        }
        return used;
    }

    private void promoteServices(Composite composite) {
        for (Component component : composite.getComponent()) {
            for (ComponentService cs : component.getService()) {
                if (this.isComponentServiceUsed(composite, cs)) continue;
                Service service = ScaFactory.eINSTANCE.createService();
                service.setName(cs.getName());
                service.setPromote(cs);
                composite.getService().add((Object)service);
            }
        }
    }

    private boolean isComponentServiceUsed(Composite composite, ComponentService cs) {
        boolean used = false;
        if (!used) {
            for (Wire wire : composite.getWire()) {
                if (!wire.getTarget2().equals(cs)) continue;
                used = true;
                break;
            }
        }
        Iterator it = composite.getService().iterator();
        while (!used && it.hasNext()) {
            Service service = (Service)it.next();
            used = service.getPromote().equals(cs);
        }
        if (!used) {
            Iterator it1 = composite.getComponent().iterator();
            while (!used && it1.hasNext()) {
                Component component = (Component)it1.next();
                Iterator it2 = component.getReference().iterator();
                while (!used && it2.hasNext()) {
                    ComponentReference ref = (ComponentReference)it2.next();
                    used = ref.getTarget().contains((Object)cs);
                }
            }
        }
        return used;
    }
}

