/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.common.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.soa.sca.core.common.internal.provisional.utils.IScaSignature;
import org.eclipse.soa.sca.core.common.utils.DomUtils;
import org.eclipse.soa.sca.sca1_0.model.sca.BaseReference;
import org.eclipse.soa.sca.sca1_0.model.sca.BaseService;
import org.eclipse.soa.sca.sca1_0.model.sca.Component;
import org.eclipse.soa.sca.sca1_0.model.sca.Composite;
import org.eclipse.soa.sca.sca1_0.model.sca.DocumentRoot;
import org.eclipse.soa.sca.sca1_0.model.sca.Include;
import org.eclipse.soa.sca.sca1_0.model.sca.Property;
import org.eclipse.soa.sca.sca1_0.model.sca.PropertyValue;
import org.eclipse.soa.sca.sca1_0.model.sca.Wire;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScaSignature
implements IScaSignature {
    private String signature;
    public static final String UNRESOLVED = "unresolved";

    public ScaSignature(Node xmlNode) {
        Node parentNode = xmlNode;
        while (parentNode != null) {
            if (parentNode.getNodeType() == 1) {
                String attrName;
                Element element = (Element)parentNode;
                String name = DomUtils.getNodeName((Node)parentNode).toLowerCase();
                if (name.equals("composite")) {
                    attrName = element.getAttribute("name");
                    String attrTns = element.getAttribute("targetNamespace");
                    this.signature = this.signature == null ? "composite[" + attrName + "," + attrTns + "]" : "composite[" + attrName + "," + attrTns + "]/" + this.signature;
                } else if (name.equals("include")) {
                    String includeName;
                    String nsUri = "";
                    String localPart = "";
                    Pattern namespacePattern = Pattern.compile("\\{.+\\}");
                    Matcher m = namespacePattern.matcher(includeName = element.getAttribute("name"));
                    if (m.find()) {
                        nsUri = includeName.substring(m.start() + 1, m.end() - 1);
                        int namespaceEndPosition = includeName.lastIndexOf("}");
                        localPart = includeName.substring(namespaceEndPosition + 1);
                    } else {
                        String[] parts = includeName.split(":");
                        if (parts.length == 1) {
                            localPart = includeName;
                            nsUri = element.getNamespaceURI();
                        } else {
                            localPart = parts[1];
                            nsUri = DomUtils.lookupNamespaceURI((String)parts[0], (Node)element);
                        }
                    }
                    this.signature = this.signature == null ? "include[" + localPart + "," + nsUri + "]" : "include[" + localPart + "," + nsUri + "]/" + this.signature;
                } else if (name.equals("wire")) {
                    String source = element.getAttribute("source");
                    String target = element.getAttribute("target");
                    this.signature = this.signature == null ? String.valueOf(name) + "[" + source + " -> " + target + "]" : String.valueOf(name) + "[" + source + " -> " + target + "]/" + this.signature;
                } else if (name.equals("component") || name.equals("service") || name.equals("reference") || name.equals("property")) {
                    attrName = element.getAttribute("name");
                    this.signature = this.signature == null ? String.valueOf(name) + "[" + attrName + "]" : String.valueOf(name) + "[" + attrName + "]/" + this.signature;
                } else {
                    this.signature = this.signature == null ? name : String.valueOf(name) + "/" + this.signature;
                }
            } else {
                this.signature = UNRESOLVED;
                break;
            }
            parentNode = parentNode.getParentNode();
        }
    }

    public ScaSignature(EObject emfObject) {
        EObject container = emfObject;
        while (container != null && !(container instanceof DocumentRoot)) {
            String name;
            if (container instanceof Composite) {
                String attrName = ((Composite)container).getName();
                String attrTns = ((Composite)container).getTargetNamespace();
                this.signature = this.signature == null ? "composite[" + attrName + "," + attrTns + "]" : "composite[" + attrName + "," + attrTns + "]/" + this.signature;
            } else if (container instanceof Include) {
                QName q = ((Include)container).getName();
                this.signature = this.signature == null ? "include[" + q.getLocalPart() + "," + q.getNamespaceURI() + "]" : "include[" + q.getLocalPart() + "," + q.getNamespaceURI() + "]/" + this.signature;
            } else if (container instanceof Wire) {
                String source = ((Wire)container).getSource();
                String target = ((Wire)container).getTarget();
                if (source == null) {
                    source = "";
                }
                if (target == null) {
                    target = "";
                }
                this.signature = this.signature == null ? "wire[" + source + " -> " + target + "]" : "wire[" + source + " -> " + target + "]/" + this.signature;
            } else if (container instanceof Component || container instanceof BaseReference || container instanceof BaseService || container instanceof Property || container instanceof PropertyValue) {
                name = ExtendedMetaData.INSTANCE.getName((EStructuralFeature)container.eContainmentFeature());
                EStructuralFeature feature = container.eClass().getEStructuralFeature("name");
                String attrName = (String)container.eGet(feature);
                this.signature = this.signature == null ? String.valueOf(name) + "[" + attrName + "]" : String.valueOf(name) + "[" + attrName + "]/" + this.signature;
            } else {
                name = null;
                if (container.eContainmentFeature() != null) {
                    name = ExtendedMetaData.INSTANCE.getName((EStructuralFeature)container.eContainmentFeature());
                }
                this.signature = this.signature == null ? name : String.valueOf(name) + "/" + this.signature;
            }
            container = container.eContainer();
        }
        if (this.signature == null) {
            this.signature = UNRESOLVED;
        }
    }

    public String toString() {
        return this.signature;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ScaSignature)) {
            return false;
        }
        ScaSignature ss = (ScaSignature)obj;
        if (this.signature == null) {
            return ss.signature == null;
        }
        return this.signature.equals(ss.signature);
    }

    public int hashCode() {
        if (this.signature == null) {
            return 17;
        }
        return this.signature.hashCode();
    }
}

