/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.diagram.customactions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.soa.sca.core.common.diagram.commands.MyPersistViewsCommand;
import org.eclipse.soa.sca.sca1_0.diagram.customactions.AutoSizeAction;
import org.eclipse.soa.sca.sca1_0.diagram.customactions.Messages;
import org.eclipse.soa.sca.sca1_0.diagram.edit.parts.CompositeEditPart;
import org.eclipse.soa.sca.sca1_0.diagram.edit.parts.DocumentRootEditPart;
import org.eclipse.soa.sca.sca1_0.diagram.part.SCALayoutEditPartProvider;
import org.eclipse.soa.sca.sca1_0.diagram.part.ScaDiagramEditorPlugin;
import org.eclipse.soa.sca.sca1_0.diagram.part.ScaDiagramEditorUtil;
import org.eclipse.soa.sca.sca1_0.diagram.part.ScaVisualIDRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramGeneration
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;
    private IProject project;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return;
        }
        this.project = (IProject)((IStructuredSelection)selection).getFirstElement();
        action.setEnabled(true);
    }

    private List<IFile> getCompositeFiles(IResource[] resources) throws CoreException {
        ArrayList<IFile> result = new ArrayList<IFile>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (file.getFileExtension() != null && file.getFileExtension().equals("composite")) {
                    result.add(file);
                }
            } else if (resource instanceof IFolder) {
                IFolder folder = (IFolder)resource;
                List<IFile> rr = this.getCompositeFiles(folder.members());
                result.addAll(rr);
            }
            ++n2;
        }
        return result;
    }

    private EObject getDiagramRoot(ResourceSet resourceSet, URI domainModelURI) {
        Resource resource = resourceSet.getResource(domainModelURI, true);
        EObject result = (EObject)resource.getContents().get(0);
        return result;
    }

    private IFile createDiagramFile(IFile compositeFile) throws CoreException {
        String c = new Character('/').toString();
        String diagramFileName = compositeFile.getParent().getFullPath() + c + ScaDiagramEditorUtil.getUniqueFileName(compositeFile.getParent().getFullPath(), compositeFile.getName().replace(".composite", ""), "composite_diagram");
        Path diagramFilePath = new Path(diagramFileName);
        IFile diagramFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)diagramFilePath);
        diagramFile.create((InputStream)new ByteArrayInputStream(new byte[0]), 0, null);
        return diagramFile;
    }

    private void createDiagram(IFile diagramFile, final EObject diagramRoot, ResourceSet resourceSet, final TransactionalEditingDomain myEditingDomain) {
        LinkedList<IFile> affectedFiles = new LinkedList<IFile>();
        affectedFiles.add(diagramFile);
        ScaDiagramEditorUtil.setCharset(diagramFile);
        URI diagramModelURI = URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString(), (boolean)true);
        final Resource diagramResource = resourceSet.createResource(diagramModelURI);
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(myEditingDomain, Messages.DiagramGeneration_0, affectedFiles){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                int diagramVID = ScaVisualIDRegistry.getDiagramVisualID(diagramRoot);
                if (diagramVID != 1000) {
                    return CommandResult.newErrorCommandResult((String)Messages.DiagramGeneration_1);
                }
                Diagram diagram = ViewService.createDiagram((EObject)diagramRoot, (String)"Sca", (PreferencesHint)ScaDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                diagramResource.getContents().add((Object)diagram);
                DiagramGeneration.this.autoSize(diagram, myEditingDomain);
                DiagramGeneration.this.arrangeAll(diagram, myEditingDomain);
                DiagramGeneration.this.autoSize(diagram, myEditingDomain);
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
            diagramResource.save(ScaDiagramEditorUtil.getSaveOptions());
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            ScaDiagramEditorPlugin.getInstance().logError(Messages.DiagramGeneration_2, e);
        }
        catch (IOException ex) {
            ScaDiagramEditorPlugin.getInstance().logError(String.valueOf(Messages.DiagramGeneration_3) + diagramModelURI, ex);
        }
    }

    private CompositeEditPart getCompositeEditPart(DocumentRootEditPart rootEP) {
        CompositeEditPart compositeEP = null;
        for (Object o : rootEP.getChildren()) {
            if (!(o instanceof CompositeEditPart)) continue;
            compositeEP = (CompositeEditPart)((Object)o);
        }
        return compositeEP;
    }

    private void persistViews(DocumentRootEditPart rootEP, TransactionalEditingDomain myEditingDomain) {
        List<View> views = this.getViews((View)rootEP.getModel());
        MyPersistViewsCommand persistViewCmd = new MyPersistViewsCommand(myEditingDomain, views);
        try {
            persistViewCmd.doExecuteWithResult((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (Exception e) {
            ScaDiagramEditorPlugin.getInstance().logError(e.getMessage(), e);
        }
    }

    private void autoSize(Diagram diagram, TransactionalEditingDomain myEditingDomain) {
        Shell shell = this.targetPart != null ? this.targetPart.getSite().getShell() : new Shell();
        DiagramEditPart diagramEditPart = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell);
        DocumentRootEditPart rootEP = (DocumentRootEditPart)diagramEditPart;
        CompositeEditPart compositeEP = this.getCompositeEditPart(rootEP);
        AutoSizeAction autosizeAction = new AutoSizeAction((GraphicalEditPart)compositeEP);
        autosizeAction.run();
        compositeEP.refresh();
        rootEP.getRoot().refresh();
        this.persistViews(rootEP, myEditingDomain);
    }

    private void arrangeAll(Diagram diagram, TransactionalEditingDomain myEditingDomain) {
        Shell shell = this.targetPart != null ? this.targetPart.getSite().getShell() : new Shell();
        DiagramEditPart diagramEditPart = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell);
        DocumentRootEditPart rootEP = (DocumentRootEditPart)diagramEditPart;
        CompositeEditPart compositeEP = this.getCompositeEditPart(rootEP);
        SCALayoutEditPartProvider vv = new SCALayoutEditPartProvider();
        ArrayList<CompositeEditPart> list = new ArrayList<CompositeEditPart>();
        list.add(compositeEP);
        Command cmd = vv.layoutEditParts(list, null);
        diagramEditPart.getDiagramEditDomain().getDiagramCommandStack().execute(cmd);
        compositeEP.refresh();
        rootEP.getRoot().refresh();
        this.persistViews(rootEP, myEditingDomain);
    }

    private List<View> getViews(View view) {
        ArrayList<View> result = new ArrayList<View>();
        result.add(view);
        for (Object v : view.getChildren()) {
            if (!(v instanceof View)) continue;
            result.addAll(this.getViews((View)v));
        }
        return result;
    }

    private void createDiagram(IFile compositeFile, TransactionalEditingDomain myEditingDomain, ResourceSet resourceSet) throws CoreException {
        URI domainModelURI = URI.createPlatformResourceURI((String)compositeFile.getFullPath().toString(), (boolean)true);
        EObject diagramRoot = this.getDiagramRoot(resourceSet, domainModelURI);
        IFile diagramFile = this.createDiagramFile(compositeFile);
        this.createDiagram(diagramFile, diagramRoot, resourceSet, myEditingDomain);
    }

    public void run(IAction action) {
        List<IFile> compositeFiles = null;
        try {
            compositeFiles = this.getCompositeFiles(this.project.members());
        }
        catch (CoreException e) {
            ScaDiagramEditorPlugin.getInstance().logError(e.getMessage(), e);
            return;
        }
        TransactionalEditingDomain myEditingDomain = WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();
        ResourceSet resourceSet = myEditingDomain.getResourceSet();
        for (IFile compositeFile : compositeFiles) {
            try {
                this.createDiagram(compositeFile, myEditingDomain, resourceSet);
            }
            catch (CoreException e) {
                ScaDiagramEditorPlugin.getInstance().logError(e.getMessage(), e);
            }
        }
    }

    public void runExternal(IFile compositeFile) {
        ArrayList<IFile> compositeFiles = new ArrayList<IFile>();
        compositeFiles.add(compositeFile);
        TransactionalEditingDomain myEditingDomain = WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();
        ResourceSet resourceSet = myEditingDomain.getResourceSet();
        try {
            this.createDiagram(compositeFile, myEditingDomain, resourceSet);
        }
        catch (CoreException e) {
            ScaDiagramEditorPlugin.getInstance().logError(e.getMessage(), e);
        }
    }
}

