/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.diagram.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.soa.sca.core.common.diagram.extension.edit.part.ScaElementExtendedInformation;
import org.eclipse.soa.sca.core.common.diagram.extension.edit.part.ScaElementType;
import org.eclipse.soa.sca.sca1_0.diagram.extension.LocalDiagramExtensionManager;
import org.eclipse.soa.sca.sca1_0.diagram.extension.ScaElementInformationUtils;
import org.eclipse.soa.sca.sca1_0.diagram.part.ScaNodeDescriptor;
import org.eclipse.soa.sca.sca1_0.model.sca.BaseReference;
import org.eclipse.soa.sca.sca1_0.model.sca.BaseService;
import org.eclipse.soa.sca.sca1_0.model.sca.Binding;
import org.eclipse.soa.sca.sca1_0.model.sca.Component;
import org.eclipse.soa.sca.sca1_0.model.sca.Implementation;
import org.eclipse.soa.sca.sca1_0.model.sca.Interface;
import org.eclipse.soa.sca.sca1_0.model.sca.ScaPackage;

public class LocalDiagramExtensionUtils {
    public static int getVisualID(View view) {
        return LocalDiagramExtensionUtils.getVisualID(view.getType());
    }

    public static int getVisualID(String str) {
        try {
            int parseInt = Integer.parseInt(str);
            return parseInt < 0 ? -1 * parseInt : parseInt;
        }
        catch (NumberFormatException numberFormatException) {
            int rawHashCode = str.hashCode();
            return rawHashCode < 0 ? -1 * rawHashCode : rawHashCode;
        }
    }

    public static List getSemanticReferenceBindingChildrenList(View viewObject) {
        if (!(viewObject.eContainer() instanceof View)) {
            return Collections.EMPTY_LIST;
        }
        View containerView = (View)viewObject.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.EMPTY_LIST;
        }
        BaseReference modelElement = (BaseReference)containerView.getElement();
        return LocalDiagramExtensionUtils.getSemanticElementChildrenList(modelElement.getBinding(), viewObject, ScaElementType.BINDING);
    }

    public static List getSemanticServiceBindingChildrenList(View viewObject) {
        if (!(viewObject.eContainer() instanceof View)) {
            return Collections.EMPTY_LIST;
        }
        View containerView = (View)viewObject.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.EMPTY_LIST;
        }
        BaseService modelElement = (BaseService)containerView.getElement();
        return LocalDiagramExtensionUtils.getSemanticElementChildrenList(modelElement.getBinding(), viewObject, ScaElementType.BINDING);
    }

    private static List getSemanticElementChildrenList(EList elements, View viewObject, ScaElementType type) {
        List<Object> elementList;
        switch (type) {
            case BINDING: {
                elementList = LocalDiagramExtensionManager.INSTANCE.getBindingExtensions();
                break;
            }
            case IMPLEMENTATION: {
                elementList = LocalDiagramExtensionManager.INSTANCE.getImplementationExtensions();
                break;
            }
            case INTERFACE: {
                elementList = LocalDiagramExtensionManager.INSTANCE.getInterfaceExtensions();
                break;
            }
            default: {
                elementList = Collections.emptyList();
            }
        }
        ArrayList<EObject> list = new ArrayList<EObject>();
        for (Binding childElement : elements) {
            for (ScaElementExtendedInformation scaElementExtendedInformation : elementList) {
                int visualID = scaElementExtendedInformation.getVisualIDRegistry().getNodeVisualID(viewObject, (EObject)childElement);
                if (visualID != scaElementExtendedInformation.getVisualId()) continue;
                list.add(new ScaNodeDescriptor((EObject)childElement, visualID).getModelElement());
            }
        }
        return list;
    }

    public static Boolean isOrphanedBinding(Collection semanticChildren, View view, EditPart editPart) {
        for (ScaElementExtendedInformation bindingInformation : LocalDiagramExtensionManager.INSTANCE.getBindingExtensions()) {
            if (LocalDiagramExtensionUtils.getVisualID(view) != bindingInformation.getVisualId()) continue;
            int id = bindingInformation.getVisualIDRegistry().getNodeVisualID((View)editPart.getModel(), view.getElement());
            return new Boolean(!semanticChildren.contains(view.getElement()) || LocalDiagramExtensionUtils.getVisualID(view) != id);
        }
        return null;
    }

    public static ICommand getCreateReferenceBindingCommand(CreateElementRequest req) {
        for (ScaElementExtendedInformation bindingInformation : LocalDiagramExtensionManager.INSTANCE.getBindingExtensions()) {
            if (bindingInformation.getElementType() != req.getElementType()) continue;
            if (req.getContainmentFeature() == null) {
                req.setContainmentFeature(ScaPackage.eINSTANCE.getBaseReference_Binding());
            }
            return ScaElementInformationUtils.createReferenceBindingCommand(bindingInformation, req);
        }
        return null;
    }

    public static ICommand getCreateServiceBindingCommand(CreateElementRequest req) {
        for (ScaElementExtendedInformation bindingInformation : LocalDiagramExtensionManager.INSTANCE.getBindingExtensions()) {
            if (bindingInformation.getElementType() != req.getElementType()) continue;
            if (req.getContainmentFeature() == null) {
                req.setContainmentFeature(ScaPackage.eINSTANCE.getBaseService_Binding());
            }
            return ScaElementInformationUtils.createServiceBindingCommand(bindingInformation, req);
        }
        return null;
    }

    public static List getSemanticReferenceInterfaceChildrenList(View viewObject) {
        if (!(viewObject.eContainer() instanceof View)) {
            return Collections.EMPTY_LIST;
        }
        View containerView = (View)viewObject.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.EMPTY_LIST;
        }
        BaseReference modelElement = (BaseReference)containerView.getElement();
        return LocalDiagramExtensionUtils.getSemanticInterfaceChildrenList(modelElement.getInterface(), viewObject);
    }

    public static List getSemanticServiceInterfaceChildrenList(View viewObject) {
        if (!(viewObject.eContainer() instanceof View)) {
            return Collections.EMPTY_LIST;
        }
        View containerView = (View)viewObject.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.EMPTY_LIST;
        }
        BaseService modelElement = (BaseService)containerView.getElement();
        return LocalDiagramExtensionUtils.getSemanticInterfaceChildrenList(modelElement.getInterface(), viewObject);
    }

    private static List getSemanticInterfaceChildrenList(Interface interfacee, View viewObject) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        for (ScaElementExtendedInformation interfaceInformation : LocalDiagramExtensionManager.INSTANCE.getInterfaceExtensions()) {
            int visualID = interfaceInformation.getVisualIDRegistry().getNodeVisualID(viewObject, (EObject)interfacee);
            if (visualID != interfaceInformation.getVisualId()) continue;
            list.add(new ScaNodeDescriptor((EObject)interfacee, visualID).getModelElement());
        }
        return list;
    }

    public static Boolean isOrphanedInterface(Collection semanticChildren, View view, EditPart editPart) {
        for (ScaElementExtendedInformation interfaceInformation : LocalDiagramExtensionManager.INSTANCE.getInterfaceExtensions()) {
            if (LocalDiagramExtensionUtils.getVisualID(view) != interfaceInformation.getVisualId()) continue;
            int id = interfaceInformation.getVisualIDRegistry().getNodeVisualID((View)editPart.getModel(), view.getElement());
            return new Boolean(!semanticChildren.contains(view.getElement()) || LocalDiagramExtensionUtils.getVisualID(view) != id);
        }
        return null;
    }

    public static ICommand getCreateReferenceInterfaceCommand(CreateElementRequest req) {
        for (ScaElementExtendedInformation interfaceInformation : LocalDiagramExtensionManager.INSTANCE.getInterfaceExtensions()) {
            if (interfaceInformation.getElementType() != req.getElementType()) continue;
            if (req.getContainmentFeature() == null) {
                req.setContainmentFeature(ScaPackage.eINSTANCE.getBaseReference_Interface());
            }
            return ScaElementInformationUtils.createReferenceInterfaceCommand(interfaceInformation, req);
        }
        return null;
    }

    public static ICommand getCreateServiceInterfaceCommand(CreateElementRequest req) {
        for (ScaElementExtendedInformation interfaceInformation : LocalDiagramExtensionManager.INSTANCE.getInterfaceExtensions()) {
            if (interfaceInformation.getElementType() != req.getElementType()) continue;
            if (req.getContainmentFeature() == null) {
                req.setContainmentFeature(ScaPackage.eINSTANCE.getBaseService_Interface());
            }
            return ScaElementInformationUtils.createServiceInterfaceCommand(interfaceInformation, req);
        }
        return null;
    }

    public static List getSemanticComponentImplementationChildrenList(View viewObject) {
        if (!(viewObject.eContainer() instanceof View)) {
            return Collections.EMPTY_LIST;
        }
        View containerView = (View)viewObject.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.EMPTY_LIST;
        }
        Component modelElement = (Component)containerView.getElement();
        return LocalDiagramExtensionUtils.getSemanticImplementationChildrenList(modelElement.getImplementation(), viewObject);
    }

    private static List getSemanticImplementationChildrenList(Implementation implementation, View viewObject) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        for (ScaElementExtendedInformation implementationInformation : LocalDiagramExtensionManager.INSTANCE.getImplementationExtensions()) {
            int visualID = implementationInformation.getVisualIDRegistry().getNodeVisualID(viewObject, (EObject)implementation);
            if (visualID != implementationInformation.getVisualId()) continue;
            list.add(new ScaNodeDescriptor((EObject)implementation, visualID).getModelElement());
        }
        return list;
    }

    public static Boolean isOrphanedImplementation(Collection semanticChildren, View view, EditPart editPart) {
        for (ScaElementExtendedInformation implementationInformation : LocalDiagramExtensionManager.INSTANCE.getImplementationExtensions()) {
            if (LocalDiagramExtensionUtils.getVisualID(view) != implementationInformation.getVisualId()) continue;
            int id = implementationInformation.getVisualIDRegistry().getNodeVisualID((View)editPart.getModel(), view.getElement());
            return new Boolean(!semanticChildren.contains(view.getElement()) || LocalDiagramExtensionUtils.getVisualID(view) != id);
        }
        return null;
    }

    public static ICommand getCreateComponentImplementationCommand(CreateElementRequest req) {
        for (ScaElementExtendedInformation implementationInformation : LocalDiagramExtensionManager.INSTANCE.getImplementationExtensions()) {
            if (implementationInformation.getElementType() != req.getElementType()) continue;
            if (req.getContainmentFeature() == null) {
                req.setContainmentFeature(ScaPackage.eINSTANCE.getComponent_Implementation());
            }
            return ScaElementInformationUtils.createImplementationCommand(implementationInformation, req);
        }
        return null;
    }
}

