/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_1.common.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.soa.sca.sca1_1.common.Messages;
import org.eclipse.soa.sca.sca1_1.common.Sca1_1CommonPlugin;
import org.eclipse.soa.sca.sca1_1.common.composite2java.CompositeToJavaModel;
import org.eclipse.soa.sca.sca1_1.common.composite2java.GenerationSelectionDialog;
import org.eclipse.soa.sca.sca1_1.common.composite2java.JComposite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class GenerateJavaSkeletonHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IFile f;
        Object o;
        ISelection s = null;
        try {
            s = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        }
        catch (Exception exception) {}
        if (s instanceof IStructuredSelection && (o = ((IStructuredSelection)s).getFirstElement()) instanceof IFile && (f = (IFile)o).getName().endsWith(".composite")) {
            this.processComposite(f, new Shell());
        }
        return null;
    }

    private void processComposite(final IFile compositeFile, Shell shell) {
        try {
            JComposite jComposite = CompositeToJavaModel.getJavaModelFromComposite(compositeFile);
            if (jComposite == null) {
                throw new Exception();
            }
            final GenerationSelectionDialog dlg = new GenerationSelectionDialog(shell, compositeFile, jComposite);
            if (dlg.open() != 0) {
                return;
            }
            final IPackageFragmentRoot fRoot = dlg.getPackageFragmentRoot();
            JavaCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    for (GenerationSelectionDialog.JavaFile jf : dlg.getSelectedFiles()) {
                        try {
                            IPackageFragment fragment = fRoot.getPackageFragment(jf.getPck().getName());
                            if (!fragment.exists()) {
                                fragment = fRoot.createPackageFragment(jf.getPck().getName(), true, monitor);
                            }
                            fragment.createCompilationUnit(String.valueOf(jf.getName()) + ".java", jf.getJInterface().getJavaCode(compositeFile), true, monitor);
                        }
                        catch (JavaModelException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Sca1_1CommonPlugin.log((Exception)((Object)e), 4);
            MessageDialog.openError((Shell)shell, (String)Messages.GenerateJavaSkeletonAction_1, (String)Messages.GenerateJavaSkeletonAction_2);
        }
        catch (Exception e) {
            Sca1_1CommonPlugin.log(e, 4);
            MessageDialog.openError((Shell)shell, (String)Messages.GenerateJavaSkeletonAction_3, (String)Messages.GenerateJavaSkeletonAction_4);
        }
    }
}

