/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TableDragSourceEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkDragContext;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DragSourceEffect dragEffect;
    int targetList;
    boolean moveData = false;
    static final String DEFAULT_DRAG_SOURCE_EFFECT = "DEFAULT_DRAG_SOURCE_EFFECT";
    static Callback DragGetData;
    static Callback DragEnd;
    static Callback DragDataDelete;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((DragGetData = new Callback(clazz3, "DragGetData", 5)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz2 = class$0) == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((DragEnd = new Callback(clazz2, "DragEnd", 2)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((DragDataDelete = new Callback(clazz, "DragDataDelete", 2)).getAddress() == 0) {
            SWT.error(3);
        }
    }

    public DragSource(Control control, int style) {
        super(control, DragSource.checkStyle(style));
        this.control = control;
        if (DragGetData == null || DragEnd == null || DragDataDelete == null) {
            DND.error(2000);
        }
        if (control.getData("DragSource") != null) {
            DND.error(2000);
        }
        control.setData("DragSource", this);
        OS.g_signal_connect(control.handle, OS.drag_data_get, DragGetData.getAddress(), 0);
        OS.g_signal_connect(control.handle, OS.drag_end, DragEnd.getAddress(), 0);
        OS.g_signal_connect(control.handle, OS.drag_data_delete, DragDataDelete.getAddress(), 0);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 12 && !DragSource.this.isDisposed()) {
                    DragSource.this.dispose();
                }
                if (event.type == 29 && !DragSource.this.isDisposed()) {
                    DragSource.this.drag(event);
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        Object effect = control.getData(DEFAULT_DRAG_SOURCE_EFFECT);
        if (effect instanceof DragSourceEffect) {
            this.dragEffect = (DragSourceEffect)effect;
        } else if (control instanceof Tree) {
            this.dragEffect = new TreeDragSourceEffect((Tree)control);
        } else if (control instanceof Table) {
            this.dragEffect = new TableDragSourceEffect((Table)control);
        }
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                DragSource.this.onDispose();
            }
        });
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    static int DragDataDelete(int widget, int context) {
        DragSource source = DragSource.FindDragSource(widget);
        if (source == null) {
            return 0;
        }
        source.dragDataDelete(widget, context);
        return 0;
    }

    static int DragEnd(int widget, int context) {
        DragSource source = DragSource.FindDragSource(widget);
        if (source == null) {
            return 0;
        }
        source.dragEnd(widget, context);
        return 0;
    }

    static int DragGetData(int widget, int context, int selection_data, int info, int time) {
        DragSource source = DragSource.FindDragSource(widget);
        if (source == null) {
            return 0;
        }
        source.dragGetData(widget, context, selection_data, info, time);
        return 0;
    }

    static DragSource FindDragSource(int handle) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(handle);
        if (widget == null) {
            return null;
        }
        return (DragSource)widget.getData("DragSource");
    }

    public void addDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        typedListener.dndWidget = this;
        this.addListener(2008, typedListener);
        this.addListener(2001, typedListener);
        this.addListener(2000, typedListener);
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }

    void drag(Event dragEvent) {
        this.moveData = false;
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.x = dragEvent.x;
        event.y = dragEvent.y;
        event.time = dragEvent.time;
        event.doit = true;
        this.notifyListeners(2008, event);
        if (!event.doit || this.transferAgents == null || this.transferAgents.length == 0) {
            return;
        }
        if (this.targetList == 0) {
            return;
        }
        int actions = this.opToOsOp(this.getStyle());
        Image image = event.image;
        int context = OS.gtk_drag_begin(this.control.handle, this.targetList, actions, 1, 0);
        if (context != 0 && image != null) {
            int pixbuf = ImageList.createPixbuf(image);
            OS.gtk_drag_set_icon_pixbuf(context, pixbuf, 0, 0);
            OS.g_object_unref(pixbuf);
        }
    }

    void dragEnd(int widget, int context) {
        OS.gdk_pointer_ungrab(0);
        OS.gdk_keyboard_ungrab(0);
        int operation = 0;
        if (context != 0) {
            GdkDragContext gdkDragContext = new GdkDragContext();
            OS.memmove(gdkDragContext, context, GdkDragContext.sizeof);
            if (gdkDragContext.dest_window != 0) {
                if (this.moveData) {
                    operation = 2;
                } else {
                    operation = this.osOpToOp(gdkDragContext.action);
                    if (operation == 2) {
                        operation = 0;
                    }
                }
            }
        }
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.doit = operation != 0;
        event.detail = operation;
        this.notifyListeners(2000, event);
        this.moveData = false;
    }

    void dragGetData(int widget, int context, int selection_data, int info, int time) {
        if (selection_data == 0) {
            return;
        }
        GtkSelectionData gtkSelectionData = new GtkSelectionData();
        OS.memmove(gtkSelectionData, selection_data, GtkSelectionData.sizeof);
        if (gtkSelectionData.target == 0) {
            return;
        }
        TransferData transferData = new TransferData();
        transferData.type = gtkSelectionData.target;
        transferData.pValue = gtkSelectionData.data;
        transferData.length = gtkSelectionData.length;
        transferData.format = gtkSelectionData.format;
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = time;
        event.dataType = transferData;
        this.notifyListeners(2001, event);
        if (!event.doit) {
            return;
        }
        Transfer transfer = null;
        int i = 0;
        while (i < this.transferAgents.length) {
            Transfer transferAgent = this.transferAgents[i];
            if (transferAgent != null && transferAgent.isSupportedType(transferData)) {
                transfer = transferAgent;
                break;
            }
            ++i;
        }
        if (transfer == null) {
            return;
        }
        transfer.javaToNative(event.data, transferData);
        if (transferData.result != 1) {
            return;
        }
        OS.gtk_selection_data_set(selection_data, transferData.type, transferData.format, transferData.pValue, transferData.length);
        OS.g_free(transferData.pValue);
    }

    void dragDataDelete(int widget, int context) {
        this.moveData = true;
    }

    public Control getControl() {
        return this.control;
    }

    public DragSourceListener[] getDragListeners() {
        Listener[] listeners = this.getListeners(2008);
        int length = listeners.length;
        DragSourceListener[] dragListeners = new DragSourceListener[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            Listener listener = listeners[i];
            if (listener instanceof DNDListener) {
                dragListeners[count] = (DragSourceListener)((DNDListener)listener).getEventListener();
                ++count;
            }
            ++i;
        }
        if (count == length) {
            return dragListeners;
        }
        DragSourceListener[] result = new DragSourceListener[count];
        System.arraycopy(dragListeners, 0, result, 0, count);
        return result;
    }

    public DragSourceEffect getDragSourceEffect() {
        return this.dragEffect;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.targetList != 0) {
            OS.gtk_target_list_unref(this.targetList);
        }
        this.targetList = 0;
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DragSource", null);
        this.control = null;
        this.transferAgents = null;
    }

    int opToOsOp(int operation) {
        int osOperation = 0;
        if ((operation & 1) == 1) {
            osOperation |= 2;
        }
        if ((operation & 2) == 2) {
            osOperation |= 4;
        }
        if ((operation & 4) == 4) {
            osOperation |= 8;
        }
        return osOperation;
    }

    int osOpToOp(int osOperation) {
        int operation = 0;
        if ((osOperation & 2) == 2) {
            operation |= 1;
        }
        if ((osOperation & 4) == 4) {
            operation |= 2;
        }
        if ((osOperation & 8) == 8) {
            operation |= 4;
        }
        return operation;
    }

    public void removeDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2008, listener);
        this.removeListener(2001, listener);
        this.removeListener(2000, listener);
    }

    public void setDragSourceEffect(DragSourceEffect effect) {
        this.dragEffect = effect;
    }

    public void setTransfer(Transfer[] transferAgents) {
        if (this.targetList != 0) {
            OS.gtk_target_list_unref(this.targetList);
            this.targetList = 0;
        }
        this.transferAgents = transferAgents;
        if (transferAgents == null || transferAgents.length == 0) {
            return;
        }
        GtkTargetEntry[] targets = new GtkTargetEntry[]{};
        int i = 0;
        while (i < transferAgents.length) {
            Transfer transfer = transferAgents[i];
            if (transfer != null) {
                int[] typeIds = transfer.getTypeIds();
                String[] typeNames = transfer.getTypeNames();
                int j = 0;
                while (j < typeIds.length) {
                    GtkTargetEntry entry = new GtkTargetEntry();
                    byte[] buffer = Converter.wcsToMbcs(null, typeNames[j], true);
                    entry.target = OS.g_malloc(buffer.length);
                    OS.memmove(entry.target, buffer, buffer.length);
                    entry.info = typeIds[j];
                    GtkTargetEntry[] newTargets = new GtkTargetEntry[targets.length + 1];
                    System.arraycopy(targets, 0, newTargets, 0, targets.length);
                    newTargets[targets.length] = entry;
                    targets = newTargets;
                    ++j;
                }
            }
            ++i;
        }
        int pTargets = OS.g_malloc(targets.length * GtkTargetEntry.sizeof);
        int i2 = 0;
        while (i2 < targets.length) {
            OS.memmove(pTargets + i2 * GtkTargetEntry.sizeof, targets[i2], GtkTargetEntry.sizeof);
            ++i2;
        }
        this.targetList = OS.gtk_target_list_new(pTargets, targets.length);
        i2 = 0;
        while (i2 < targets.length) {
            OS.g_free(targets[i2].target);
            ++i2;
        }
    }
}

