/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.services;

import java.util.Collection;
import java.util.Map;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;

public interface IRegisters
extends IService {
    public static final String NAME = "Registers";
    public static final String PROP_ID = "ID";
    public static final String PROP_PARENT_ID = "ParentID";
    public static final String PROP_PROCESS_ID = "ProcessID";
    public static final String PROP_NAME = "Name";
    public static final String PROP_DESCRIPTION = "Description";
    public static final String PROP_SIZE = "Size";
    public static final String PROP_READBLE = "Readable";
    public static final String PROP_READ_ONCE = "ReadOnce";
    public static final String PROP_WRITEABLE = "Writeable";
    public static final String PROP_WRITE_ONCE = "WriteOnce";
    public static final String PROP_SIDE_EFFECTS = "SideEffects";
    public static final String PROP_VOLATILE = "Volatile";
    public static final String PROP_FLOAT = "Float";
    public static final String PROP_BIG_ENDIAN = "BigEndian";
    public static final String PROP_LEFT_TO_RIGHT = "LeftToRight";
    public static final String PROP_FIST_BIT = "FirstBit";
    public static final String PROP_BITS = "Bits";
    public static final String PROP_VALUES = "Values";
    public static final String PROP_MEMORY_ADDRESS = "MemoryAddress";
    public static final String PROP_MEMORY_CONTEXT = "MemoryContext";
    public static final String PROP_CAN_SEARCH = "CanSearch";
    public static final String PROP_ROLE = "Role";
    public static final String ROLE_PC = "PC";
    public static final String ROLE_SP = "SP";
    public static final String ROLE_FP = "FP";
    public static final String ROLE_RET = "RET";
    public static final String ROLE_CORE = "CORE";
    public static final String SEARCH_NAME = "Name";
    public static final String SEARCH_EQUAL_VALUE = "EqualValue";

    public IToken getContext(String var1, DoneGetContext var2);

    public IToken getChildren(String var1, DoneGetChildren var2);

    public IToken getm(Location[] var1, DoneGet var2);

    public IToken setm(Location[] var1, byte[] var2, DoneSet var3);

    public void addListener(RegistersListener var1);

    public void removeListener(RegistersListener var1);

    public static interface DoneGet {
        public void doneGet(IToken var1, Exception var2, byte[] var3);
    }

    public static interface DoneGetChildren {
        public void doneGetChildren(IToken var1, Exception var2, String[] var3);
    }

    public static interface DoneGetContext {
        public void doneGetContext(IToken var1, Exception var2, RegistersContext var3);
    }

    public static interface DoneSearch {
        public void doneSearch(IToken var1, Exception var2, String[][] var3);
    }

    public static interface DoneSet {
        public void doneSet(IToken var1, Exception var2);
    }

    public static final class Location {
        public final String id;
        public final int offs;
        public final int size;

        public Location(String id, int offs, int size) {
            this.id = id;
            this.offs = offs;
            this.size = size;
        }
    }

    public static interface NamedValue {
        public byte[] getValue();

        public String getName();

        public String getDescription();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RegistersContext {
        public String getID();

        public String getParentID();

        public String getProcessID();

        public String getName();

        public String getDescription();

        public int getSize();

        public boolean isReadable();

        public boolean isReadOnce();

        public boolean isWriteable();

        public boolean isWriteOnce();

        public boolean hasSideEffects();

        public boolean isVolatile();

        public boolean isFloat();

        public boolean isBigEndian();

        public boolean isLeftToRight();

        public int getFirstBitNumber();

        public int[] getBitNumbers();

        public NamedValue[] getNamedValues();

        public Number getMemoryAddress();

        public String getMemoryContext();

        public Collection<String> canSearch();

        public String getRole();

        public Map<String, Object> getProperties();

        public IToken get(DoneGet var1);

        public IToken set(byte[] var1, DoneSet var2);

        public IToken search(Map<String, Object> var1, DoneSearch var2);
    }

    public static interface RegistersListener {
        public void contextChanged();

        public void registerChanged(String var1);
    }
}

