/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.tcf.internal.debug.launch.TCFLocalAgent;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.model.TCFMemoryRegion;
import org.eclipse.tcf.osgi.OSGIServices;
import org.eclipse.tcf.osgi.services.IValueAddService;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IMemoryMap;
import org.eclipse.tcf.util.TCFPathMapRule;
import org.eclipse.tcf.util.TCFTask;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFLaunchDelegate
extends LaunchConfigurationDelegate {
    public static final String ATTR_PEER_ID = "org.eclipse.tcf.debug.PeerID";
    public static final String ATTR_PROJECT_NAME = "org.eclipse.tcf.debug.ProjectName";
    public static final String ATTR_LOCAL_PROGRAM_FILE = "org.eclipse.tcf.debug.LocalProgramFile";
    public static final String ATTR_REMOTE_PROGRAM_FILE = "org.eclipse.tcf.debug.ProgramFile";
    public static final String ATTR_COPY_TO_REMOTE_FILE = "org.eclipse.tcf.debug.CopyToRemote";
    public static final String ATTR_PROGRAM_ARGUMENTS = "org.eclipse.tcf.debug.ProgramArguments";
    public static final String ATTR_WORKING_DIRECTORY = "org.eclipse.tcf.debug.WorkingDirectory";
    public static final String ATTR_ATTACH_CHILDREN = "org.eclipse.tcf.debug.AttachChildren";
    public static final String ATTR_STOP_AT_ENTRY = "org.eclipse.tcf.debug.StopAtEntry";
    public static final String ATTR_STOP_AT_MAIN = "org.eclipse.tcf.debug.StopAtMain";
    public static final String ATTR_DISCONNECT_ON_CTX_EXIT = "org.eclipse.tcf.debug.DisconnectOnCtxExit";
    public static final String ATTR_USE_TERMINAL = "org.eclipse.tcf.debug.UseTerminal";
    public static final String ATTR_RUN_LOCAL_AGENT = "org.eclipse.tcf.debug.RunLocalAgent";
    public static final String ATTR_USE_LOCAL_AGENT = "org.eclipse.tcf.debug.UseLocalAgent";
    public static final String ATTR_SIGNALS_DONT_STOP = "org.eclipse.tcf.debug.SignalsDontStop";
    public static final String ATTR_SIGNALS_DONT_PASS = "org.eclipse.tcf.debug.SignalsDontPath";
    public static final String ATTR_PATH_MAP = "org.eclipse.tcf.debug.PathMap";
    public static final String ATTR_MEMORY_MAP = "org.eclipse.tcf.debug.MemoryMap";

    public static ArrayList<PathMapRule> parsePathMapAttribute(String s) {
        ArrayList<PathMapRule> map = new ArrayList<PathMapRule>();
        StringBuffer bf = new StringBuffer();
        int i = 0;
        block0: while (i < s.length()) {
            PathMapRule e = new PathMapRule(new HashMap<String, Object>());
            block1: while (i < s.length()) {
                char ch;
                if ((ch = s.charAt(i++)) == '|') {
                    map.add(e);
                    continue block0;
                }
                bf.setLength(0);
                bf.append(ch);
                while (i < s.length()) {
                    if ((ch = s.charAt(i++)) == '=') break;
                    bf.append(ch);
                }
                String nm = bf.toString();
                bf.setLength(0);
                while (i < s.length()) {
                    if ((ch = s.charAt(i++)) == '|') {
                        if (bf.length() <= 0) continue block1;
                        e.getProperties().put(nm, bf.toString());
                        continue block1;
                    }
                    if (ch == '\\') {
                        int n = 0;
                        while (i < s.length()) {
                            char d;
                            if ((d = s.charAt(i++)) == ';') break;
                            n = n * 10 + (d - 48);
                        }
                        bf.append((char)n);
                        continue;
                    }
                    bf.append(ch);
                }
            }
        }
        return map;
    }

    public static ArrayList<PathMapRule> parseSourceLocatorMemento(String s) throws CoreException {
        ArrayList<PathMapRule> map = new ArrayList<PathMapRule>();
        if (s == null || s.length() == 0) {
            return map;
        }
        Element root = DebugPlugin.parseDocument((String)s);
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element entry;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase("sourceContainers")) {
                TCFLaunchDelegate.parseSourceContainers(map, entry);
            }
            ++i;
        }
        return map;
    }

    private static void parseSourceContainers(ArrayList<PathMapRule> map, Element element) throws CoreException {
        NodeList list = element.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element entry;
            String memento;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (memento = (entry = (Element)node).getAttribute("memento")) != null && memento.length() > 0) {
                TCFLaunchDelegate.readSourceContainer(map, memento);
            }
            ++i;
        }
    }

    private static void readSourceContainer(ArrayList<PathMapRule> map, String s) throws CoreException {
        Element root = DebugPlugin.parseDocument((String)s);
        if ("mapping".equals(root.getNodeName())) {
            NodeList list = root.getChildNodes();
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                String memento;
                Element entry;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase("mapEntry") && (memento = entry.getAttribute("memento")) != null && memento.length() > 0) {
                    Element map_entry = DebugPlugin.parseDocument((String)memento);
                    String src = map_entry.getAttribute("backendPath");
                    String dst = map_entry.getAttribute("localPath");
                    if (src != null) {
                        src = src.replace('\\', '/');
                    }
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put("Source", src);
                    props.put("Destination", dst);
                    map.add(new PathMapRule(props));
                }
                ++i;
            }
        }
    }

    public static void parseMemMapsAttribute(Map<String, ArrayList<IMemoryMap.MemoryRegion>> maps, String s) throws Exception {
        if (s == null || s.length() == 0) {
            return;
        }
        Collection list = (Collection)JSON.parseOne((byte[])s.getBytes("UTF-8"));
        if (list == null) {
            return;
        }
        for (Map map : list) {
            String id = (String)map.get("ID");
            if (id == null) continue;
            ArrayList<Object> l = maps.get(id);
            if (l == null) {
                l = new ArrayList();
                maps.put(id, l);
            }
            l.add((IMemoryMap.MemoryRegion)new TCFMemoryRegion(map));
        }
    }

    public static void getMemMapsAttribute(Map<String, ArrayList<IMemoryMap.MemoryRegion>> maps, ILaunchConfiguration cfg) throws Exception {
        String maps_cfg = cfg.getAttribute(ATTR_MEMORY_MAP, null);
        TCFLaunchDelegate.parseMemMapsAttribute(maps, maps_cfg);
    }

    public static String getProgramPath(String project_name, String program_name) {
        if (program_name == null || program_name.length() == 0) {
            return null;
        }
        if (project_name == null || project_name.length() == 0) {
            File file = new File(program_name);
            if (!file.isAbsolute()) {
                File ws = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
                file = new File(ws, program_name);
            }
            return file.getAbsolutePath();
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(project_name);
        Path program_path = new Path(program_name);
        if (!program_path.isAbsolute()) {
            if (project == null || !project.getFile(program_name).exists()) {
                return null;
            }
            program_path = project.getFile(program_name).getLocation();
        }
        return program_path.toOSString();
    }

    public ILaunch getLaunch(final ILaunchConfiguration configuration, final String mode) throws CoreException {
        return (ILaunch)new TCFTask<ILaunch>(){
            int cnt;

            public void run() {
                if (this.cnt++ < 2) {
                    Protocol.invokeLater((Runnable)((Object)this));
                } else {
                    this.done((Object)new TCFLaunch(configuration, mode));
                }
            }
        }.getE();
    }

    public void launch(ILaunchConfiguration configuration, final String mode, final ILaunch launch, final IProgressMonitor monitor) throws CoreException {
        String local_id = null;
        int task_cnt = 1;
        if (configuration.getAttribute(ATTR_RUN_LOCAL_AGENT, false)) {
            ++task_cnt;
            if (monitor != null) {
                monitor.beginTask("Starting TCF Agent", task_cnt);
            }
            local_id = TCFLocalAgent.runLocalAgent();
        } else if (configuration.getAttribute(ATTR_USE_LOCAL_AGENT, true)) {
            ++task_cnt;
            if (monitor != null) {
                monitor.beginTask("Searching TCF Agent", task_cnt);
            }
            if ((local_id = TCFLocalAgent.getLocalAgentID()) == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.tcf.debug", 0, "Cannot find TCF agent on the local host", null));
            }
        }
        if (monitor != null) {
            monitor.beginTask("Launching TCF debugger session", task_cnt);
        }
        final String id = configuration.getAttribute(ATTR_USE_LOCAL_AGENT, true) ? local_id : configuration.getAttribute(ATTR_PEER_ID, "");
        final IValueAddService value_add_service = OSGIServices.getValueAddService();
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                IPeer peer;
                if (value_add_service != null && id.indexOf(47) < 0 && (peer = (IPeer)Protocol.getLocator().getPeers().get(id)) != null) {
                    value_add_service.getRedirectionPath(peer, new IValueAddService.DoneGetRedirectionPath(){

                        public void doneGetRedirectionPath(Throwable error, String redirection_path) {
                            if (error != null || redirection_path == null) {
                                redirection_path = id;
                            }
                            ((TCFLaunch)launch).launchTCF(mode, redirection_path);
                            if (monitor != null) {
                                monitor.done();
                            }
                        }
                    });
                    return;
                }
                ((TCFLaunch)launch).launchTCF(mode, id);
                if (monitor != null) {
                    monitor.done();
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PathMapRule
    extends TCFPathMapRule {
        public PathMapRule(Map<String, Object> props) {
            super(props);
        }

        public String toString() {
            StringBuffer bf = new StringBuffer();
            Map props = this.getProperties();
            for (String nm : props.keySet()) {
                Object o = props.get(nm);
                if (o == null) continue;
                bf.append(nm);
                bf.append('=');
                String s = o.toString();
                int i = 0;
                while (i < s.length()) {
                    char ch = s.charAt(i);
                    if (ch >= ' ' && ch != '|' && ch != '\\') {
                        bf.append(ch);
                    } else {
                        bf.append('\\');
                        bf.append((int)ch);
                        bf.append(';');
                    }
                    ++i;
                }
                bf.append('|');
            }
            bf.append('|');
            return bf.toString();
        }
    }
}

