/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.stepper.extensions;

import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.interfaces.IConditionTester;
import org.eclipse.tcf.te.runtime.interfaces.ISharedConstants;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IExtendedStep;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStep;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepExecutor;
import org.eclipse.tcf.te.runtime.stepper.nls.Messages;
import org.eclipse.tcf.te.runtime.utils.ProgressHelper;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;

public class StepExecutor
implements IStepExecutor {
    @Override
    public final void execute(IStep step, IFullQualifiedId id, IStepContext context, IPropertiesContainer data, IProgressMonitor progress) throws CoreException {
        Assert.isNotNull((Object)step);
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)progress);
        long startTime = System.currentTimeMillis();
        CoreBundleActivator.getTraceHandler().trace("StepExecutor#execute: *** START (" + step.getLabel() + ")", 0, "trace/stepping", 2, (Object)this);
        CoreBundleActivator.getTraceHandler().trace(" [" + ISharedConstants.TIME_FORMAT.format(new Date(startTime)) + "]" + " ***", 0, "profile/stepping", 2, (Object)this);
        int ticksToUse = step instanceof IExtendedStep ? ((IExtendedStep)step).getTotalWork(context, data) : -1;
        progress = ProgressHelper.getProgressMonitor((IProgressMonitor)progress, (int)ticksToUse);
        ProgressHelper.beginTask((IProgressMonitor)progress, (String)step.getLabel(), (int)ticksToUse);
        Callback callback = new Callback();
        try {
            try {
                if (step instanceof IExtendedStep) {
                    IExtendedStep extendedStep = (IExtendedStep)step;
                    extendedStep.initializeFrom(context, data, id, progress);
                    extendedStep.validateExecute(context, data, id, progress);
                }
                step.execute(context, data, id, progress, (ICallback)callback);
                ExecutorsUtil.waitAndExecute((long)0L, (IConditionTester)callback.getDoneConditionTester(null));
                this.normalizeStatus(step, id, context, data, callback.getStatus());
            }
            catch (Exception e) {
                CoreBundleActivator.getTraceHandler().trace("StepExecutor#execute: Exception catched: class ='" + e.getClass().getName() + "'" + ", message = '" + e.getLocalizedMessage() + "'" + ", cause = " + (e instanceof CoreException ? ((CoreException)e).getStatus().getException() : e.getCause()), 0, "trace/stepping", 2, (Object)this);
                if (e instanceof CoreException) {
                    if (this.isExceptionMessageFormatted(e.getLocalizedMessage())) {
                        throw (CoreException)e;
                    }
                    this.normalizeStatus(step, id, context, data, ((CoreException)e).getStatus());
                } else {
                    this.normalizeStatus(step, id, context, data, StatusHelper.getStatus((Throwable)e));
                }
                if (!progress.isCanceled()) {
                    progress.done();
                }
                if (step instanceof IExtendedStep) {
                    ((IExtendedStep)step).cleanup(context, data, id, progress);
                }
                long endTime = System.currentTimeMillis();
                CoreBundleActivator.getTraceHandler().trace("StepExecutor#execute: *** DONE (" + step.getLabel() + ")", 0, "trace/stepping", 2, (Object)this);
                CoreBundleActivator.getTraceHandler().trace(" [" + ISharedConstants.TIME_FORMAT.format(new Date(endTime)) + " , delay = " + (endTime - startTime) + " ms]" + " ***", 0, "profile/stepping", 2, (Object)this);
            }
        }
        finally {
            if (!progress.isCanceled()) {
                progress.done();
            }
            if (step instanceof IExtendedStep) {
                ((IExtendedStep)step).cleanup(context, data, id, progress);
            }
            long endTime = System.currentTimeMillis();
            CoreBundleActivator.getTraceHandler().trace("StepExecutor#execute: *** DONE (" + step.getLabel() + ")", 0, "trace/stepping", 2, (Object)this);
            CoreBundleActivator.getTraceHandler().trace(" [" + ISharedConstants.TIME_FORMAT.format(new Date(endTime)) + " , delay = " + (endTime - startTime) + " ms]" + " ***", 0, "profile/stepping", 2, (Object)this);
        }
    }

    private void normalizeStatus(IStep step, IFullQualifiedId id, IStepContext context, IPropertiesContainer data, IStatus status) throws CoreException {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)step);
        if (status == null || status.isOK()) {
            return;
        }
        switch (status.getSeverity()) {
            case 8: {
                throw new OperationCanceledException(status.getMessage());
            }
        }
        String message = this.formatMessage(status.getMessage(), status.getSeverity(), step, id, context, data);
        status = new Status(status.getSeverity(), status.getPlugin(), status.getCode(), message != null ? message : status.getMessage(), status.getException());
        throw new CoreException(status);
    }

    protected boolean isExceptionMessageFormatted(String message) {
        Assert.isNotNull((Object)message);
        return message.startsWith(Messages.StepExecutor_checkPoint_normalizationNeeded);
    }

    protected String formatMessage(String message, int severity, IStep step, IFullQualifiedId id, IStepContext context, IPropertiesContainer data) {
        String template = null;
        switch (severity) {
            case 1: {
                template = Messages.StepExecutor_info_stepFailed;
                break;
            }
            case 2: {
                template = Messages.StepExecutor_warning_stepFailed;
                break;
            }
            case 4: {
                template = Messages.StepExecutor_error_stepFailed;
            }
        }
        if (template == null) {
            return message;
        }
        String[] splittedMsg = (message = this.checkMessage(message)) != null ? message.split("[\t\n\r\f]+", 2) : new String[2];
        String formattedMessage = NLS.bind((String)template, (Object[])new String[]{splittedMsg[0], context.getName(), context.getInfo(data), step.getLabel() != null && step.getLabel().trim().length() > 0 ? step.getLabel() : step.getId()});
        if (splittedMsg.length > 1 && splittedMsg[1] != null && !"".equals(splittedMsg[1])) {
            formattedMessage = String.valueOf(formattedMessage) + "\n\n" + splittedMsg[1];
        }
        if (Platform.inDebugMode()) {
            formattedMessage = String.valueOf(formattedMessage) + "\n\n" + NLS.bind((String)Messages.StepExecutor_stepFailed_debugInfo, (Object)id.toString());
        }
        return formattedMessage;
    }

    protected String checkMessage(String message) {
        return message;
    }
}

