/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.core.internal.ChannelManager;
import org.eclipse.tcf.te.tcf.core.internal.Startup;
import org.eclipse.tcf.te.tcf.core.listeners.ChannelOpenListener;
import org.eclipse.tcf.te.tcf.core.listeners.interfaces.IChannelOpenListener;
import org.eclipse.tcf.te.tcf.core.listeners.interfaces.IChannelStateChangeListener;
import org.eclipse.tcf.te.tcf.core.listeners.interfaces.IProtocolStateChangeListener;

public final class Tcf {
    IChannelManager channelManager;
    Protocol.ChannelOpenListener channelOpenListener;
    final List<IProtocolStateChangeListener> protocolStateChangeListeners = new ArrayList<IProtocolStateChangeListener>();
    final List<IChannelStateChangeListener> channelStateChangeListeners = new ArrayList<IChannelStateChangeListener>();

    Tcf() {
    }

    static Tcf getInstance() {
        return LazyInstance.instance;
    }

    private static final void runSafe(Runnable runnable) {
        Assert.isNotNull((Object)runnable);
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
    }

    public static final void addProtocolStateChangeListener(IProtocolStateChangeListener listener) {
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        Assert.isNotNull((Object)listener);
        Tcf tcf = Tcf.getInstance();
        Assert.isNotNull((Object)tcf);
        if (!tcf.protocolStateChangeListeners.contains(listener)) {
            tcf.protocolStateChangeListeners.add(listener);
        }
    }

    public static final void removeProtocolStateChangeListener(IProtocolStateChangeListener listener) {
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        Assert.isNotNull((Object)listener);
        Tcf tcf = Tcf.getInstance();
        Assert.isNotNull((Object)tcf);
        tcf.protocolStateChangeListeners.remove(listener);
    }

    public static final void addChannelStateChangeListener(IChannelStateChangeListener listener) {
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        Assert.isNotNull((Object)listener);
        Tcf tcf = Tcf.getInstance();
        Assert.isNotNull((Object)tcf);
        if (!tcf.channelStateChangeListeners.contains(listener)) {
            tcf.channelStateChangeListeners.add(listener);
        }
    }

    public static final void removeChannelStateChangeListener(IChannelStateChangeListener listener) {
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        Assert.isNotNull((Object)listener);
        Tcf tcf = Tcf.getInstance();
        Assert.isNotNull((Object)tcf);
        tcf.channelStateChangeListeners.remove(listener);
    }

    public static final void fireChannelStateChangeListeners(IChannel channel, int state) {
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        Assert.isNotNull((Object)channel);
        Tcf tcf = Tcf.getInstance();
        Assert.isNotNull((Object)tcf);
        IChannelStateChangeListener[] listeners = tcf.channelStateChangeListeners.toArray(new IChannelStateChangeListener[tcf.channelStateChangeListeners.size()]);
        if (listeners.length > 0) {
            IChannelStateChangeListener[] iChannelStateChangeListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IChannelStateChangeListener listener = iChannelStateChangeListenerArray[n2];
                listener.stateChanged(channel, state);
                ++n2;
            }
        }
    }

    public static final boolean isRunning() {
        return Startup.isStarted();
    }

    public static void start() {
        IProtocolStateChangeListener[] listeners;
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        Tcf tcf = Tcf.getInstance();
        Assert.isNotNull((Object)tcf);
        if (tcf.channelOpenListener == null) {
            tcf.channelOpenListener = new ChannelOpenListener();
            Protocol.addChannelOpenListener((Protocol.ChannelOpenListener)tcf.channelOpenListener);
        }
        if ((listeners = tcf.protocolStateChangeListeners.toArray(new IProtocolStateChangeListener[tcf.protocolStateChangeListeners.size()])).length > 0) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IProtocolStateChangeListener[] iProtocolStateChangeListenerArray = listeners;
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProtocolStateChangeListener listener = iProtocolStateChangeListenerArray[n2];
                        listener.stateChanged(true);
                        ++n2;
                    }
                }
            });
        }
    }

    public static void stop() {
        IProtocolStateChangeListener[] listeners;
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        Tcf tcf = Tcf.getInstance();
        Assert.isNotNull((Object)tcf);
        if (tcf.channelOpenListener != null) {
            Protocol.removeChannelOpenListener((Protocol.ChannelOpenListener)tcf.channelOpenListener);
            tcf.channelOpenListener = null;
        }
        if ((listeners = tcf.protocolStateChangeListeners.toArray(new IProtocolStateChangeListener[tcf.protocolStateChangeListeners.size()])).length > 0) {
            try {
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IProtocolStateChangeListener[] iProtocolStateChangeListenerArray = listeners;
                        int n = listeners.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProtocolStateChangeListener listener = iProtocolStateChangeListenerArray[n2];
                            listener.stateChanged(false);
                            ++n2;
                        }
                    }
                });
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    public static IChannelManager getChannelManager() {
        Tcf tcf = Tcf.getInstance();
        Assert.isNotNull((Object)tcf);
        Tcf.runSafe(new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread());
                if (Tcf.this.channelManager == null) {
                    Tcf.this.channelManager = new ChannelManager();
                }
            }
        });
        return tcf.channelManager;
    }

    public static Object getAdapter(Class<?> adapter) {
        Assert.isNotNull(adapter);
        Tcf tcf = Tcf.getInstance();
        Assert.isNotNull((Object)tcf);
        if (IChannelManager.class.equals(adapter)) {
            return tcf.channelManager;
        }
        if (IChannelOpenListener.class.equals(adapter)) {
            return tcf.channelOpenListener;
        }
        return Platform.getAdapterManager().getAdapter((Object)tcf, adapter);
    }

    private static class LazyInstance {
        public static Tcf instance = new Tcf();

        private LazyInstance() {
        }
    }
}

