/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.model;

import java.beans.PropertyChangeEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.UserAccount;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.callbacks.QueryDoneOpenChannel;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.callbacks.RefreshStateDoneOpenChannel;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.NullOpExecutor;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpTargetFileDigest;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpUser;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.testers.TargetPropertyTester;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.FileState;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.PersistenceManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.AbstractTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.model.CacheState;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;

public final class FSTreeNode
extends AbstractTreeNode
implements Cloneable {
    private static final String KEY_WIN32_ATTRS = "Win32Attrs";
    public IFileSystem.FileAttrs attr = null;

    public FSTreeNode(FSTreeNode parentNode, IFileSystem.DirEntry entry, boolean entryIsRootNode) {
        IFileSystem.FileAttrs attrs;
        Assert.isNotNull((Object)entry);
        this.attr = attrs = entry.attrs;
        this.name = entry.filename;
        if (attrs == null || attrs.isDirectory()) {
            this.type = entryIsRootNode ? "FSRootDirNode" : "FSDirNode";
        } else if (attrs.isFile()) {
            this.type = "FSFileNode";
        }
        this.parent = parentNode;
        this.peerNode = parentNode.peerNode;
        Assert.isTrue((boolean)Protocol.isDispatchThread());
    }

    public FSTreeNode() {
        Assert.isTrue((boolean)Protocol.isDispatchThread());
    }

    public Object clone() {
        if (Protocol.isDispatchThread()) {
            FSTreeNode clone = new FSTreeNode();
            clone.childrenQueried = this.childrenQueried;
            clone.childrenQueryRunning = this.childrenQueryRunning;
            clone.name = this.name;
            clone.parent = this.parent;
            clone.peerNode = this.peerNode;
            clone.type = this.type;
            if (this.attr != null) {
                HashMap attributes = new HashMap(this.attr.attributes);
                clone.attr = new IFileSystem.FileAttrs(this.attr.flags, this.attr.size, this.attr.uid, this.attr.gid, this.attr.permissions, this.attr.atime, this.attr.mtime, attributes);
            } else {
                clone.attr = null;
            }
            return clone;
        }
        final Object[] objects = new Object[1];
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                objects[0] = FSTreeNode.this.clone();
            }
        });
        return objects[0];
    }

    public void setWritable(boolean b) {
        UserAccount account = this.getUserAccount(this.peerNode);
        if (account != null && this.attr != null) {
            int bit = this.attr.uid == account.getEUID() ? 128 : (this.attr.gid == account.getEGID() ? 16 : 2);
            int permissions = this.attr.permissions;
            this.setPermissions(b ? permissions | bit : permissions & ~bit);
        }
    }

    private UserAccount getUserAccount(IPeerModel peerNode) {
        OpUser user = new OpUser(peerNode);
        new NullOpExecutor().execute(user);
        return user.getUserAccount();
    }

    public void setPermissions(int permissions) {
        this.attr = new IFileSystem.FileAttrs(this.attr.flags, this.attr.size, this.attr.uid, this.attr.gid, permissions, this.attr.atime, this.attr.mtime, this.attr.attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FSTreeNode> getChildren() {
        ArrayList<FSTreeNode> result = new ArrayList<FSTreeNode>();
        List list = this.children;
        synchronized (list) {
            for (AbstractTreeNode child : this.children) {
                result.add((FSTreeNode)child);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWindowsNode() {
        String OSName;
        if (this.attr != null && this.attr.attributes != null) {
            return this.attr.attributes.containsKey(KEY_WIN32_ATTRS);
        }
        if (this.peerNode != null && (OSName = TargetPropertyTester.getOSName(this.peerNode)) != null) {
            return OSName.startsWith("Windows");
        }
        List list = this.children;
        synchronized (list) {
            if (!this.children.isEmpty()) {
                for (AbstractTreeNode treeNode : this.children) {
                    FSTreeNode node = (FSTreeNode)treeNode;
                    if (!node.hasOSInfo()) continue;
                    return node.isWindowsNode();
                }
            }
        }
        if (this.parent != null) {
            return ((FSTreeNode)this.parent).isWindowsNode();
        }
        return false;
    }

    private boolean hasOSInfo() {
        return this.attr != null && this.attr.attributes != null || this.peerNode != null && TargetPropertyTester.getOSName(this.peerNode) != null;
    }

    public boolean isFile() {
        return this.attr != null && this.attr.isFile();
    }

    public boolean isDirectory() {
        return this.attr != null && this.attr.isDirectory();
    }

    public boolean isWin32AttrOn(int bit) {
        if (this.attr != null && this.attr.attributes.get(KEY_WIN32_ATTRS) instanceof Integer) {
            Integer win32Attrs = (Integer)this.attr.attributes.get(KEY_WIN32_ATTRS);
            return (win32Attrs & bit) != 0;
        }
        return false;
    }

    public void setWin32Attr(int bit, boolean on) {
        if (this.attr != null && this.attr.attributes.get(KEY_WIN32_ATTRS) instanceof Integer) {
            int win32attr = (Integer)this.attr.attributes.get(KEY_WIN32_ATTRS);
            win32attr = on ? win32attr | bit : win32attr & ~bit;
            this.attr.attributes.put(KEY_WIN32_ATTRS, win32attr);
        }
    }

    public int getWin32Attrs() {
        if (this.attr != null && this.attr.attributes.get(KEY_WIN32_ATTRS) instanceof Integer) {
            return (Integer)this.attr.attributes.get(KEY_WIN32_ATTRS);
        }
        return 0;
    }

    public boolean isHidden() {
        return this.isWin32AttrOn(2);
    }

    public void setHidden(boolean hidden) {
        this.setWin32Attr(2, hidden);
    }

    public boolean isReadOnly() {
        return this.isWin32AttrOn(1);
    }

    public void setReadOnly(boolean readOnly) {
        this.setWin32Attr(1, readOnly);
    }

    public String getLocation() {
        return this.getLocation(false);
    }

    public String getLocation(boolean cross) {
        if (this.isRoot()) {
            if (cross && this.isWindowsNode()) {
                return String.valueOf(this.name.substring(0, this.name.length() - 1)) + "/";
            }
            return this.name;
        }
        String pLoc = this.getParent().getLocation(cross);
        if (this.getParent().isRoot()) {
            return String.valueOf(pLoc) + this.name;
        }
        String pathSep = !cross && this.isWindowsNode() ? "\\" : "/";
        return String.valueOf(pLoc) + pathSep + this.name;
    }

    public URL getLocationURL() {
        try {
            String id = this.peerNode.getPeerId();
            String path = this.getLocation(true);
            String location = "tcf:/" + id + (path.startsWith("/") ? path : "/" + path);
            return new URL(location);
        }
        catch (MalformedURLException malformedURLException) {
            assert (false);
            return null;
        }
    }

    public URI getLocationURI() {
        try {
            String id = this.peerNode.getPeerId();
            String path = this.getEncodedURIPath();
            String location = "tcf:/" + id + (path.startsWith("/") ? path : "/" + path);
            return new URI(location);
        }
        catch (URISyntaxException uRISyntaxException) {
            assert (false);
            return null;
        }
    }

    private String getEncodedURIPath() {
        if (this.isRoot()) {
            if (this.isWindowsNode()) {
                return String.valueOf(this.name.substring(0, this.name.length() - 1)) + "/";
            }
            return this.name;
        }
        final AtomicReference ref = new AtomicReference();
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
            }

            public void run() throws Exception {
                ref.set(URLEncoder.encode(FSTreeNode.this.name, "UTF-8"));
            }
        });
        String segment = (String)ref.get();
        String pLoc = this.getParent().getEncodedURIPath();
        if (this.getParent().isRoot()) {
            return String.valueOf(pLoc) + segment;
        }
        return String.valueOf(pLoc) + "/" + segment;
    }

    public boolean isRoot() {
        return this.type != null && this.type.equals("FSRootDirNode");
    }

    @Override
    public boolean isSystemRoot() {
        return this.type != null && this.type.equals("FSRootNode");
    }

    public boolean isReadable() {
        UserAccount account = this.getUserAccount(this.peerNode);
        if (account != null && this.attr != null) {
            if (this.attr.uid == account.getEUID()) {
                return (this.attr.permissions & 0x100) != 0;
            }
            if (this.attr.gid == account.getEGID()) {
                return (this.attr.permissions & 0x20) != 0;
            }
            return (this.attr.permissions & 4) != 0;
        }
        return false;
    }

    public boolean isAgentOwner() {
        UserAccount account = this.getUserAccount(this.peerNode);
        if (account != null && this.attr != null) {
            return this.attr.uid == account.getEUID();
        }
        return false;
    }

    public boolean isWritable() {
        UserAccount account = this.getUserAccount(this.peerNode);
        if (account != null && this.attr != null) {
            if (this.attr.uid == account.getEUID()) {
                return (this.attr.permissions & 0x80) != 0;
            }
            if (this.attr.gid == account.getEGID()) {
                return (this.attr.permissions & 0x10) != 0;
            }
            return (this.attr.permissions & 2) != 0;
        }
        return false;
    }

    public boolean isExecutable() {
        UserAccount account = this.getUserAccount(this.peerNode);
        if (account != null && this.attr != null) {
            if (this.attr.uid == account.getEUID()) {
                return (this.attr.permissions & 0x40) != 0;
            }
            if (this.attr.gid == account.getEGID()) {
                return (this.attr.permissions & 8) != 0;
            }
            return (this.attr.permissions & 1) != 0;
        }
        return false;
    }

    public boolean isSystem() {
        return !this.isRoot() && this.isWindowsNode() && this.isWin32AttrOn(4);
    }

    public String getFileType() {
        if (this.isRoot()) {
            return Messages.FSTreeNode_TypeLocalDisk;
        }
        if (this.isDirectory()) {
            return Messages.FSTreeNode_TypeFileFolder;
        }
        if (this.isSystem()) {
            return Messages.FSTreeNode_TypeSystemFile;
        }
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(this.name);
        if (contentType != null) {
            return contentType.getName();
        }
        int lastDot = this.name.lastIndexOf(".");
        if (lastDot == -1) {
            return Messages.FSTreeNode_TypeUnknownFile;
        }
        return String.valueOf(this.name.substring(lastDot + 1).toUpperCase()) + " " + Messages.FSTreeNode_TypeFile;
    }

    public void setAttributes(IFileSystem.FileAttrs attrs) {
        IFileSystem.FileAttrs oldAttrs = this.attr;
        this.attr = attrs;
        if (attrs != oldAttrs) {
            this.firePropertyChange(new PropertyChangeEvent(this, "attributes", oldAttrs, attrs));
        }
    }

    public CacheState getCacheState() {
        File file = CacheManager.getCacheFile(this);
        if (!file.exists()) {
            return CacheState.consistent;
        }
        FileState digest = PersistenceManager.getInstance().getFileDigest(this);
        return digest.getCacheState();
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        if (name == null && oldName != null || name != null && !name.equals(oldName)) {
            this.firePropertyChange(new PropertyChangeEvent(this, "name", oldName, name));
        }
    }

    @Override
    protected IChannelManager.DoneOpenChannel doCreateRefreshDoneOpenChannel(final ICallback callback) {
        final FileState digest = PersistenceManager.getInstance().getFileDigest(this);
        Callback cb = new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                if (status.isOK() && caller instanceof OpTargetFileDigest) {
                    digest.updateTargetDigest(((OpTargetFileDigest)caller).getDigest());
                }
                if (callback != null) {
                    callback.done(caller, status);
                }
            }
        };
        return new RefreshStateDoneOpenChannel(this, (ICallback)cb);
    }

    @Override
    protected IChannelManager.DoneOpenChannel doCreateQueryDoneOpenChannel(ICallback callback) {
        return new QueryDoneOpenChannel(this, callback);
    }

    @Override
    public FSTreeNode getParent() {
        return (FSTreeNode)this.parent;
    }
}

