/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.controls.FSTreeContentProvider;
import org.eclipse.tcf.te.tcf.filesystem.ui.controls.FSTreeViewerSorter;
import org.eclipse.tcf.te.tcf.filesystem.ui.interfaces.IFSConstants;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns.FSTreeElementLabelProvider;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.ui.trees.FilterDescriptor;
import org.eclipse.tcf.te.ui.trees.ViewerStateManager;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class FSOpenFileDialog
extends ElementTreeSelectionDialog {
    public FSOpenFileDialog(Shell parentShell) {
        this(parentShell, (ILabelProvider)new FSTreeElementLabelProvider(), (ITreeContentProvider)new FSTreeContentProvider());
    }

    private FSOpenFileDialog(Shell parentShell, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parentShell, FSOpenFileDialog.createDecoratingLabelProvider(labelProvider), contentProvider);
        this.setTitle(Messages.FSOpenFileDialog_title);
        this.setMessage(Messages.FSOpenFileDialog_message);
        this.setAllowMultiple(false);
        this.setStatusLineAboveButtons(false);
        this.setComparator((ViewerComparator)new FSTreeViewerSorter());
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                return FSOpenFileDialog.this.isValidSelection(selection);
            }
        });
    }

    public void setInput(Object input) {
        super.setInput(input);
        FilterDescriptor[] filterDescriptors = ViewerStateManager.getInstance().getFilterDescriptors(IFSConstants.ID_TREE_VIEWER_FS, input);
        if (filterDescriptors != null) {
            FilterDescriptor[] filterDescriptorArray = filterDescriptors;
            int n = filterDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                FilterDescriptor descriptor = filterDescriptorArray[n2];
                if (descriptor.isEnabled()) {
                    this.addFilter(descriptor.getFilter());
                }
                ++n2;
            }
        }
    }

    private static ILabelProvider createDecoratingLabelProvider(ILabelProvider labelProvider) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IDecoratorManager manager = workbench.getDecoratorManager();
        ILabelDecorator decorator = manager.getLabelDecorator();
        return new DecoratingLabelProvider(labelProvider, decorator);
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        TreeViewer viewer = super.doCreateTreeViewer(parent, style);
        viewer.getTree().setLinesVisible(false);
        return viewer;
    }

    IStatus isValidSelection(Object[] selection) {
        String pluginId = UIPlugin.getUniqueIdentifier();
        Status error = new Status(4, pluginId, null);
        if (selection == null || selection.length == 0) {
            return error;
        }
        if (!(selection[0] instanceof FSTreeNode)) {
            return error;
        }
        FSTreeNode target = (FSTreeNode)selection[0];
        if (!target.isFile()) {
            return error;
        }
        return new Status(0, pluginId, null);
    }
}

