/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.celleditor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Item;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.JobExecutor;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpRename;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.handlers.RenameCallback;

public class FSCellModifier
implements ICellModifier {
    public static final String PROPERTY_NAME = "name";

    public boolean canModify(Object element, String property) {
        if (property.equals(PROPERTY_NAME)) {
            FSTreeNode node;
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            if (element instanceof FSTreeNode && !(node = (FSTreeNode)element).isRoot()) {
                return node.isWindowsNode() && !node.isReadOnly() || !node.isWindowsNode() && node.isWritable();
            }
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        if (property.equals(PROPERTY_NAME)) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            if (element instanceof FSTreeNode) {
                FSTreeNode node = (FSTreeNode)element;
                return node.name;
            }
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        if (property.equals(PROPERTY_NAME)) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            if (element instanceof FSTreeNode) {
                FSTreeNode node = (FSTreeNode)element;
                Assert.isTrue((value != null && value instanceof String ? 1 : 0) != 0);
                String newName = (String)value;
                JobExecutor executor = new JobExecutor((ICallback)new RenameCallback());
                executor.execute((IOperation)new OpRename(node, newName));
            }
        }
    }
}

