/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.tabbed;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModelProvider;
import org.eclipse.tcf.te.tcf.ui.tabbed.BaseTitledSection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class BasicFolderSection
extends BaseTitledSection {
    private static final DecimalFormat SIZE_FORMAT = new DecimalFormat();
    protected FSTreeNode node;
    protected FSTreeNode clone;
    protected Text nameText;
    protected Text typeText;
    protected Text locationText;
    protected Text modifiedText;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.nameText = this.createTextField(null, Messages.GeneralInformationPage_Name);
        this.typeText = this.createTextField((Control)this.nameText, Messages.GeneralInformationPage_Type);
        this.locationText = this.createWrapTextField((Control)this.typeText, Messages.GeneralInformationPage_Location);
        this.modifiedText = this.createTextField((Control)this.locationText, Messages.GeneralInformationPage_Modified);
    }

    protected void updateInput(IPeerModelProvider input) {
        Assert.isTrue((boolean)(input instanceof FSTreeNode));
        this.node = (FSTreeNode)input;
        this.clone = (FSTreeNode)this.node.clone();
    }

    public void refresh() {
        this.nameText.setText(this.clone.name);
        this.typeText.setText(this.clone.getFileType());
        String location = this.clone.isRoot() ? Messages.GeneralInformationPage_Computer : this.clone.getLocation();
        this.locationText.setText(location);
        this.modifiedText.setText(this.getDateText(this.clone.attr.mtime));
        super.refresh();
    }

    protected String getDateText(long time) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
        return dateFormat.format(new Date(time));
    }

    protected String getSizeText(long size) {
        return NLS.bind((String)Messages.GeneralInformationPage_FileSizeInfo, (Object)SIZE_FORMAT.format(size / 1024L), (Object)SIZE_FORMAT.format(size));
    }

    protected String getText() {
        return Messages.BasicFolderSection_BasicInfoText;
    }
}

