/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.core.steps;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.te.core.utils.text.StringUtil;
import org.eclipse.tcf.te.launch.core.persistence.DefaultPersistenceDelegate;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.tcf.launch.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.launch.core.steps.AbstractTcfLaunchStep;
import org.eclipse.tcf.te.tcf.processes.core.launcher.ProcessLauncher;

public class LaunchProcessStep
extends AbstractTcfLaunchStep {
    public void validateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        String processImage = DefaultPersistenceDelegate.getAttribute((ILaunchConfiguration)this.getLaunchConfiguration(context), (String)"org.eclipse.tcf.te.launch.process_image", null);
        if (processImage == null || processImage.trim().length() <= 0) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing process image name"));
        }
        StepperAttributeUtil.setProperty((String)"org.eclipse.tcf.te.launch.process_image", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data, (Object)processImage);
        String processArguments = DefaultPersistenceDelegate.getAttribute((ILaunchConfiguration)this.getLaunchConfiguration(context), (String)"org.eclipse.tcf.te.launch.process_arguments", null);
        StepperAttributeUtil.setProperty((String)"org.eclipse.tcf.te.launch.process_arguments", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data, (Object)processArguments);
    }

    public void execute(IStepContext context, final IPropertiesContainer data, final IFullQualifiedId fullQualifiedId, IProgressMonitor monitor, ICallback callback) {
        IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.launch.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        ProcessLauncher launcher = new ProcessLauncher(channel);
        HashMap<String, Object> launchAttributes = new HashMap<String, Object>();
        launchAttributes.put("process.path", StepperAttributeUtil.getStringProperty((String)"org.eclipse.tcf.te.launch.process_image", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data));
        String arguments = StepperAttributeUtil.getStringProperty((String)"org.eclipse.tcf.te.launch.process_arguments", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        String[] args = arguments != null && !"".equals(arguments.trim()) ? StringUtil.tokenize((String)arguments, (int)0, (boolean)true) : null;
        launchAttributes.put("process.args", args);
        launchAttributes.put("localEcho", Boolean.FALSE);
        launchAttributes.put("process.associateConsole", Boolean.TRUE);
        if ("debug".equals(this.getLaunchMode(context))) {
            launchAttributes.put("process.attach", Boolean.TRUE);
        }
        PropertiesContainer container = new PropertiesContainer();
        container.setProperties(launchAttributes);
        launcher.launch(this.getActivePeerModel(data).getPeer(), (IPropertiesContainer)container, (ICallback)new Callback(callback){

            protected void internalDone(Object caller, IStatus status) {
                Object result = this.getResult();
                if (status.isOK() && result instanceof IProcesses.ProcessContext) {
                    StepperAttributeUtil.setProperty((String)"org.eclipse.tcf.te.launch.process_context", (IFullQualifiedId)fullQualifiedId.getParentId(), (IPropertiesContainer)data, (Object)result);
                }
                super.internalDone(caller, status);
            }
        });
    }
}

