/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.internal.columns;

import java.io.File;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.te.tcf.processes.core.model.ProcessTreeNode;
import org.eclipse.tcf.te.tcf.processes.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;
import org.eclipse.tcf.te.ui.trees.PendingAwareLabelProvider;

public class ProcessLabelProvider
extends PendingAwareLabelProvider {
    public String getText(Object element) {
        if (element instanceof ProcessTreeNode) {
            int slash;
            ProcessTreeNode node = (ProcessTreeNode)element;
            if (node.isSystemRoot()) {
                return Messages.ProcessLabelProvider_RootNodeLabel;
            }
            String name = node.name;
            if (name == null) {
                name = Messages.ProcessLabelProvider_NullNameNodeLabel;
            }
            if ((slash = name.lastIndexOf(File.separator)) != -1) {
                name = name.substring(slash + 1);
            }
            return name;
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof ProcessTreeNode) {
            ProcessTreeNode node = (ProcessTreeNode)element;
            if (node.isSystemRoot()) {
                return UIPlugin.getImage("OBJ_Process_Root");
            }
            ProcessTreeNode parent = node.getParent();
            if (parent.isSystemRoot()) {
                return UIPlugin.getImage("OBJ_Process");
            }
            return UIPlugin.getImage("OBJ_Thread");
        }
        return super.getImage(element);
    }
}

