/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.wizards;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.ui.wizards.pages.NewTargetWizardPage;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.views.ViewsUtil;
import org.eclipse.tcf.te.ui.wizards.AbstractWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewTargetWizard
extends AbstractWizard
implements INewWizard {
    private static final AtomicInteger counter = new AtomicInteger();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.NewTargetWizard_windowTitle);
    }

    public void addPages() {
        this.addPage((IWizardPage)new NewTargetWizardPage());
    }

    protected void extractData(IPropertiesContainer peerAttributes) {
        Assert.isNotNull((Object)peerAttributes);
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof IDataExchangeNode) {
                ((IDataExchangeNode)page).extractData(peerAttributes);
            }
            ++n2;
        }
    }

    public boolean performFinish() {
        PropertiesContainer peerAttributes = new PropertiesContainer();
        this.extractData((IPropertiesContainer)peerAttributes);
        if (peerAttributes.containsKey("ID")) {
            peerAttributes.setProperty("ID", (Object)UUID.randomUUID().toString());
        }
        if (!peerAttributes.containsKey("Name")) {
            peerAttributes.setProperty("Name", (Object)NLS.bind((String)Messages.NewTargetWizard_newPeer_name, (Object)counter.incrementAndGet()));
        }
        final HashMap<String, String> attrs = new HashMap<String, String>();
        for (Map.Entry entry : peerAttributes.getProperties().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            attrs.put((String)entry.getKey(), entry.getValue() instanceof String ? (String)entry.getValue() : entry.getValue().toString());
        }
        try {
            ILocatorModelRefreshService service;
            IURIPersistenceService persistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
            if (persistenceService == null) {
                throw new IOException("Persistence service instance unavailable.");
            }
            persistenceService.write((Object)new TransientPeer(attrs), null);
            final ILocatorModel model = Model.getModel();
            if (model != null && (service = (ILocatorModelRefreshService)model.getService(ILocatorModelRefreshService.class)) != null) {
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        service.refresh();
                        IPeerModel peerNode = ((ILocatorModelLookupService)model.getService(ILocatorModelLookupService.class)).lkupPeerModelById((String)attrs.get("ID"));
                        if (peerNode != null) {
                            ViewsUtil.refresh((String)"org.eclipse.tcf.te.ui.views.View");
                            StructuredSelection selection = new StructuredSelection((Object)peerNode);
                            ViewsUtil.setSelection((String)"org.eclipse.tcf.te.ui.views.View", (ISelection)selection);
                            ViewsUtil.openProperties((ISelection)selection);
                        }
                    }
                });
            }
        }
        catch (IOException e) {
            if (this.getContainer().getCurrentPage() instanceof WizardPage) {
                String message = NLS.bind((String)Messages.NewTargetWizard_error_savePeer, (Object)e.getLocalizedMessage());
                ((WizardPage)this.getContainer().getCurrentPage()).setMessage(message, 3);
                this.getContainer().updateMessage();
            }
            return false;
        }
        return true;
    }
}

