/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.dialogs;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.ui.activator.UIPlugin;
import org.eclipse.tcf.te.ui.internal.utils.TablePatternFilter;
import org.eclipse.tcf.te.ui.nls.Messages;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class FilteredCheckedListDialog
extends SelectionStatusDialog
implements ISelectionChangedListener {
    TablePatternFilter patternFilter;
    Text filterText;
    CheckboxTableViewer tableViewer;
    Button btnSelAll;
    Button btnDesAll;
    ILabelProvider labelProvider;
    String filter;
    Object[] elements;
    Set<Object> checkedItems = new HashSet<Object>();

    public FilteredCheckedListDialog(Shell shell) {
        super(shell);
    }

    public void setFilterText(String filterText) {
        this.filter = filterText;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void setElements(Object[] elements) {
        this.elements = elements;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        String description;
        IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
        Object element = structuredSelection.getFirstElement();
        String string = description = this.labelProvider instanceof IDescriptionProvider ? ((IDescriptionProvider)this.labelProvider).getDescription(element) : null;
        if (description == null) {
            description = element == null ? "" : "Enable " + this.labelProvider.getText(element) + ".";
        }
        this.updateStatus((IStatus)new Status(0, UIPlugin.getUniqueIdentifier(), description));
    }

    protected void computeResult() {
        this.setSelectionResult(this.checkedItems.toArray());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        this.createPatternFilterText(composite);
        this.createTable(composite);
        this.createSelBtn(composite);
        this.initializeData();
        return composite;
    }

    protected void getAccessibleName(AccessibleEvent e) {
        String filterTextString = this.filterText.getText();
        e.result = filterTextString.length() == 0 ? this.filter : filterTextString;
    }

    protected void filterTextFocusGained(FocusEvent e) {
        if (this.filter.equals(this.filterText.getText().trim())) {
            this.filterText.selectAll();
        }
    }

    protected void filterTextMouseUp(MouseEvent e) {
        if (this.filter.equals(this.filterText.getText().trim())) {
            this.filterText.selectAll();
        }
    }

    protected void filterTextKeyPressed(KeyEvent e) {
        boolean hasItems;
        boolean bl = hasItems = this.tableViewer.getTable().getItemCount() > 0;
        if (hasItems && e.keyCode == 0x1000002) {
            this.tableViewer.getTable().setFocus();
        }
    }

    protected void filterTextKeyTraversed(TraverseEvent e) {
        if (e.detail == 4) {
            e.doit = false;
            if (this.tableViewer.getTable().getItemCount() == 0) {
                Display.getCurrent().beep();
            } else {
                boolean textChanged;
                boolean hasFocus = this.tableViewer.getTable().setFocus();
                boolean bl = textChanged = !this.filter.equals(this.filterText.getText().trim());
                if (hasFocus && textChanged && this.filterText.getText().trim().length() > 0) {
                    TableItem[] items;
                    TableItem[] tableItemArray = items = this.tableViewer.getTable().getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (this.patternFilter.match(item.getText())) {
                            this.tableViewer.getTable().setSelection(new TableItem[]{item});
                            ISelection sel = this.tableViewer.getSelection();
                            this.tableViewer.setSelection(sel, true);
                            break;
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    protected void filterTextModifyText(ModifyEvent e) {
        this.patternFilter.setPattern(this.filterText.getText());
        this.tableViewer.refresh();
        for (Object item : this.checkedItems) {
            this.tableViewer.setChecked(item, true);
        }
    }

    protected void tableCheckStateChanged(CheckStateChangedEvent event) {
        if (event.getChecked()) {
            this.checkedItems.add(event.getElement());
        } else {
            this.checkedItems.remove(event.getElement());
        }
    }

    private void createPatternFilterText(Composite composite) {
        this.filterText = new Text(composite, 2052);
        GridData filterTextGridData = new GridData(768);
        this.filterText.setLayoutData((Object)filterTextGridData);
        this.filterText.setText(this.filter);
        this.filterText.setFont(composite.getFont());
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                FilteredCheckedListDialog.this.getAccessibleName(e);
            }
        });
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                FilteredCheckedListDialog.this.filterTextFocusGained(e);
            }
        });
        this.filterText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                FilteredCheckedListDialog.this.filterTextMouseUp(e);
            }
        });
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                FilteredCheckedListDialog.this.filterTextKeyPressed(e);
            }
        });
        this.filterText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                FilteredCheckedListDialog.this.filterTextKeyTraversed(e);
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilteredCheckedListDialog.this.filterTextModifyText(e);
            }
        });
    }

    private void createTable(Composite composite) {
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2816);
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FilteredCheckedListDialog.this.tableCheckStateChanged(event);
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 120;
        data.widthHint = 200;
        this.tableViewer.getTable().setLayoutData((Object)data);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.patternFilter = new TablePatternFilter(this.labelProvider);
        this.tableViewer.addFilter((ViewerFilter)this.patternFilter);
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void createSelBtn(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)data);
        this.btnSelAll = new Button(composite, 8);
        this.btnSelAll.setText(Messages.FilteredCheckedListDialog_SelAllText);
        this.btnSelAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteredCheckedListDialog.this.selectAll();
            }
        });
        this.btnDesAll = new Button(composite, 8);
        this.btnDesAll.setText(Messages.FilteredCheckedListDialog_DesAllText);
        this.btnDesAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteredCheckedListDialog.this.deselectAll();
            }
        });
    }

    void selectAll() {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.tableViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getData() != null && !item.getChecked()) {
                item.setChecked(true);
                this.checkedItems.add(item.getData());
            }
            ++n2;
        }
    }

    void deselectAll() {
        TableItem[] children;
        TableItem[] tableItemArray = children = this.tableViewer.getTable().getItems();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getData() != null && item.getChecked()) {
                item.setChecked(false);
                this.checkedItems.remove(item.getData());
            }
            ++n2;
        }
    }

    private void initializeData() {
        this.tableViewer.setInput((Object)this.elements);
        List selection = this.getInitialElementSelections();
        if (selection != null) {
            for (Object element : selection) {
                this.tableViewer.setChecked(element, true);
                this.checkedItems.add(element);
            }
        }
        this.filterText.forceFocus();
    }
}

