/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.dialogs;

import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.ui.interfaces.IContextHelpIds;
import org.eclipse.tcf.te.ui.jface.dialogs.CustomTitleAreaDialog;
import org.eclipse.tcf.te.ui.nls.Messages;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;

public class NameValuePairDialog
extends CustomTitleAreaDialog {
    private String name;
    private String value;
    private String dialogTitle;
    private String title;
    private String message;
    private String[] fieldLabels;
    private String[] initialValues;
    private Set<String> usedNames;
    private Text nameText;
    private Text valueText;

    public NameValuePairDialog(Shell shell, String dialogTitle, String title, String message, String[] fieldLabels, String[] initialValues, Set<String> usedNames) {
        super(shell, IContextHelpIds.NAME_VALUE_PAIR_DIALOG);
        Assert.isNotNull((Object)dialogTitle);
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)message);
        Assert.isNotNull((Object)fieldLabels);
        Assert.isNotNull((Object)initialValues);
        Assert.isNotNull(usedNames);
        this.dialogTitle = dialogTitle;
        this.title = title;
        this.message = message;
        this.fieldLabels = fieldLabels;
        this.initialValues = initialValues;
        this.usedNames = usedNames;
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = (Composite)super.createDialogArea(parent);
        this.setDialogTitle(this.dialogTitle);
        this.setTitle(this.title);
        this.setDefaultMessage(this.message, 0);
        Composite panel = new Composite(top, 0);
        panel.setLayout((Layout)new GridLayout(2, false));
        panel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label = new Label(panel, 0);
        label.setText(this.fieldLabels[0]);
        this.nameText = new Text(panel, 2052);
        this.nameText.setText(this.initialValues[0]);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.widthHint = 300;
        this.nameText.setLayoutData((Object)layoutData);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NameValuePairDialog.this.updateButtons();
            }
        });
        label = new Label(panel, 0);
        label.setText(this.fieldLabels[1]);
        this.valueText = new Text(panel, 2052);
        this.valueText.setText(this.initialValues[1]);
        layoutData = new GridData(768);
        layoutData.widthHint = 300;
        this.valueText.setLayoutData((Object)layoutData);
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NameValuePairDialog.this.updateButtons();
            }
        });
        NameValuePairDialog.applyDialogFont((Control)panel);
        return panel;
    }

    public String[] getNameValuePair() {
        return new String[]{this.name, this.value};
    }

    public void create() {
        super.create();
        this.updateButtons();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.name = SWTControlUtil.getText((Control)this.nameText).trim();
            this.value = SWTControlUtil.getText((Control)this.valueText).trim();
        } else {
            this.name = null;
            this.value = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void updateButtons() {
        String name = SWTControlUtil.getText((Control)this.nameText).trim();
        String value = SWTControlUtil.getText((Control)this.valueText).trim();
        if (name.trim().length() == 0) {
            this.setMessage(this.getErrorMissingName(), 1);
        } else if (this.usedNames.contains(name.trim())) {
            this.setMessage(NLS.bind((String)this.getErrorUsedOrIllegalName(), (Object)name), 3);
        } else if (value.trim().length() == 0) {
            this.setMessage(NLS.bind((String)this.getErrorMissingValue(), (Object)name), 1);
        } else {
            this.setMessage(this.message, 0);
        }
        this.getButton(0).setEnabled(this.getMessageType() == 0);
    }

    protected String getErrorMissingName() {
        return Messages.NameValuePairDialog_missingName_error;
    }

    protected String getErrorUsedOrIllegalName() {
        return Messages.NameValuePairDialog_usedOrIllegalName_error;
    }

    protected String getErrorMissingValue() {
        return Messages.NameValuePairDialog_missingValue_error;
    }
}

