/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.connector;

public class SVNProperty {
    public final String name;
    public final String value;
    public final byte[] binValue;

    public SVNProperty(String name, String value) {
        this.name = name;
        this.value = this.processTextProperty(value);
        this.binValue = value == null ? null : value.getBytes();
    }

    public SVNProperty(String name, byte[] value) {
        this.name = name;
        this.value = value == null ? null : new String(value);
        byte[] byArray = this.binValue = value == null ? null : new byte[value.length];
        if (value != null) {
            System.arraycopy(value, 0, this.binValue, 0, value.length);
        }
    }

    protected String processTextProperty(String str) {
        return str != null ? str.replaceAll("\r\n|\r", "\n") : null;
    }

    public static class BuiltIn {
        public static final String MIME_TYPE = "svn:mime-type";
        public static final String IGNORE = "svn:ignore";
        public static final String EOL_STYLE = "svn:eol-style";
        public static final String KEYWORDS = "svn:keywords";
        public static final String EXECUTABLE = "svn:executable";
        public static final String EXECUTABLE_VALUE = "*";
        public static final String EXTERNALS = "svn:externals";
        public static final String REV_AUTHOR = "svn:author";
        public static final String REV_LOG = "svn:log";
        public static final String REV_DATE = "svn:date";
        public static final String REV_ORIGINAL_DATE = "svn:original-date";
        public static final String NEEDS_LOCK = "svn:needs-lock";
    }
}

